/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.template;

import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.template.CreateTemplateConfCmd;
import com.els.base.inquiry.command.template.IsTemplateConfInUsedCmd;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.PropertyDefTplType;

public class ModifyTemplateConfCmd
extends AbstractInquiryCommand<String> {
    private TemplateConf templateConf;

    public ModifyTemplateConfCmd(TemplateConf templateConf) {
        this.templateConf = templateConf;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        Assert.isNotBlank(this.templateConf.getId(), "\u6a21\u677fId\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.isDeleteAble(this.templateConf.getId())) {
            invoker.getPropertyDefService().removeAllByTpl(this.templateConf.getId(), PropertyDefTplType.ORDER_ITEM.getCode());
            invoker.getPropertyDefService().removeAllByTpl(this.templateConf.getId(), PropertyDefTplType.BUSI_TYPE.getCode());
            invoker.getPropertyDefService().removeAllByTpl(this.templateConf.getId(), PropertyDefTplType.MOULD_TYPE.getCode());
            invoker.getTemplateConfService().deleteObjById(this.templateConf.getId());
        } else {
            invoker.getPropertyDefService().moveAllToHisByTpl(this.templateConf.getId(), PropertyDefTplType.ORDER_ITEM.getCode());
            invoker.getPropertyDefService().moveAllToHisByTpl(this.templateConf.getId(), PropertyDefTplType.BUSI_TYPE.getCode());
            invoker.getPropertyDefService().moveAllToHisByTpl(this.templateConf.getId(), PropertyDefTplType.MOULD_TYPE.getCode());
            TemplateConf tmp = new TemplateConf();
            tmp.setId(this.templateConf.getId());
            tmp.setIsHis(Constant.YES_INT);
            invoker.getTemplateConfService().modifyObj(tmp);
            this.templateConf.setId(null);
        }
        CreateTemplateConfCmd cmd = new CreateTemplateConfCmd(this.templateConf);
        cmd.copyProperties(this);
        return invoker.invoke(cmd);
    }

    private boolean isDeleteAble(String id) {
        IsTemplateConfInUsedCmd cmd = new IsTemplateConfInUsedCmd(id);
        return this.invoker.invoke(cmd) == false;
    }
}

