/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.exception.CommonException;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.pur.PublishCommand;
import com.els.base.inquiry.command.pur.ViewDetailCommand;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.PurOrderExample;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import java.util.List;
import java.util.stream.Collectors;

public class BatchPublishCommand
extends AbstractInquiryCommand<String> {
    private List<String> ids;

    public BatchPublishCommand(List<String> ids) {
        this.ids = ids;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        PurOrderExample example = new PurOrderExample();
        example.createCriteria().andIdIn((List)this.ids);
        List purOrders = invoker.getPurOrderService().queryAllObjByExample(example);
        for (PurOrder purOrder : purOrders) {
            if (InquiryOrderStatus.UNPUBLISHED.getCode().equals(purOrder.getInquiryOrderStatus())) continue;
            throw new CommonException(String.format("\u8be2\u4ef7\u5355[%s],\u5df2\u7ecf\u53d1\u5e03\uff0c\u4e0d\u7528\u91cd\u590d\u53d1\u5e03", purOrder.getOrderNo()));
        }
        List<PurOrder> completePurOrderList = this.ids.parallelStream().map(purOrderId -> {
            ViewDetailCommand command = new ViewDetailCommand((String)purOrderId);
            command.copyProperties(this);
            return invoker.invoke(command);
        }).collect(Collectors.toList());
        completePurOrderList.forEach(completePurOrder -> {
            PublishCommand cmd = new PublishCommand((PurOrder)completePurOrder);
            cmd.copyProperties(this);
            invoker.invoke(cmd);
        });
        return null;
    }
}

