/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.material.entity.Material;
import java.util.ArrayList;
import java.util.List;

public class PreviewTargeListCommand
extends AbstractInquiryCommand<List<ITarget>> {
    private String templateId;
    private List<Material> materialList;

    public PreviewTargeListCommand(String templateId, List<Material> materialList) {
        this.templateId = templateId;
        this.materialList = materialList;
    }

    @Override
    public List<ITarget> execute(InquiryCommandInvoker invoker) {
        Assert.isNotBlank(this.templateId, "\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(this.materialList, "\u7269\u6599\u4e0d\u80fd\u4e3a\u7a7a");
        TemplateConf templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(this.templateId);
        ArrayList<ITarget> targets = new ArrayList<ITarget>();
        Class<? extends ITarget> clazz = templateConf.getTargetClass();
        for (Material material : this.materialList) {
            ITarget target;
            try {
                target = clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new CommonException(String.format("\u8f6c\u6210\u8be2\u4ef7\u5355\u7269\u6599\u51fa\u9519,\u4e0d\u5b58\u5728\u7c7b[%s]", templateConf.getTargetClassName()), e);
            }
            target.buildFromMaterial(this.templateId, material);
            targets.add(target);
        }
        return targets;
    }
}

