/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.utils;

import com.els.base.core.exception.CommonException;
import com.els.base.inquiry.IExtendable;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.PropertyValue;
import com.els.base.inquiry.entity.PropertyValueExample;
import com.els.base.inquiry.service.PropertyValueService;
import com.els.base.inquiry.utils.ClassReflectionUtils;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.excel.ConverterFactory;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.json.JsonUtils;
import com.els.base.utils.reflect.ReflectUtils;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public abstract class PropertyValueUtils {
    public static String validStr(String valueStr, String typeName, String proCode) {
        switch (typeName) {
            case "string": 
            case "dic_group": {
                return valueStr;
            }
            case "boolean": {
                if (StringUtils.isBlank((String)valueStr)) {
                    return null;
                }
                if (StringUtils.isNotBlank((String)(valueStr = valueStr.trim().toLowerCase())) && !"true".equals(valueStr) && !"false".equals(valueStr)) {
                    throw new CommonException(String.format("\u6570\u636e\u7684\u7c7b\u578b\u662fboolean,\u8f93\u5165\u7684\u683c\u5f0f\u6709\u8bef\u3002\u5c5e\u6027\u540d[%s],\u5c5e\u6027\u503c[%s]", proCode, valueStr));
                }
                return valueStr;
            }
            case "number": {
                if (StringUtils.isBlank((String)valueStr)) {
                    return null;
                }
                if (!(valueStr = valueStr.trim()).matches("^\\d+(\\.\\d+)?$")) {
                    throw new CommonException(String.format("\u6570\u636e\u7684\u7c7b\u578b\u662fnumber,\u8f93\u5165\u7684\u683c\u5f0f\u6709\u8bef\u3002\u5c5e\u6027\u540d[%s],\u5c5e\u6027\u503c[%s]", proCode, valueStr));
                }
                return valueStr;
            }
            case "date": {
                if (StringUtils.isBlank((String)valueStr)) {
                    return null;
                }
                if (!((valueStr = valueStr.trim()).matches("\\d+") || valueStr.matches("\\d+-\\d+-\\d+\\s\\d+:\\d+:\\d+") || valueStr.matches("\\d+-\\d+-\\d+"))) {
                    throw new CommonException(String.format("\u6570\u636e\u7684\u7c7b\u578b\u662fdate,\u8f93\u5165\u7684\u683c\u5f0f\u6709\u8bef\u3002\u5c5e\u6027\u540d[%s],\u5c5e\u6027\u503c[%s]", proCode, valueStr));
                }
                return valueStr;
            }
        }
        return valueStr;
    }

    public static Object parseStr(String valueStr, String typeName, String proCode) {
        if (valueStr == null) {
            return valueStr;
        }
        switch (typeName) {
            case "string": 
            case "dic_group": {
                return valueStr;
            }
            case "boolean": {
                valueStr = valueStr.trim().toLowerCase();
                if ("true".equals(valueStr) || "false".equals(valueStr)) {
                    return Boolean.valueOf(valueStr);
                }
                return Boolean.FALSE;
            }
            case "number": {
                valueStr = valueStr.trim();
                if (StringUtils.isBlank((String)valueStr)) {
                    return null;
                }
                return new BigDecimal(valueStr);
            }
            case "date": {
                if (StringUtils.isBlank((String)valueStr)) {
                    return null;
                }
                valueStr = valueStr.trim();
                try {
                    if (valueStr.matches("\\d+")) {
                        return new Date(Long.valueOf(valueStr));
                    }
                    if (valueStr.matches("\\d+-\\d+-\\d+\\s\\d+:\\d+:\\d+")) {
                        return DateUtils.parseDate((String)valueStr, (String[])new String[]{"yyyy-mm-dd hh:MM:ss"});
                    }
                    if (valueStr.matches("\\d+-\\d+-\\d+")) {
                        return DateUtils.parseDate((String)valueStr, (String[])new String[]{"yyyy-mm-dd"});
                    }
                    break;
                }
                catch (ParseException e) {
                    throw new RuntimeException(String.format("\u5c5e\u6027\u89e3\u6790\u5931\u8d25, \u5c5e\u6027[%s],\u503c[%s]", proCode, valueStr), e);
                }
            }
        }
        return null;
    }

    public static void queryAndSetValue(List<? extends IExtendable> extendableList, String tplType) {
        if (CollectionUtils.isEmpty(extendableList)) {
            return;
        }
        List targetIdList = extendableList.stream().map(IExtendable::getId).collect(Collectors.toList());
        PropertyValueExample propertyValueExample = new PropertyValueExample();
        propertyValueExample.createCriteria().andRefIdIn(targetIdList).andTplTypeEqualTo(tplType);
        PropertyValueService propertyValueService = (PropertyValueService)SpringContextHolder.getOneBean(PropertyValueService.class);
        List propertyValueList = propertyValueService.queryAllObjByExample(propertyValueExample);
        if (CollectionUtils.isEmpty(propertyValueList)) {
            return;
        }
        Map<String, List<PropertyValue>> refIdAndValueMap = propertyValueList.stream().collect(Collectors.groupingBy(PropertyValue::getRefId));
        extendableList.forEach(target -> target.setPropertyValueList((List)refIdAndValueMap.get(target.getId())));
    }

    public static void deleteByExtenable(List<String> idList, String tplType) {
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        PropertyValueExample propertyValueExample = new PropertyValueExample();
        propertyValueExample.createCriteria().andRefIdIn((List)idList).andTplTypeEqualTo(tplType);
        PropertyValueService propertyValueService = (PropertyValueService)SpringContextHolder.getOneBean(PropertyValueService.class);
        propertyValueService.deleteByExample(propertyValueExample);
    }

    public static void addPropertyValue(List<? extends IExtendable> extendables, String tplType) {
        if (CollectionUtils.isEmpty(extendables)) {
            return;
        }
        List<PropertyValue> totalPropertyValueList = extendables.stream().filter(target -> CollectionUtils.isNotEmpty(target.getPropertyValueList())).flatMap(target -> {
            target.getPropertyValueList().forEach(propertyValue -> {
                propertyValue.setRefId(target.getId());
                propertyValue.setTplType(tplType);
            });
            return target.getPropertyValueList().stream();
        }).collect(Collectors.toList());
        totalPropertyValueList = totalPropertyValueList.stream().distinct().collect(Collectors.toList());
        PropertyValueService propertyValueService = (PropertyValueService)SpringContextHolder.getOneBean(PropertyValueService.class);
        propertyValueService.addAll(totalPropertyValueList);
    }

    public static void setValueToInstance(Object instance, Field field, String valueStr) throws Exception {
        if (valueStr == null || "null".equals(valueStr.toLowerCase())) {
            return;
        }
        StrToObjConverter converter = ConverterFactory.getDefaultToObjConverter(field.getType());
        if (converter != null) {
            ReflectUtils.setValue((Object)instance, (String)field.getName(), (Object)converter.convert(valueStr, null, null));
            return;
        }
        if (field.getType().equals(String.class)) {
            ReflectUtils.setValue((Object)instance, (String)field.getName(), (Object)valueStr);
            return;
        }
        if (StringUtils.isBlank((String)valueStr)) {
            return;
        }
        if (field.getType().equals(List.class)) {
            Type genericType = field.getGenericType();
            if (genericType == null) {
                ReflectUtils.setValue((Object)instance, (String)field.getName(), (Object)JsonUtils.convertValue((String)valueStr, field.getType()));
            } else if (!(genericType instanceof ParameterizedType)) {
                ReflectUtils.setValue((Object)instance, (String)field.getName(), (Object)JsonUtils.convertValue((String)valueStr, field.getType()));
            } else {
                Class genericClazz = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                JavaType javaType = JsonUtils.getObjectMapper().getTypeFactory().constructParametrizedType(List.class, null, new Class[]{genericClazz});
                Object valueObj = JsonUtils.getObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(valueStr.toString(), javaType);
                ReflectUtils.setValue((Object)instance, (String)field.getName(), (Object)valueObj);
            }
        } else {
            ReflectUtils.setValue((Object)instance, (String)field.getName(), (Object)JsonUtils.convertValue((String)valueStr, field.getType()));
        }
    }

    public static <T extends IExtendable> List<PropertyValue> getDefaultPropertyValue(T value) {
        List<Field> fieldList = ClassReflectionUtils.getPrimitiveField(value.getClass());
        List<PropertyDef> defList = value.getPropertyDefList();
        defList = defList.stream().filter(def -> fieldList.stream().noneMatch(field -> field.getName().equals(def.getCode()))).collect(Collectors.toList());
        List<PropertyValue> temp2 = defList.stream().map(proDef -> {
            PropertyValue proValue = proDef.buildValue();
            proValue.setRefId(value.getId());
            return proValue;
        }).collect(Collectors.toList());
        return temp2;
    }
}

