/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.dao.InquiryWaitMaterialMapper;
import com.els.base.inquiry.entity.InquiryWaitMaterial;
import com.els.base.inquiry.entity.InquiryWaitMaterialExample;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.service.InquiryWaitMaterialService;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.web.vo.WaitMaterialTransformVo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultInquiryWaitMaterialService")
public class InquiryWaitMaterialServiceImpl
implements InquiryWaitMaterialService {
    @Resource
    protected InquiryWaitMaterialMapper inquiryWaitMaterialMapper;
    @Resource
    private TemplateConfService templateConfService;

    @Override
    @CacheEvict(value={"inquiryWaitMaterial"}, allEntries=true)
    public void addObj(InquiryWaitMaterial t) {
        this.inquiryWaitMaterialMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"inquiryWaitMaterial"}, allEntries=true)
    public void deleteObjById(String id) {
        this.inquiryWaitMaterialMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"inquiryWaitMaterial"}, allEntries=true)
    public void modifyObj(InquiryWaitMaterial t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.inquiryWaitMaterialMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"inquiryWaitMaterial"}, keyGenerator="redisKeyGenerator")
    public InquiryWaitMaterial queryObjById(String id) {
        return this.inquiryWaitMaterialMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"inquiryWaitMaterial"}, keyGenerator="redisKeyGenerator")
    public List<InquiryWaitMaterial> queryAllObjByExample(InquiryWaitMaterialExample example) {
        return this.inquiryWaitMaterialMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"inquiryWaitMaterial"}, keyGenerator="redisKeyGenerator")
    public PageView<InquiryWaitMaterial> queryObjByPage(InquiryWaitMaterialExample example) {
        PageView<InquiryWaitMaterial> pageView = example.getPageView();
        pageView.setQueryResult(this.inquiryWaitMaterialMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public List<ITarget> transformToPurOrderMaterial(WaitMaterialTransformVo waitMaterialTransformVo) {
        ArrayList<ITarget> targets = null;
        if (waitMaterialTransformVo != null && StringUtils.isNotBlank((String)waitMaterialTransformVo.getTemplateId()) && CollectionUtils.isNotEmpty(waitMaterialTransformVo.getMaterials())) {
            TemplateConf templateConf = (TemplateConf)this.templateConfService.queryObjById(waitMaterialTransformVo.getTemplateId());
            String className = templateConf.getTargetClassName();
            targets = new ArrayList<ITarget>();
            try {
                Class<?> clazz = Class.forName(className);
                for (InquiryWaitMaterial inquiryWaitMaterial : waitMaterialTransformVo.getMaterials()) {
                    ITarget target = (ITarget)clazz.newInstance();
                    target.buildFromWaitMaterial(waitMaterialTransformVo.getTemplateId(), inquiryWaitMaterial);
                    targets.add(target);
                }
            }
            catch (ClassNotFoundException e) {
                throw new CommonException(String.format("\u8f6c\u6210\u8be2\u4ef7\u5355\u7269\u6599\u51fa\u9519,\u4e0d\u5b58\u5728\u7c7b[%s]", className), e);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CommonException("\u5f85\u8be2\u4ef7\u6e05\u5355\u8f6c\u6210\u8be2\u4ef7\u5355\u7269\u6599\u5931\u8d25");
            }
        }
        return targets;
    }

    @Override
    @CacheEvict(value={"inquiryWaitMaterial"}, keyGenerator="redisKeyGenerator")
    public void initDataFromPLM(String param1) throws Exception {
        Assert.isNotBlank(param1, "\u63a8\u9001\u7684\u6570\u636e\u4e3a\u7a7a");
        JSONObject job = JSONObject.fromObject((Object)param1);
        Assert.isNotNull(job, "PLM\u63a8\u9001\u6570\u636e\u8f6c\u6362json\u5931\u8d25");
        Assert.isNotNull(job.get("supGuaranteeEndTime"), "\u4f9b\u5e94\u4fdd\u969c\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(job.get("applyDate"), "\u7533\u8bf7\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(job.get("finishDate"), "\u5b8c\u6210\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        SimpleDateFormat simple = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        InquiryWaitMaterial waitMaterial = new InquiryWaitMaterial();
        waitMaterial.setSupGuaranteeEndTime(simple.parse((String)job.get("supGuaranteeEndTime")));
        waitMaterial.setApplyDate(simple.parse((String)job.get("applyDate")));
        waitMaterial.setFinishDate(simple.parse((String)job.get("finishDate")));
        waitMaterial.setModelName((String)job.get("modelName"));
        waitMaterial.setMaterialCode((String)job.get("materialCode"));
        waitMaterial.setSpecificationDesc((String)job.get("specificationDesc"));
        waitMaterial.setItemName((String)job.get("itemName"));
        waitMaterial.setBrand((String)job.get("brand"));
        waitMaterial.setMaterials((String)job.get("materials"));
        waitMaterial.setReferToItemNo((String)job.get("referToItemNo"));
        waitMaterial.setUnit((String)job.get("unit"));
        waitMaterial.setSimpleUsedAmount((Integer)job.get("simpleUsedAmount"));
        waitMaterial.setOriginalModelOrName((String)job.get("originalModelOrName"));
        waitMaterial.setDeviceLevel((String)job.get("deviceLevel"));
        waitMaterial.setTechnologyUndertake((String)job.get("technologyUndertake"));
        waitMaterial.setAttachments((String)job.get("attachments"));
        waitMaterial.setIsCreateInquiryOrder(Constant.NO_INT);
        this.inquiryWaitMaterialMapper.insertSelective(waitMaterial);
    }

    @Override
    @CacheEvict(value={"inquiryWaitMaterial"}, allEntries=true)
    public void modifyByExample(InquiryWaitMaterial waitMaterial, InquiryWaitMaterialExample example) {
        this.inquiryWaitMaterialMapper.updateByExampleSelective(waitMaterial, example);
    }

    @Override
    @CacheEvict(value={"inquiryWaitMaterial"}, allEntries=true)
    public void batchInsertWaitMaterial(List<InquiryWaitMaterial> waitMaterials) {
        for (InquiryWaitMaterial waitMaterial : waitMaterials) {
            this.addObj(waitMaterial);
        }
    }
}

