/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.SyncPriceService;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.InquirySupOrderExample;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryAuditStatus;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import com.els.base.inquiry.enumclass.MessageNotify;
import com.els.base.inquiry.enumclass.OperationTypeEnum;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.utils.SpringContextHolder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ApprovePassCommand
extends AbstractInquiryCommand<String> {
    private String purOrderId;

    public ApprovePassCommand(String purOrderId) {
        this.purOrderId = purOrderId;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        Assert.isNotBlank((String)this.purOrderId, (String)"\u8be2\u4ef7\u5355Id\u4e3a\u7a7a");
        PurOrder purOrder = (PurOrder)invoker.getPurOrderService().queryObjById(this.purOrderId);
        List<InquirySupOrder> supOrders = this.modifySupOrderStatus(purOrder);
        this.modifPurOrderStatus(purOrder);
        SyncPriceService syncPriceService = (SyncPriceService)SpringContextHolder.getOneBean(SyncPriceService.class);
        if (syncPriceService == null) {
            throw new CommonException("\u7cfb\u7edf\u8fd8\u6ca1\u6709\u542f\u52a8\u4ef7\u683c\u56de\u5199\u5230sap\u7684\u914d\u7f6e");
        }
        syncPriceService.sendData(this.purOrderId);
        this.sendMsg(purOrder.getOrderNo(), purOrder.getPurUserId(), purOrder.getPurCompanyId());
        supOrders.forEach(supOrder -> this.sendMsg(purOrder.getOrderNo(), supOrder.getSupUserId(), supOrder.getSupCompanySrmCode()));
        return null;
    }

    private void modifPurOrderStatus(PurOrder purOrder) {
        PurOrder temp = new PurOrder();
        temp.setId(purOrder.getId());
        temp.setAuditStatus(InquiryAuditStatus.AUDIT_PASS.getCode());
        temp.setInquiryOrderStatus(InquiryOrderStatus.FINISHED.getCode());
        this.invoker.getPurOrderService().modifyObj(temp);
    }

    private void sendMsg(String orderNo, String userId, String companyCode) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("orderNo", orderNo);
        Message msg = Message.init(data).setCompanyCode(companyCode).setBusinessTypeCode(MessageNotify.INQUIRY_ORDER_APPROVE_PASS.getCode()).addReceiverId(userId).setMsgLevel(MessageLevelEnum.HIGH);
        MessageSendUtils.sendMessage((Message)msg);
    }

    private List<InquirySupOrder> modifySupOrderStatus(PurOrder purOrder) {
        TemplateConf templateConf = (TemplateConf)this.invoker.getTemplateConfService().queryObjById(purOrder.getTemplateId());
        List<IOrderItem> orderItems = templateConf.getOrderItemService().queryByPurOrderId(purOrder.getId());
        InquirySupOrderExample example = new InquirySupOrderExample();
        example.createCriteria().andPurOrderIdEqualTo(purOrder.getId());
        List supOrderList = this.invoker.getInquirySupOrderService().queryAllObjByExample((IExample)example);
        for (InquirySupOrder inquirySupOrder : supOrderList) {
            InquirySupOrder temp = new InquirySupOrder();
            temp.setId(inquirySupOrder.getId());
            temp.setInquiryOrderStatus(this.getStatus(inquirySupOrder, orderItems));
            temp.setAuditStatus(InquiryAuditStatus.AUDIT_PASS.getCode());
            this.invoker.getInquirySupOrderService().modifyObj(temp);
        }
        return supOrderList;
    }

    private Integer getStatus(InquirySupOrder supOrder, List<IOrderItem> orderItems) {
        Map<Integer, Long> operationAndItemGroup = (orderItems = orderItems.parallelStream().filter(orderItem -> orderItem.getSupOrderId().equals(supOrder.getId())).filter(orderItem -> OperationTypeEnum.isPricingOperation(orderItem.getOperation())).collect(Collectors.toList())).stream().collect(Collectors.groupingBy(IOrderItem::getOperation, Collectors.counting()));
        Long acceptCount = operationAndItemGroup.get(OperationTypeEnum.ACCEPTED.getCode());
        if (acceptCount == null) {
            acceptCount = 0L;
        }
        if (acceptCount == 0L) {
            return InquiryOrderStatus.REFUSED.getCode();
        }
        if (acceptCount.intValue() == orderItems.size()) {
            return InquiryOrderStatus.ACCEPTED.getCode();
        }
        return InquiryOrderStatus.ACCEPT_SECTION.getCode();
    }
}

