/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IMould;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquiryQuoteLadder;
import com.els.base.inquiry.entity.InquiryQuoteLadderExample;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.InquirySupOrderExample;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryLadderBelongType;
import com.els.base.inquiry.enumclass.InquiryQuoteLadderType;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.enumclass.MessageNotify;
import com.els.base.inquiry.enumclass.OperationTypeEnum;
import com.els.base.inquiry.utils.PropertyValueUtils;
import com.els.base.inquiry.web.vo.ReQuoteVo;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

public class BatchReQuoteCommand
extends AbstractInquiryCommand<String> {
    private ReQuoteVo vo;
    private TemplateConf templateConf;

    public BatchReQuoteCommand(ReQuoteVo vo) {
        this.vo = vo;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        Assert.isNotNull((Object)this.vo);
        Assert.isNotEmpty(this.vo.getIds(), (String)"\u8be2\u4ef7\u5355\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.vo.getPurOrderId(), (String)"\u8be2\u4ef7\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        PurOrder purOrder = (PurOrder)invoker.getPurOrderService().queryObjById(this.vo.getPurOrderId());
        this.templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(purOrder.getTemplateId());
        List<IOrderItem> orderItemList = this.vo.getIds().parallelStream().distinct().map(orderItemId -> (IOrderItem)this.templateConf.getOrderItemService().queryObjById(orderItemId)).collect(Collectors.toList());
        orderItemList.forEach(orderItem -> this.valid((IOrderItem)orderItem));
        List<String> supOrderIdList = orderItemList.stream().map(IOrderItem::getSupOrderId).distinct().collect(Collectors.toList());
        List materialDescList = orderItemList.stream().map(item -> item.getMaterialDesc()).collect(Collectors.toList());
        List<ITarget> tempTargetList = this.templateConf.getTargetService().queryByPurOrderId(purOrder.getId());
        List<ITarget> targetList = tempTargetList.stream().filter(target -> target.getMaterialDesc().equals(materialDescList.get(0))).collect(Collectors.toList());
        for (IOrderItem item2 : orderItemList) {
            this.deletePrice(item2);
            this.templateConf.getOrderItemService().deleteObjById(item2.getId());
        }
        List<IOrderItem> itemList = this.addOrderItemList(purOrder, supOrderIdList, targetList);
        InquirySupOrderExample supOrderExample = new InquirySupOrderExample();
        supOrderExample.createCriteria().andIdIn((List)supOrderIdList);
        InquirySupOrder temp = new InquirySupOrder();
        temp.setQuoteStatus(InquiryQuoteStatus.REQUOTE.getCode());
        this.invoker.getInquirySupOrderService().modifyByExample(temp, supOrderExample);
        List<IMould> mouldList = this.templateConf.getMouldService().queryByPurOrderId(purOrder.getId());
        if (CollectionUtils.isEmpty(mouldList)) {
            itemList.forEach(orderItem -> this.reset((IOrderItem)orderItem, null));
        } else {
            itemList.forEach(orderItem -> mouldList.forEach(mould -> {
                if (StringUtils.isNotBlank((String)mould.getMaterialDesc()) && mould.getSupOrderId().equals(orderItem.getSupOrderId()) && mould.getMaterialDesc().equals(orderItem.getMaterialDesc())) {
                    this.reset((IOrderItem)orderItem, (IMould)mould);
                } else {
                    this.reset((IOrderItem)orderItem, null);
                }
            }));
        }
        PurOrder tempPurOrder = new PurOrder();
        tempPurOrder.setId(this.vo.getPurOrderId());
        tempPurOrder.setQuoteStatus(InquiryQuoteStatus.REQUOTE.getCode());
        this.invoker.getPurOrderService().modifyObj(tempPurOrder);
        supOrderIdList.parallelStream().forEach(supordrId -> {
            InquirySupOrder supOrder = (InquirySupOrder)invoker.getInquirySupOrderService().queryObjById(supordrId);
            this.sendMsg((String)supordrId, supOrder.getOrderNo(), supOrder.getSupUserId());
        });
        return null;
    }

    private void deletePrice(IOrderItem item) {
        try {
            List orderItemList = this.templateConf.getOrderItemService().queryBySupOrderId(item.getSupOrderId());
            for (IOrderItem orderItem : orderItemList) {
                if (orderItem.getTotalAmount() == null || item.getUntaxedUnitPrice() == null) continue;
                IOrderItem tempOrderItem = this.templateConf.getOrderItemClass().newInstance();
                tempOrderItem.setId(orderItem.getId());
                tempOrderItem.setTotalAmount(orderItem.getTotalAmount().subtract(item.getUntaxedUnitPrice()));
                this.templateConf.getOrderItemService().modifyObj(tempOrderItem);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<IOrderItem> addOrderItemList(PurOrder order, List<String> supOrderIdList, List<ITarget> targetList) {
        Assert.isNotEmpty(targetList, (String)"\u83b7\u53d6\u4e0d\u5230\u7269\u6599\u6e05\u5355");
        List supOrderList = supOrderIdList.stream().map(supOrderId -> (InquirySupOrder)this.invoker.getInquirySupOrderService().queryObjById(supOrderId)).collect(Collectors.toList());
        List<IOrderItem> allOrderItemList = supOrderList.parallelStream().flatMap(supOrder -> targetList.stream().map(target -> {
            Class<? extends IOrderItem> orderItemCls = this.templateConf.getOrderItemClass();
            IOrderItem orderItem = null;
            try {
                orderItem = orderItemCls.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            orderItem.build(order, (InquirySupOrder)supOrder, (ITarget)target);
            return orderItem;
        })).collect(Collectors.toList());
        int purOrderIndex = 1;
        for (IOrderItem orderItem : allOrderItemList) {
            orderItem.setOrderItemNo(purOrderIndex++);
        }
        this.templateConf.getOrderItemService().addAll(allOrderItemList);
        this.addOrderItemQuoteLadderList(allOrderItemList, targetList);
        if (Constant.YES_INT.equals(this.templateConf.getIsOrderItemDetailEnable())) {
            this.addOrderItemDetail(allOrderItemList);
        }
        return allOrderItemList;
    }

    private void addOrderItemQuoteLadderList(List<IOrderItem> allOrderItemList, List<ITarget> targetList) {
        Stream stream = allOrderItemList.stream().flatMap(orderItem -> targetList.stream().filter(target -> InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(target.getQuoteType())).filter(target -> {
            List<InquiryQuoteLadder> ladders = this.invoker.getInquiryQuoteLadderService().queryByTargetId(target.getId());
            if (CollectionUtils.isNotEmpty(ladders)) {
                target.setInquiryQuoteLadders(ladders);
            }
            return CollectionUtils.isNotEmpty(target.getInquiryQuoteLadders());
        }).filter(target -> target.getId().equals(orderItem.getTargetId())).flatMap(target -> target.getInquiryQuoteLadders().stream().map(ladder -> {
            InquiryQuoteLadder inquiryQuoteLadder = new InquiryQuoteLadder();
            BeanUtils.copyProperties((Object)ladder, (Object)inquiryQuoteLadder);
            inquiryQuoteLadder.setId(null);
            inquiryQuoteLadder.setBelongType(InquiryLadderBelongType.BELONG_TO_ITEM.getCode());
            inquiryQuoteLadder.setItemId(orderItem.getId());
            inquiryQuoteLadder.setCreateCompanyType("PUR");
            return inquiryQuoteLadder;
        })));
        this.invoker.getInquiryQuoteLadderService().addAll(stream.collect(Collectors.toList()));
    }

    private void addOrderItemDetail(List<IOrderItem> allOrderItemList) {
        if (CollectionUtils.isEmpty(allOrderItemList)) {
            return;
        }
        List detailList = allOrderItemList.stream().map(item -> {
            IOrderItemDetail detail = null;
            try {
                detail = this.templateConf.getTplOrderItemDetail().getOrderItemDetailClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            detail.build((IOrderItem)item);
            detail.setTemplateId(this.templateConf.getTplOrderItemDetail().getId());
            detail.setPropertyValueList(PropertyValueUtils.getDefaultPropertyValue(detail));
            return detail;
        }).collect(Collectors.toList());
        this.templateConf.getTplOrderItemDetail().getOrderItemDetailService().addAll(detailList);
    }

    private void reset(IOrderItem orderItem, IMould mould) {
        try {
            IOrderItem temp = this.templateConf.getOrderItemClass().newInstance();
            temp.setId(orderItem.getId());
            temp.setQuotationStatus(InquiryQuoteStatus.REQUOTE.getCode());
            temp.setOperation(OperationTypeEnum.NO_OPERATION.getCode());
            temp.setUntaxedUnitPrice(BigDecimal.ZERO);
            this.templateConf.getOrderItemService().modifyStatus(temp);
            if (mould != null) {
                IMould tempMould = this.templateConf.getMouldClass().newInstance();
                tempMould.setId(mould.getId());
                tempMould.setRowStatus(OperationTypeEnum.BATCH_RE_QUOTE.getCode());
                tempMould.setMaterialDesc(mould.getMaterialDesc());
                this.templateConf.getMouldService().modifyStatus(tempMould);
            }
            if (!InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(orderItem.getQuoteType())) {
                return;
            }
            InquiryQuoteLadderExample example = new InquiryQuoteLadderExample();
            example.createCriteria().andItemIdEqualTo(orderItem.getId()).andBelongTypeEqualTo(InquiryLadderBelongType.BELONG_TO_ITEM.getCode());
            InquiryQuoteLadder tempLadder = new InquiryQuoteLadder();
            tempLadder.setUntaxedUnitPrice(BigDecimal.ZERO);
            this.invoker.getInquiryQuoteLadderService().modifyByExample(tempLadder, example);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private void sendMsg(String supOrderId, String orderNo, String supUserId) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("inquirySupOrderId", supOrderId);
        data.put("orderNo", orderNo);
        Message msg = Message.init(data).setCompanyCode(this.getPurCompany().getCompanyCode()).setBusinessTypeCode(MessageNotify.INQUIRY_ORDER_REQUOTE.getCode()).setSenderId(this.getPurUser().getId()).addReceiverId(supUserId).setMsgLevel(MessageLevelEnum.HIGH);
        MessageSendUtils.sendMessage((Message)msg);
    }

    private void valid(IOrderItem orderItem) {
        if (!this.vo.getPurOrderId().equals(orderItem.getPurOrderId())) {
            throw new CommonException("\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u91cd\u62a5\u4ef7\u7684\u8be2\u4ef7\u5355\u8fdb\u884c\u91cd\u62a5\u4ef7");
        }
        if (!InquiryQuoteStatus.QUOTED.getCode().equals(orderItem.getQuotationStatus()) && !InquiryQuoteStatus.REQUOTED.getCode().equals(orderItem.getQuotationStatus())) {
            throw new CommonException("\u53ea\u6709\u5904\u4e8e\u5df2\u62a5\u4ef7\u6216\u5df2\u91cd\u62a5\u72b6\u6001\u4e0b\u7684\u884c\u624d\u80fd\u6267\u884c\u91cd\u62a5\u4ef7\u64cd\u4f5c");
        }
    }
}

