/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.SyncPriceService;
import com.els.base.inquiry.command.pur.ViewPricingDetailCommand;
import com.els.base.inquiry.entity.InformationRecord;
import com.els.base.inquiry.entity.InformationRecordExample;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.OrderItemM001;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.SystemPrice;
import com.els.base.inquiry.enumclass.OperationTypeEnum;
import com.els.base.material.entity.SupplierMaterial;
import com.els.base.material.entity.SupplierMaterialExample;
import com.els.base.material.service.SupplierMaterialService;
import com.els.base.utils.SpringContextHolder;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class SyncPriceToSapCmd
extends AbstractInquiryCommand<String> {
    private String purOrderId;

    public SyncPriceToSapCmd(String purOrderId) {
        this.purOrderId = purOrderId;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        PurOrder purOrder = invoker.invoke(new ViewPricingDetailCommand(this.purOrderId));
        Assert.isNotNull((Object)purOrder, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purOrder.getId(), (String)"\u4f20\u5165\u7684\u91c7\u8d2d\u5546\u8868\u5934ID\u4e3a\u7a7a");
        Assert.isNotEmpty(purOrder.getItemList(), (String)"\u4f20\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u53cd\u5199sap\u5931\u8d25");
        InformationRecordExample example = new InformationRecordExample();
        example.createCriteria().andPurOrderIdEqualTo(purOrder.getId());
        List inforList = invoker.getInformationRecordService().queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)inforList, (String)"\u6839\u636e\u91c7\u8d2d\u5546\u8868\u5934ID\u67e5\u8be2\u51fa\u7684\u4fe1\u606f\u8bb0\u5f55\u4e3a\u7a7a");
        InformationRecord infor = (InformationRecord)inforList.get(0);
        this.validInfoRecord(infor);
        purOrder.getItemList().stream().filter(orderItem -> OperationTypeEnum.ACCEPTED.getCode().equals(orderItem.getOperation())).forEach(orderItem -> {
            OrderItemM001 data = (OrderItemM001)orderItem;
            this.validOrderItem(data);
            InquiryBusiCondition busiCondition = this.getBusiCondition(data, purOrder);
            SystemPrice sys = this.buildSystemPrice(data, busiCondition, infor);
            SyncPriceService syncPriceService = (SyncPriceService)SpringContextHolder.getOneBean(SyncPriceService.class);
            if (syncPriceService == null) {
                return;
            }
            invoker.getSystemPriceService().addObj(sys);
        });
        return null;
    }

    private SystemPrice buildSystemPrice(IOrderItem data, InquiryBusiCondition busiCondition, InformationRecord infor) {
        SystemPrice sys = new SystemPrice();
        sys.setInformationRecordCategory(infor.getInformationRecordCategory());
        sys.setFactoryCode(infor.getFactoryCode());
        sys.setPurchaseOrganization(infor.getPurchaseOrganization());
        sys.setPurchasingGroup(infor.getPurchasingGroup());
        sys.setConditionalType(infor.getConditionalType());
        sys.setOrderItemId(data.getId());
        sys.setCreateTime(new Date());
        sys.setUpdateTime(new Date());
        sys.setIsEnable(Constant.YES_INT);
        sys.setUntaxedUnitPrice(data.getUntaxedUnitPrice());
        sys.setCompanySapCode(data.getSupCompanySapCode());
        if (StringUtils.isNotBlank((String)data.getMeasurementUnit())) {
            sys.setPurPriceUnit(data.getMeasurementUnit());
        }
        if (data.getValuationUnit() != null) {
            sys.setPriceUnit(data.getValuationUnit());
        }
        sys.setCurrency(data.getCurrency());
        sys.setMaterialCode(data.getMaterialCode());
        if (busiCondition != null) {
            sys.setCountry(busiCondition.getCountry());
            sys.setRegion(busiCondition.getRegion());
        }
        return sys;
    }

    private String getSupMaterialCode(String materialCode, String companySapCode) {
        SupplierMaterialExample materExample = new SupplierMaterialExample();
        materExample.createCriteria().andCompanySapCodeEqualTo(companySapCode).andMaterialCodeEqualTo(materialCode);
        SupplierMaterialService service = (SupplierMaterialService)SpringContextHolder.getOneBean(SupplierMaterialService.class);
        List materialList = service.queryAllObjByExample((IExample)materExample);
        if (CollectionUtils.isNotEmpty((Collection)materialList) && StringUtils.isNotBlank((String)((SupplierMaterial)materialList.get(0)).getSupplierMaterial())) {
            return ((SupplierMaterial)materialList.get(0)).getSupplierMaterial();
        }
        return null;
    }

    private InquiryBusiCondition getBusiCondition(IOrderItem data, PurOrder purOrder) {
        return purOrder.getBusiConditions().stream().filter(busiCondition -> busiCondition.getSupCompanyId().equals(data.getSupCompanyId())).findAny().orElse(null);
    }

    private void validInfoRecord(InformationRecord infor) {
        Assert.isNotBlank((String)infor.getConditionalType(), (String)"\u4fe1\u606f\u8bb0\u5f55\u4e2d\u6761\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)infor.getFactoryCode(), (String)"\u4fe1\u606f\u8bb0\u5f55\u4e2d\u5de5\u5382\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)infor.getInformationRecordCategory(), (String)"\u4fe1\u606f\u8bb0\u5f55\u4e2d\u4fe1\u606f\u8bb0\u5f55\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)infor.getPurchaseOrganization(), (String)"\u4fe1\u606f\u8bb0\u5f55\u4e2d\u91c7\u8d2d\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)infor.getPurchasingGroup(), (String)"\u4fe1\u606f\u8bb0\u5f55\u4e2d\u91c7\u8d2d\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void validOrderItem(IOrderItem data) {
        Assert.isNotNull((Object)data.getUntaxedUnitPrice(), (String)"\u4e0d\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)data.getMeasurementUnit(), (String)"\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)data.getValuationUnit(), (String)"\u8ba1\u4ef7\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)data.getCurrency(), (String)"\u5e01\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)data.getMaterialDesc(), (String)"\u7269\u6599\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)data.getMaterialCode(), (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

