/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.template;

import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.TplMouldDetail;
import com.els.base.inquiry.entity.TplMouldDetailExample;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import com.els.base.inquiry.enumclass.PropertyDefType;
import com.els.base.inquiry.utils.InquiryConstant;
import com.els.base.inquiry.utils.PropertyDefUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class CreateMouldDetailTplCmd
extends AbstractInquiryCommand<String> {
    private TplMouldDetail tplMouLdDetail;

    public CreateMouldDetailTplCmd(TplMouldDetail tplMouLdDetail) {
        this.tplMouLdDetail = tplMouLdDetail;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        this.valid(this.tplMouLdDetail);
        if (StringUtils.isBlank((String)this.tplMouLdDetail.getMouldDtlClassName())) {
            this.tplMouLdDetail.setMouldDtlClassName(InquiryConstant.DEFALUT_MOULD_DETAIL_CLS.getName());
        }
        if (StringUtils.isBlank((String)this.tplMouLdDetail.getMouldDtlServiceName())) {
            this.tplMouLdDetail.setMouldDtlServiceName(InquiryConstant.DEFALUT_MOULD_DETAIL_SERVICE_CLS.getName());
        }
        this.tplMouLdDetail.setIsHis(Constant.NO_INT);
        if (this.getPurUser() != null) {
            this.tplMouLdDetail.setCreateUserId(this.getPurUser().getId());
            this.tplMouLdDetail.setCreateUserName(this.getPurUser().getNickName());
        }
        if (this.tplMouLdDetail.getCreateTime() == null) {
            this.tplMouLdDetail.setCreateTime(new Date());
        }
        this.invoker.getTplMouLdDetailService().addObj(this.tplMouLdDetail);
        List<PropertyDef> propertyDefList = this.tplMouLdDetail.getPropertyDefList();
        if (CollectionUtils.isEmpty(propertyDefList)) {
            return this.tplMouLdDetail.getId();
        }
        propertyDefList.stream().forEach(propertyDef -> {
            propertyDef.setId(null);
            propertyDef.setTplId(this.tplMouLdDetail.getId());
            propertyDef.setTplType(PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
            if (PropertyDefType.DIC_GROUP.getCode().equals(propertyDef.getType())) {
                propertyDef.setDicGroupCode(propertyDef.getCode());
            }
        });
        this.getInvoker().getPropertyDefService().addAll(propertyDefList);
        return this.tplMouLdDetail.getId();
    }

    private void valid(TplMouldDetail tplMouLdDetail) {
        Assert.isNotBlank((String)tplMouLdDetail.getCode(), (String)"\u6a21\u5177\u6210\u672c\u6e05\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)tplMouLdDetail.getName(), (String)"\u6a21\u5177\u6210\u672c\u6e05\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(tplMouLdDetail.getPropertyDefList(), (String)"\u5b57\u6bb5\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        if (!tplMouLdDetail.getCode().matches("[\\w_-]+")) {
            throw new CommonException("\u7f16\u7801\u53ea\u80fd\u4f7f\u7528\u82f1\u6587\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3001\u6a2a\u7ebf");
        }
        if (tplMouLdDetail.getCode().length() > 32) {
            throw new CommonException("\u7f16\u7801\u6700\u591a\u53ea\u652f\u630132\u4e2a\u5b57\u7b26");
        }
        PropertyDefUtils.valid(tplMouLdDetail.getPropertyDefList());
        TplMouldDetailExample example = new TplMouldDetailExample();
        example.createCriteria().andCodeEqualTo(tplMouLdDetail.getCode()).andIsHisEqualTo(Constant.NO_INT);
        List list = this.invoker.getTplMouLdDetailService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new CommonException("\u6a21\u677f\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        }
        example.clear();
        example.createCriteria().andNameEqualTo(tplMouLdDetail.getName()).andIsHisEqualTo(Constant.NO_INT);
        list = this.invoker.getTplMouLdDetailService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new CommonException("\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        }
    }
}

