/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.template;

import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.ResponseCode;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.TemplateConfExample;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.entity.TplOrderItemDetailExample;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class DeleteOrderItemDetailTplCmd
extends AbstractInquiryCommand<String> {
    private List<String> idList;

    public DeleteOrderItemDetailTplCmd(List<String> idList) {
        this.idList = idList;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        Assert.isNotEmpty(this.idList, (String)"\u6a21\u677f\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        this.idList.stream().forEach(templateConfId -> {
            boolean isContain = invoker.getPropertyValueService().isContainTpl((String)templateConfId, PropertyDefTplType.ORDER_DETAIL_TYPE.getCode());
            if (isContain) {
                throw new CommonException("\u8be5\u6a21\u677f\u5df2\u7ecf\u751f\u6210\u4e1a\u52a1\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664");
            }
        });
        boolean isConfInTemplateConf = this.idList.parallelStream().flatMap(tplOrderItemDetailId -> {
            TplOrderItemDetail tplOrderItemDetail = (TplOrderItemDetail)invoker.getTplOrderItemDetailService().queryObjById(tplOrderItemDetailId);
            TplOrderItemDetailExample example = new TplOrderItemDetailExample();
            example.createCriteria().andCodeEqualTo(tplOrderItemDetail.getCode());
            List tplMouldDetailList = invoker.getTplOrderItemDetailService().queryAllObjByExample((IExample)example);
            return tplMouldDetailList.stream();
        }).anyMatch(tplOrderItemDetail -> {
            TemplateConfExample templateConfExample = new TemplateConfExample();
            templateConfExample.createCriteria().andOrderItemDtlTplIdEqualTo(tplOrderItemDetail.getId());
            List tplList = invoker.getTemplateConfService().queryAllObjByExample((IExample)templateConfExample);
            return CollectionUtils.isNotEmpty((Collection)tplList);
        });
        if (isConfInTemplateConf) {
            throw new CommonException("\u8be5\u6a21\u677f\u5df2\u7ecf\u5728\u8be2\u62a5\u4ef7\u6a21\u677f\u4e2d\u914d\u7f6e\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.idList.forEach(templateConfId -> {
            invoker.getPropertyDefService().removeAllByTpl((String)templateConfId, PropertyDefTplType.ORDER_DETAIL_TYPE.getCode());
            invoker.getTplOrderItemDetailService().deleteObjById(templateConfId);
        });
        return ResponseCode.Success.getCode();
    }
}

