/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.inquiry.dao.InformationRecordMapper;
import com.els.base.inquiry.entity.InformationRecord;
import com.els.base.inquiry.entity.InformationRecordExample;
import com.els.base.inquiry.service.InformationRecordService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultInformationRecordService")
public class InformationRecordServiceImpl
implements InformationRecordService {
    @Resource
    protected InformationRecordMapper informationRecordMapper;

    @CacheEvict(value={"informationRecord"}, allEntries=true)
    public void addObj(InformationRecord t) {
        this.informationRecordMapper.insertSelective(t);
    }

    @CacheEvict(value={"informationRecord"}, allEntries=true)
    public void deleteObjById(String id) {
        this.informationRecordMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"informationRecord"}, allEntries=true)
    public void modifyObj(InformationRecord t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.informationRecordMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"informationRecord"}, keyGenerator="redisKeyGenerator")
    public InformationRecord queryObjById(String id) {
        return this.informationRecordMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"informationRecord"}, keyGenerator="redisKeyGenerator")
    public List<InformationRecord> queryAllObjByExample(InformationRecordExample example) {
        return this.informationRecordMapper.selectByExample(example);
    }

    @Cacheable(value={"informationRecord"}, keyGenerator="redisKeyGenerator")
    public PageView<InformationRecord> queryObjByPage(InformationRecordExample example) {
        PageView<InformationRecord> pageView = example.getPageView();
        pageView.setQueryResult(this.informationRecordMapper.selectByExampleByPage(example));
        return pageView;
    }

    public void deleteByExample(InformationRecordExample example) {
    }

    public void addAll(List<InformationRecord> list) {
    }
}

