/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.dao.TargetM002Mapper;
import com.els.base.inquiry.entity.TargetM002;
import com.els.base.inquiry.entity.TargetM002Example;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import com.els.base.inquiry.service.TargetM002Service;
import com.els.base.inquiry.utils.PropertyValueUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultTargetM002Service")
public class TargetM002ServiceImpl
implements TargetM002Service {
    @Resource
    protected TargetM002Mapper targetM002Mapper;

    @Transactional
    @CacheEvict(value={"targetM002"}, allEntries=true)
    public void addObj(TargetM002 t) {
        this.targetM002Mapper.insertSelective(t);
        ArrayList<TargetM002> targetList = new ArrayList<TargetM002>();
        targetList.add(t);
        PropertyValueUtils.addPropertyValue(targetList, PropertyDefTplType.TARGET_TYPE.getCode());
    }

    @Override
    @Transactional
    @CacheEvict(value={"targetM002"}, allEntries=true)
    public void addAll(List<TargetM002> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (TargetM002 targetM002 : list) {
            this.addObj(targetM002);
        }
    }

    @Transactional
    @CacheEvict(value={"targetM002"}, allEntries=true)
    public void deleteObjById(String id) {
        this.targetM002Mapper.deleteByPrimaryKey(id);
        PropertyValueUtils.deleteByExtenable(Arrays.asList(id), PropertyDefTplType.TARGET_TYPE.getCode());
    }

    @CacheEvict(value={"targetM002"}, allEntries=true)
    public void deleteByExample(TargetM002Example example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
    }

    @Transactional
    @CacheEvict(value={"targetM002"}, allEntries=true)
    public void modifyObj(TargetM002 t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.targetM002Mapper.updateByPrimaryKeySelective(t);
        PropertyValueUtils.deleteByExtenable(Arrays.asList(t.getId()), PropertyDefTplType.TARGET_TYPE.getCode());
        PropertyValueUtils.addPropertyValue(Arrays.asList(t), PropertyDefTplType.TARGET_TYPE.getCode());
    }

    @Cacheable(value={"targetM002"}, keyGenerator="redisKeyGenerator")
    public TargetM002 queryObjById(String id) {
        TargetM002 target = this.targetM002Mapper.selectByPrimaryKey(id);
        if (target == null) {
            return target;
        }
        PropertyValueUtils.queryAndSetValue(Arrays.asList(target), PropertyDefTplType.TARGET_TYPE.getCode());
        return target;
    }

    @Cacheable(value={"targetM002"}, keyGenerator="redisKeyGenerator")
    public List<TargetM002> queryAllObjByExample(TargetM002Example example) {
        List<TargetM002> targetList = this.targetM002Mapper.selectByExample(example);
        PropertyValueUtils.queryAndSetValue(targetList, PropertyDefTplType.TARGET_TYPE.getCode());
        return targetList;
    }

    @Cacheable(value={"targetM002"}, keyGenerator="redisKeyGenerator")
    public PageView<TargetM002> queryObjByPage(TargetM002Example example) {
        PageView<TargetM002> pageView = example.getPageView();
        List<TargetM002> targetList = this.targetM002Mapper.selectByExampleByPage(example);
        PropertyValueUtils.queryAndSetValue(targetList, PropertyDefTplType.TARGET_TYPE.getCode());
        pageView.setQueryResult(targetList);
        return pageView;
    }

    @Override
    @Cacheable(value={"targetM002"}, keyGenerator="redisKeyGenerator")
    public List<ITarget> queryByPurOrderId(String purOrderId) {
        TargetM002Example example = new TargetM002Example();
        example.createCriteria().andPurOrderIdEqualTo(purOrderId);
        List<TargetM002> list = this.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        ArrayList<ITarget> targetList = new ArrayList<ITarget>();
        targetList.addAll(list);
        PropertyValueUtils.queryAndSetValue(targetList, PropertyDefTplType.TARGET_TYPE.getCode());
        return targetList;
    }

    @Override
    @Transactional
    @CacheEvict(value={"targetM002"}, allEntries=true)
    public void deleteObjByPurOrderId(String purOrderId) {
        TargetM002Example example = new TargetM002Example();
        example.createCriteria().andPurOrderIdEqualTo(purOrderId);
        List<TargetM002> targetList = this.queryAllObjByExample(example);
        List<String> targetIdList = targetList.stream().map(TargetM002::getId).collect(Collectors.toList());
        PropertyValueUtils.deleteByExtenable(targetIdList, PropertyDefTplType.TARGET_TYPE.getCode());
        this.targetM002Mapper.deleteByExample(example);
    }
}

