/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.entity.IExample;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquiryMould;
import com.els.base.inquiry.enumclass.OperationTypeEnum;
import com.els.base.inquiry.web.vo.GenerateMouldVO;
import com.els.base.mould.master.entity.Mould;
import com.els.base.mould.relation.entity.Relation;
import com.els.base.mould.relation.entity.RelationExample;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GenerateMouldCommand
extends AbstractInquiryCommand<List<InquiryMould>> {
    private List<GenerateMouldVO> vos;

    public GenerateMouldCommand(List<GenerateMouldVO> vos) {
        this.vos = vos;
    }

    @Override
    public List<InquiryMould> execute(InquiryCommandInvoker invoker) {
        HashMap<String, List> mouldIdMap = new HashMap<String, List>();
        ArrayList<InquiryMould> mouldsList = new ArrayList<InquiryMould>();
        for (GenerateMouldVO vo : this.vos) {
            if (StringUtils.isBlank((String)vo.getMaterialDesc())) continue;
            InquiryMould inquiryMould = new InquiryMould();
            if (StringUtils.isBlank((String)vo.getMaterialCode())) {
                inquiryMould.setMaterialDesc(vo.getMaterialDesc());
                mouldsList.add(inquiryMould);
                continue;
            }
            RelationExample example = new RelationExample();
            example.createCriteria().andMaterialNoEqualTo(vo.getMaterialCode());
            List mouldMaterials = invoker.getRelationService().queryAllObjByExample((IExample)example);
            if (mouldMaterials.isEmpty()) {
                inquiryMould.setMaterialCode(vo.getMaterialCode());
                inquiryMould.setMaterialDesc(vo.getMaterialDesc());
                mouldsList.add(inquiryMould);
                continue;
            }
            for (Relation mouldMaterial : mouldMaterials) {
                ArrayList<String> materialList2 = new ArrayList<String>();
                materialList2.add(mouldMaterial.getMaterialNo());
                materialList2.add(mouldMaterial.getMaterialDesc());
                mouldIdMap.put(mouldMaterial.getMouldId(), materialList2);
            }
        }
        mouldIdMap.forEach((mouldId, materialList) -> {
            Mould mould = (Mould)invoker.getMouldService().queryObjById(mouldId);
            if (mould != null) {
                InquiryMould inquiryMould = new InquiryMould();
                inquiryMould.setMaterialCode((String)materialList.get(0));
                inquiryMould.setMaterialDesc((String)materialList.get(1));
                inquiryMould.setMouldCode(mould.getMouldNo());
                inquiryMould.setMouldName(mould.getMouldDesc());
                if (mould.getOverplusLifetime() != null) {
                    inquiryMould.setMoldLife(mould.getOverplusLifetime().intValue());
                }
                inquiryMould.setWaitMaterialId(mould.getId());
                inquiryMould.setRowStatus(OperationTypeEnum.NO_OPERATION.getCode());
                mouldsList.add(inquiryMould);
            }
        });
        return mouldsList;
    }
}

