/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.entity;

import com.els.base.inquiry.IMould;
import com.els.base.inquiry.IMouldDetail;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.PropertyValue;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.service.PurOrderService;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.utils.PropertyDefUtils;
import com.els.base.inquiry.utils.json.ExtendableObjectJsonSerialzer;
import com.els.base.inquiry.utils.json.InquiryMouldJsonDeSerialzer;
import com.els.base.mould.master.entity.Mould;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@JsonSerialize(using=ExtendableObjectJsonSerialzer.class)
@JsonDeserialize(using=InquiryMouldJsonDeSerialzer.class)
@ApiModel(value="\u8be2\u62a5\u4ef7-\u6a21\u5177\u6e05\u5355")
public class InquiryMould
implements IMould,
Cloneable {
    @ApiModelProperty(position=9, value="\u6210\u672c\u5206\u6790\u6e05\u5355", dataType="button")
    private IMouldDetail mouldDetail;
    private List<PropertyValue> propertyValueList;
    @ApiModelProperty(hidden=true, value="\u4e3b\u952e")
    private String id;
    @ApiModelProperty(hidden=true, value="\u8be2\u4ef7\u5355\u5934id")
    private String purOrderId;
    @ApiModelProperty(value="\u4f9b\u5e94\u5546\u7f16\u7801")
    private String supCompanySrmCode;
    @ApiModelProperty(value="\u4f9b\u5e94\u5546\u540d\u79f0")
    private String supCompanyName;
    @ApiModelProperty(position=1, value="\u6a21\u5177\u7f16\u7801")
    private String mouldCode;
    @ApiModelProperty(position=2, value="\u6a21\u5177\u540d\u79f0")
    private String mouldName;
    @ApiModelProperty(position=3, value="\u6a21\u5177\u89c4\u683c")
    private String mouldSpecifications;
    @ApiModelProperty(position=4, value="\u6a21\u5177\u6750\u6599")
    private String moldMaterial;
    @ApiModelProperty(position=5, value="\u6a21\u5177\u5bff\u547d")
    private Integer moldLife;
    @ApiModelProperty(position=6, value="\u51fa\u6a21\u6570")
    private BigDecimal outOfModulus;
    @ApiModelProperty(hidden=true, value="\u4ea7\u54c1\u7f16\u7801")
    private String productCode;
    @ApiModelProperty(hidden=true, value="\u4ea7\u54c1\u540d\u79f0")
    private String productName;
    @ApiModelProperty(position=7, value="\u4e0d\u542b\u7a0e\u5355\u4ef7")
    private BigDecimal untaxedUnitPrice;
    @ApiModelProperty(position=8, value="\u542b\u7a0e\u5355\u4ef7")
    private BigDecimal taxUnitPrice;
    @ApiModelProperty(hidden=true, value="\u6a21\u5177\u4ef7\u683c\u5206\u6790")
    private String mouldPriceAnalysis;
    @ApiModelProperty(position=10, value="\u7269\u6599\u660e\u7ec6", dataType="button")
    private String materiel;
    @ApiModelProperty(position=12, value="\u5907\u6ce8")
    private String remarks;
    @ApiModelProperty(hidden=true, value="\u521b\u5efa\u65f6\u95f4")
    private Date createTime;
    @ApiModelProperty(hidden=true, value="\u66f4\u65b0\u65f6\u95f4")
    private Date updateTime;
    @ApiModelProperty(hidden=true, value="\u8bb0\u5f55\u662f\u5426\u53ef\u7528(0=\u4e0d\u53ef\u7528\uff0c1=\u53ef\u7528)")
    private Integer isEnable;
    @ApiModelProperty(hidden=true, value="\u6392\u5e8f\u53f7")
    private Integer sortNo;
    @ApiModelProperty(hidden=true, value="\u5f85\u8be2\u4ef7\u7269\u6599ID")
    private String waitMaterialId;
    @ApiModelProperty(hidden=true, value="\u6a21\u677fid")
    private String templateId;
    @ApiModelProperty(hidden=true, value="\u4f9b\u5e94\u5546\u8be2\u4ef7\u5355\u5934id")
    private String supOrderId;
    @ApiModelProperty(hidden=true, value="\u4f9b\u5e94\u5546id")
    private String supCompanyId;
    @ApiModelProperty(value="\u4f9b\u5e94\u5546SAP\u7f16\u7801")
    private String supCompanySapCode;
    @ApiModelProperty(value="\u884c\u72b6\u6001")
    private Integer rowStatus;
    @ApiModelProperty(value="\u7269\u6599\u7f16\u7801")
    private String materialCode;
    @ApiModelProperty(value="\u7269\u6599\u63cf\u8ff0")
    private String materialDesc;
    @ApiModelProperty(value="\u62a5\u4ef7\u72b6\u6001")
    private Integer quotationStatus;
    @ApiModelProperty(value="\u62a5\u4ef7\u65f6\u95f4")
    private Date quoteTime;
    @ApiModelProperty(value="\u62a5\u4ef7\u4eba")
    private String supUserName;
    @ApiModelProperty(value="\u5408\u8ba1\u91d1\u989d")
    private BigDecimal totalAmount;
    private static final long serialVersionUID = 1L;

    @Override
    public void build(String templateId, Mould mould) {
        this.setMouldCode(mould.getMouldNo());
        this.setMouldName(mould.getMouldDesc());
        if (mould.getOverplusLifetime() != null) {
            this.setMoldLife(mould.getOverplusLifetime().intValue());
        }
        this.setWaitMaterialId(mould.getId());
    }

    @Override
    public IMould build(PurOrder purOrder, InquirySupOrder supOrder) {
        try {
            InquiryMould newMould = (InquiryMould)this.clone();
            newMould.setId(UUIDGenerator.generateUUID());
            newMould.setPurOrderId(purOrder.getId());
            newMould.setSupOrderId(supOrder.getId());
            newMould.setSupCompanyName(supOrder.getSupCompanyName());
            newMould.setSupCompanySrmCode(supOrder.getSupCompanySrmCode());
            newMould.setSupCompanySapCode(supOrder.getSupCompanySapCode());
            newMould.setQuotationStatus(InquiryQuoteStatus.UNQUOTED.getCode());
            newMould.setTemplateId(purOrder.getTemplateId());
            return newMould;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IMouldDetail getMouldDetail() {
        return this.mouldDetail;
    }

    @Override
    public void setMouldDetail(IMouldDetail mouldDetail) {
        this.mouldDetail = mouldDetail;
    }

    @Override
    public List<PropertyValue> getPropertyValueList() {
        return this.propertyValueList;
    }

    @Override
    public void setPropertyValueList(List<PropertyValue> propertyValueList) {
        this.propertyValueList = propertyValueList;
    }

    @Override
    public List<PropertyDef> getPropertyDefList() {
        PurOrder purOrder;
        if (StringUtils.isNotBlank((String)this.getTemplateId())) {
            TemplateConf templateConf = (TemplateConf)((TemplateConfService)SpringContextHolder.getOneBean(TemplateConfService.class)).queryObjById(this.getTemplateId());
            return templateConf.getMouldPropertyDefList();
        }
        if (StringUtils.isNotBlank((String)this.getPurOrderId()) && (purOrder = (PurOrder)((PurOrderService)SpringContextHolder.getOneBean(PurOrderService.class)).queryObjById(this.getPurOrderId())) != null && StringUtils.isNotBlank((String)purOrder.getTemplateId())) {
            TemplateConf templateConf = (TemplateConf)((TemplateConfService)SpringContextHolder.getOneBean(TemplateConfService.class)).queryObjById(purOrder.getTemplateId());
            return templateConf.getMouldPropertyDefList();
        }
        return PropertyDefUtils.getProperyDefByClass(this.getClass());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    @Override
    public String getPurOrderId() {
        return this.purOrderId;
    }

    @Override
    public void setPurOrderId(String purOrderId) {
        this.purOrderId = purOrderId == null ? null : purOrderId.trim();
    }

    @Override
    public String getSupCompanySrmCode() {
        return this.supCompanySrmCode;
    }

    @Override
    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    @Override
    public String getSupCompanyName() {
        return this.supCompanyName;
    }

    @Override
    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    @Override
    public String getMouldCode() {
        return this.mouldCode;
    }

    @Override
    public void setMouldCode(String mouldCode) {
        this.mouldCode = mouldCode == null ? null : mouldCode.trim();
    }

    @Override
    public String getMouldName() {
        return this.mouldName;
    }

    @Override
    public void setMouldName(String mouldName) {
        this.mouldName = mouldName == null ? null : mouldName.trim();
    }

    public String getMouldSpecifications() {
        return this.mouldSpecifications;
    }

    public void setMouldSpecifications(String mouldSpecifications) {
        this.mouldSpecifications = mouldSpecifications == null ? null : mouldSpecifications.trim();
    }

    public String getMoldMaterial() {
        return this.moldMaterial;
    }

    public void setMoldMaterial(String moldMaterial) {
        this.moldMaterial = moldMaterial == null ? null : moldMaterial.trim();
    }

    public Integer getMoldLife() {
        return this.moldLife;
    }

    public void setMoldLife(Integer moldLife) {
        this.moldLife = moldLife;
    }

    public BigDecimal getOutOfModulus() {
        return this.outOfModulus;
    }

    public void setOutOfModulus(BigDecimal outOfModulus) {
        this.outOfModulus = outOfModulus;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode == null ? null : productCode.trim();
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName == null ? null : productName.trim();
    }

    @Override
    public BigDecimal getUntaxedUnitPrice() {
        return this.untaxedUnitPrice;
    }

    public void setUntaxedUnitPrice(BigDecimal untaxedUnitPrice) {
        this.untaxedUnitPrice = untaxedUnitPrice;
    }

    public BigDecimal getTaxUnitPrice() {
        return this.taxUnitPrice;
    }

    public void setTaxUnitPrice(BigDecimal taxUnitPrice) {
        this.taxUnitPrice = taxUnitPrice;
    }

    public String getMouldPriceAnalysis() {
        return this.mouldPriceAnalysis;
    }

    public void setMouldPriceAnalysis(String mouldPriceAnalysis) {
        this.mouldPriceAnalysis = mouldPriceAnalysis == null ? null : mouldPriceAnalysis.trim();
    }

    public String getMateriel() {
        return this.materiel;
    }

    public void setMateriel(String materiel) {
        this.materiel = materiel == null ? null : materiel.trim();
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks == null ? null : remarks.trim();
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getIsEnable() {
        return this.isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    @Override
    public Integer getSortNo() {
        return this.sortNo;
    }

    @Override
    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public String getWaitMaterialId() {
        return this.waitMaterialId;
    }

    public void setWaitMaterialId(String waitMaterialId) {
        this.waitMaterialId = waitMaterialId == null ? null : waitMaterialId.trim();
    }

    @Override
    public String getTemplateId() {
        return this.templateId;
    }

    @Override
    public void setTemplateId(String templateId) {
        this.templateId = templateId == null ? null : templateId.trim();
    }

    @Override
    public String getSupOrderId() {
        return this.supOrderId;
    }

    @Override
    public void setSupOrderId(String supOrderId) {
        this.supOrderId = supOrderId == null ? null : supOrderId.trim();
    }

    @Override
    public String getSupCompanyId() {
        return this.supCompanyId;
    }

    @Override
    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    @Override
    public String getSupCompanySapCode() {
        return this.supCompanySapCode;
    }

    @Override
    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    @Override
    public Integer getRowStatus() {
        return this.rowStatus;
    }

    @Override
    public void setRowStatus(Integer rowStatus) {
        this.rowStatus = rowStatus;
    }

    @Override
    public String getMaterialCode() {
        return this.materialCode;
    }

    @Override
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    @Override
    public String getMaterialDesc() {
        return this.materialDesc;
    }

    @Override
    public void setMaterialDesc(String materialDesc) {
        this.materialDesc = materialDesc == null ? null : materialDesc.trim();
    }

    @Override
    public Integer getQuotationStatus() {
        return this.quotationStatus;
    }

    @Override
    public void setQuotationStatus(Integer quotationStatus) {
        this.quotationStatus = quotationStatus;
    }

    @Override
    public Date getQuoteTime() {
        return this.quoteTime;
    }

    @Override
    public void setQuoteTime(Date quoteTime) {
        this.quoteTime = quoteTime;
    }

    @Override
    public String getSupUserName() {
        return this.supUserName;
    }

    @Override
    public void setSupUserName(String supUserName) {
        this.supUserName = supUserName == null ? null : supUserName.trim();
    }

    @Override
    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    @Override
    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }
}

