/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.entity;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractOrderItem;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.IOrderItemService;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.MaterielParity;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.PropertyValue;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.service.OrderItemM002Service;
import com.els.base.inquiry.service.PurOrderService;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.utils.PropertyDefUtils;
import com.els.base.inquiry.utils.json.ExtendableObjectJsonSerialzer;
import com.els.base.inquiry.utils.json.OrderItemM002JsonDeSerialzer;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

@JsonSerialize(using=ExtendableObjectJsonSerialzer.class)
@JsonDeserialize(using=OrderItemM002JsonDeSerialzer.class)
@ApiModel(value="\u8be2\u62a5\u4ef7-\u884c\u6570\u636e-M002")
public class OrderItemM002
extends AbstractOrderItem {
    private List<PropertyValue> propertyValueList;
    @ApiModelProperty(hidden=true, name="\u4e3b\u952e")
    private String id;
    @ApiModelProperty(hidden=true, name="\u91c7\u8d2d\u65b9\u8868\u5934id")
    private String purOrderId;
    @ApiModelProperty(hidden=true, name="\u4f9b\u5e94\u65b9\u8868\u5934id")
    private String supOrderId;
    @ApiModelProperty(hidden=true, name="\u8be2\u4ef7\u5355\u53f7")
    private String orderNo;
    @ApiModelProperty(hidden=true, name="\u8be2\u4ef7\u5355\u884c\u53f7(\u91c7\u8d2d\u65b9)")
    private Integer orderItemNo;
    @ApiModelProperty(hidden=true, name="\u6392\u5e8f\u53f7(\u4f9b\u5e94\u5546\u884c\u53f7)")
    private Integer sortNo;
    @ApiModelProperty(position=-2, value="\u4f9b\u5e94\u5546\u7f16\u7801")
    private String supCompanySrmCode;
    @ApiModelProperty(position=-2, value="\u4f9b\u5e94\u5546\u540d\u79f0")
    private String supCompanyName;
    @ApiModelProperty(hidden=true, name="\u4f9b\u5e94\u5546id")
    private String supCompanyId;
    @ApiModelProperty(position=-2, value="\u4f9b\u5e94\u5546SAP\u7f16\u7801")
    private String supCompanySapCode;
    @ApiModelProperty(position=-1, value="\u62a5\u4ef7\u4eba")
    private String supUserName;
    @ApiModelProperty(hidden=true, value="\u62a5\u4ef7\u4ebaid")
    private String supUserId;
    @ApiModelProperty(hidden=true, name="\u8bb0\u5f55\u662f\u5426\u53ef\u7528(0=\u4e0d\u53ef\u7528\uff0c1=\u53ef\u7528)")
    private Integer isEnable;
    @ApiModelProperty(hidden=true, value="\u6a21\u677fID")
    private String templateId;
    @ApiModelProperty(hidden=true, value="\u5f85\u8be2\u4ef7\u7269\u6599ID")
    private String waitMaterialId;
    @ApiModelProperty(value="\u62a5\u4ef7\u65b9\u5f0f", dataType="button", position=15)
    private Integer quoteType;
    @ApiModelProperty(hidden=true, name="\u662f\u5426\u542f\u7528\u7269\u6599\u6210\u672c\u5206\u6790")
    private Integer isOrderItemDetailEnable;
    @ApiModelProperty(position=-1, value="\u62a5\u4ef7\u65f6\u95f4")
    private Date quoteTime;
    @ApiModelProperty(hidden=true, value="\u521b\u5efa\u65f6\u95f4")
    private Date createTime;
    @ApiModelProperty(hidden=true, value="\u66f4\u65b0\u65f6\u95f4")
    private Date updateTime;
    @ApiModelProperty(hidden=true, value="\u64cd\u4f5c(\u63a5\u53d7/\u62d2\u7edd)", dataType="button")
    private Integer operation;
    @ApiModelProperty(value="\u62a5\u4ef7\u72b6\u6001")
    private Integer quotationStatus;
    @ApiModelProperty(value="\u65e0\u6cd5\u62a5\u4ef7", dataType="button")
    private Integer unableToQuote;
    @ApiModelProperty(position=31, value="\u5907\u6ce8")
    private String remark;
    @ApiModelProperty(position=1, value="\u7269\u6599\u7f16\u7801")
    private String materialCode;
    @ApiModelProperty(position=2, value="\u7269\u6599\u63cf\u8ff0")
    private String materialDesc;
    @ApiModelProperty(position=3, value="\u7269\u6599\u540d\u79f0")
    private String materialName;
    @ApiModelProperty(position=20, value="\u672a\u7a0e\u5355\u4ef7")
    private BigDecimal untaxedUnitPrice;
    @ApiModelProperty(value="\u5408\u8ba1\u91d1\u989d")
    private BigDecimal totalAmount;
    @ApiModelProperty(position=0, value="\u4fe1\u606f\u8bb0\u5f55\u7c7b\u578b-\u7cfb\u7edf\u4ef7\u683c\u7c7b\u578b", dataType="dic_group", notes="system_price_type")
    private String systemPriceType;
    @ApiModelProperty(value="\u8ba1\u5212\u7684\u5929\u6570\u5185\u4ea4\u8d27")
    private BigDecimal planDeliveryDays;
    @ApiModelProperty(value="\u6807\u51c6\u91c7\u8d2d\u8ba2\u5355\u6570\u91cf")
    private BigDecimal standardPurchase;
    @ApiModelProperty(value="\u6700\u5c0f\u91c7\u8d2d\u8ba2\u5355\u6570\u91cf")
    private BigDecimal minPurchase;
    @ApiModelProperty(value="\u6700\u5927\u91c7\u8d2d\u8ba2\u5355\u6570\u91cf")
    private BigDecimal maxPurchase;
    @ApiModelProperty(position=19, value="\u5e01\u522b", dataType="dic_group", notes="zr_ordercurren")
    private String currency;
    @ApiModelProperty(position=18, value="\u8ba1\u4ef7\u5355\u4f4d")
    private Integer valuationUnit;
    @ApiModelProperty(position=22, value="\u4ef7\u683c\u6709\u6548\u8d77\u59cb\u65e5\u671f")
    private Date priceValidTime;
    @ApiModelProperty(position=23, value="\u4ef7\u683c\u6709\u6548\u622a\u6b62\u65f6\u95f4")
    private Date priceExpiredTime;
    @ApiModelProperty(value="\u4ef7\u683c\u63a7\u5236\u6307\u793a\u7b26")
    private String priceCtrlSign;
    @ApiModelProperty(value="\u79fb\u52a8\u5e73\u5747\u4ef7\u683c/\u5468\u671f\u5355\u4ef7")
    private BigDecimal cycleUnitPrice;
    @ApiModelProperty(value="\u6807\u51c6\u4ef7\u683c")
    private BigDecimal standardPrice;
    @ApiModelProperty(value="\u6570\u636e\u7c7b\u578b")
    private String dataType;
    @ApiModelProperty(value="\u5185\u90e8\u8868\u7d22\u5f15")
    private Long innerTableIndex;
    @ApiModelProperty(value="\u6761\u4ef6\u7c7b\u578b")
    private String conditionType;
    @ApiModelProperty(value="\u6761\u4ef6\u91d1\u989d")
    private BigDecimal conditionPrice;
    @ApiModelProperty(value="\u6761\u4ef6\u5b9a\u4ef7\u5355\u4f4d")
    private String conditionPriceUnit;
    @ApiModelProperty(value="\u9644\u52a0\u8d77\u606f\u65e5")
    private Integer additionalStartDays;
    @ApiModelProperty(value="\u8ba1\u91cf\u5355\u4f4d")
    private String measurementUnit;
    @ApiModelProperty(value="\u56fa\u5b9a\u8d27\u6e90")
    private String fixedSupply;
    @ApiModelProperty(value="\u4fe1\u606f\u8bb0\u5f55ID\u53f7")
    private String zid;
    @ApiModelProperty(hidden=true, name="\u7269\u6599\u6e05\u5355id")
    private String targetId;
    @ApiModelProperty(value="\u76ee\u6807\u4ef7\u683c")
    private BigDecimal targetPrice;
    @ApiModelProperty(value="ERP\u7cfb\u7edf\u4ef7")
    private BigDecimal erpSystemPrice;
    @ApiModelProperty(position=21, value="\u7a0e\u7801", dataType="dic_group", notes="tax_type_code")
    private String saleTaxCode;
    @ApiModelProperty(value="\u751f\u4ea7\u7248\u672c")
    private String proVersion;
    private static final long serialVersionUID = 1L;

    @Override
    public IOrderItem build(PurOrder order, InquirySupOrder supOrder, ITarget target) {
        BeanUtils.copyProperties((Object)target, (Object)this);
        this.setId(UUIDGenerator.generateUUID());
        this.setPurOrderId(supOrder.getPurOrderId());
        this.setSupOrderId(supOrder.getId());
        this.setTemplateId(order.getTemplateId());
        this.setOrderNo(order.getOrderNo());
        this.setOrderItemNo(target.getOrderItemNo());
        this.setTargetId(target.getId());
        this.setMaterialCode(target.getMaterialCode());
        this.setMaterialDesc(target.getMaterialDesc());
        this.setQuoteType(target.getQuoteType());
        this.setSortNo(target.getSortNo());
        this.setWaitMaterialId(target.getWaitMaterialId());
        this.setSupCompanyId(supOrder.getSupCompanyId());
        this.setSupCompanyName(supOrder.getSupCompanyName());
        this.setSupCompanySapCode(supOrder.getSupCompanySapCode());
        this.setSupCompanySrmCode(supOrder.getSupCompanySrmCode());
        this.setCreateTime(new Date());
        this.setUnableToQuote(Constant.NO_INT);
        this.setQuotationStatus(InquiryQuoteStatus.UNQUOTED.getCode());
        if (StringUtils.isNotBlank((String)target.getMaterialCode()) && StringUtils.isNotBlank((String)supOrder.getSupCompanySapCode()) && this.createTime != null) {
            this.setErpSystemPrice(this.querySystemPriceByMaterialCode(target.getMaterialCode(), supOrder.getSupCompanySapCode(), this.createTime));
        }
        if (CollectionUtils.isEmpty(target.getPropertyValueList())) {
            return this;
        }
        List<PropertyValue> propertyValueList = target.getPropertyValueList().stream().map(propertyValue -> {
            PropertyValue temp = new PropertyValue();
            BeanUtils.copyProperties((Object)propertyValue, (Object)temp);
            temp.setId(null);
            return temp;
        }).collect(Collectors.toList());
        this.setPropertyValueList(propertyValueList);
        return this;
    }

    @Override
    public void isVaildForQuote() {
        Assert.isNotBlank((String)this.getMeasurementUnit(), (String)"\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.getSupCompanySapCode(), (String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.getSystemPriceType(), (String)"\u4fe1\u606f\u8bb0\u5f55\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.getMaterialDesc(), (String)"\u7269\u6599\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)this.getPlanDeliveryDays(), (String)"\u8ba1\u5212\u4ea4\u8d27\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)this.getStandardPurchase(), (String)"\u6807\u51c6\u91c7\u8d2d\u8ba2\u5355\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)this.getMinPurchase(), (String)"\u6700\u5c0f\u91c7\u8d2d\u8ba2\u5355\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)this.getMinPurchase(), (String)"\u6700\u5927\u91c7\u8d2d\u8ba2\u5355\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.getSaleTaxCode(), (String)"\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)this.getUntaxedUnitPrice(), (String)"\u4e0d\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.getCurrency(), (String)"\u5e01\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)this.getValuationUnit(), (String)"\u8ba1\u4ef7\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)this.getPriceValidTime(), (String)"\u4ef7\u683c\u6709\u6548\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)this.getPriceExpiredTime(), (String)"\u4ef7\u683c\u6709\u6548\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotBlank((String)this.getMaterialName()) && this.getMaterialName().length() > 35) {
            throw new CommonException("\u7269\u6599\u540d\u79f0 \u957f\u5ea6\u6700\u592735");
        }
        if (StringUtils.isNotBlank((String)this.getMaterialDesc()) && this.getMaterialDesc().length() > 40) {
            throw new CommonException("\u7269\u6599\u63cf\u8ff0 \u957f\u5ea6\u6700\u592740");
        }
        if (StringUtils.isNotBlank((String)this.getPriceCtrlSign()) && this.getPriceCtrlSign().length() > 1) {
            throw new CommonException("\u4ef7\u683c\u63a7\u5236\u6307\u793a\u7b26 \u957f\u5ea6\u6700\u59271");
        }
        if (StringUtils.isNotBlank((String)this.getDataType()) && this.getDataType().length() > 4) {
            throw new CommonException("\u6570\u636e\u7c7b\u578b \u957f\u5ea6\u6700\u59274");
        }
        if (StringUtils.isNotBlank((String)this.getRemark()) && this.getRemark().length() > 200) {
            throw new CommonException("\u5907\u6ce8 \u957f\u5ea6\u6700\u5927200");
        }
        if (StringUtils.isNotBlank((String)this.getZid()) && this.getZid().length() > 1) {
            throw new CommonException("ID\u53f7  \u957f\u5ea6\u6700\u59271");
        }
        if (StringUtils.isNotBlank((String)this.getFixedSupply()) && this.getFixedSupply().length() > 1) {
            throw new CommonException("\u56fa\u5b9a\u8d27\u6e90  \u957f\u5ea6\u6700\u59271");
        }
        if (this.getAdditionalStartDays() != null && (this.getAdditionalStartDays() < 0 || this.getAdditionalStartDays() > 99)) {
            throw new CommonException("\u9644\u52a0\u8d77\u606f\u65e5 \u53ea\u80fd0-99");
        }
    }

    @Override
    public Class<? extends IOrderItemService> getOrderItemService() {
        return OrderItemM002Service.class;
    }

    @Override
    public BigDecimal getErpSystemPriceComparison() {
        return null;
    }

    @Override
    public void setErpSystemPriceComparison(BigDecimal erpSystemPriceComparison) {
    }

    @Override
    public BigDecimal getTargetPriceComparison() {
        return null;
    }

    @Override
    public void setTargetPriceComparison(BigDecimal targetPriceComparison) {
    }

    @Override
    public void setMaterielParitys(List<MaterielParity> queryAllObjByExample) {
    }

    @Override
    public List<PropertyValue> getPropertyValueList() {
        return this.propertyValueList;
    }

    @Override
    public void setPropertyValueList(List<PropertyValue> propertyValueList) {
        this.propertyValueList = propertyValueList;
    }

    @Override
    public List<PropertyDef> getPropertyDefList() {
        PurOrder purOrder;
        if (StringUtils.isNotBlank((String)this.getTemplateId())) {
            TemplateConf templateConf = (TemplateConf)((TemplateConfService)SpringContextHolder.getOneBean(TemplateConfService.class)).queryObjById(this.getTemplateId());
            return templateConf.getOrderItemPropertyDefList();
        }
        if (StringUtils.isNotBlank((String)this.getPurOrderId()) && (purOrder = (PurOrder)((PurOrderService)SpringContextHolder.getOneBean(PurOrderService.class)).queryObjById(this.getPurOrderId())) != null && StringUtils.isNotBlank((String)purOrder.getTemplateId())) {
            TemplateConf templateConf = (TemplateConf)((TemplateConfService)SpringContextHolder.getOneBean(TemplateConfService.class)).queryObjById(purOrder.getTemplateId());
            return templateConf.getOrderItemPropertyDefList();
        }
        return PropertyDefUtils.getProperyDefByClass(this.getClass());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    @Override
    public String getPurOrderId() {
        return this.purOrderId;
    }

    @Override
    public void setPurOrderId(String purOrderId) {
        this.purOrderId = purOrderId == null ? null : purOrderId.trim();
    }

    @Override
    public String getSupOrderId() {
        return this.supOrderId;
    }

    @Override
    public void setSupOrderId(String supOrderId) {
        this.supOrderId = supOrderId == null ? null : supOrderId.trim();
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo == null ? null : orderNo.trim();
    }

    public Integer getOrderItemNo() {
        return this.orderItemNo;
    }

    @Override
    public void setOrderItemNo(Integer orderItemNo) {
        this.orderItemNo = orderItemNo;
    }

    public Integer getSortNo() {
        return this.sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public String getSupCompanySrmCode() {
        return this.supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    @Override
    public String getSupCompanyName() {
        return this.supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    @Override
    public String getSupCompanyId() {
        return this.supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    @Override
    public String getSupCompanySapCode() {
        return this.supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    @Override
    public String getSupUserName() {
        return this.supUserName;
    }

    @Override
    public void setSupUserName(String supUserName) {
        this.supUserName = supUserName == null ? null : supUserName.trim();
    }

    @Override
    public String getSupUserId() {
        return this.supUserId;
    }

    @Override
    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId == null ? null : supUserId.trim();
    }

    public Integer getIsEnable() {
        return this.isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    @Override
    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId == null ? null : templateId.trim();
    }

    public String getWaitMaterialId() {
        return this.waitMaterialId;
    }

    public void setWaitMaterialId(String waitMaterialId) {
        this.waitMaterialId = waitMaterialId == null ? null : waitMaterialId.trim();
    }

    @Override
    public Integer getQuoteType() {
        return this.quoteType;
    }

    @Override
    public void setQuoteType(Integer quoteType) {
        this.quoteType = quoteType;
    }

    @Override
    public Integer getIsOrderItemDetailEnable() {
        return this.isOrderItemDetailEnable;
    }

    public void setIsOrderItemDetailEnable(Integer isOrderItemDetailEnable) {
        this.isOrderItemDetailEnable = isOrderItemDetailEnable;
    }

    @Override
    public Date getQuoteTime() {
        return this.quoteTime;
    }

    @Override
    public void setQuoteTime(Date quoteTime) {
        this.quoteTime = quoteTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    public Integer getOperation() {
        return this.operation;
    }

    @Override
    public void setOperation(Integer operation) {
        this.operation = operation;
    }

    @Override
    public Integer getQuotationStatus() {
        return this.quotationStatus;
    }

    @Override
    public void setQuotationStatus(Integer quotationStatus) {
        this.quotationStatus = quotationStatus;
    }

    @Override
    public Integer getUnableToQuote() {
        return this.unableToQuote;
    }

    public void setUnableToQuote(Integer unableToQuote) {
        this.unableToQuote = unableToQuote;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    @Override
    public String getMaterialCode() {
        return this.materialCode;
    }

    @Override
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    @Override
    public String getMaterialDesc() {
        return this.materialDesc;
    }

    public void setMaterialDesc(String materialDesc) {
        this.materialDesc = materialDesc == null ? null : materialDesc.trim();
    }

    @Override
    public String getMaterialName() {
        return this.materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName == null ? null : materialName.trim();
    }

    @Override
    public BigDecimal getUntaxedUnitPrice() {
        return this.untaxedUnitPrice;
    }

    @Override
    public void setUntaxedUnitPrice(BigDecimal untaxedUnitPrice) {
        this.untaxedUnitPrice = untaxedUnitPrice;
    }

    @Override
    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    @Override
    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getSystemPriceType() {
        return this.systemPriceType;
    }

    public void setSystemPriceType(String systemPriceType) {
        this.systemPriceType = systemPriceType == null ? null : systemPriceType.trim();
    }

    public BigDecimal getPlanDeliveryDays() {
        return this.planDeliveryDays;
    }

    public void setPlanDeliveryDays(BigDecimal planDeliveryDays) {
        this.planDeliveryDays = planDeliveryDays;
    }

    public BigDecimal getStandardPurchase() {
        return this.standardPurchase;
    }

    public void setStandardPurchase(BigDecimal standardPurchase) {
        this.standardPurchase = standardPurchase;
    }

    public BigDecimal getMinPurchase() {
        return this.minPurchase;
    }

    public void setMinPurchase(BigDecimal minPurchase) {
        this.minPurchase = minPurchase;
    }

    public BigDecimal getMaxPurchase() {
        return this.maxPurchase;
    }

    public void setMaxPurchase(BigDecimal maxPurchase) {
        this.maxPurchase = maxPurchase;
    }

    @Override
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency == null ? null : currency.trim();
    }

    @Override
    public Integer getValuationUnit() {
        return this.valuationUnit;
    }

    public void setValuationUnit(Integer valuationUnit) {
        this.valuationUnit = valuationUnit;
    }

    public Date getPriceValidTime() {
        return this.priceValidTime;
    }

    public void setPriceValidTime(Date priceValidTime) {
        this.priceValidTime = priceValidTime;
    }

    public Date getPriceExpiredTime() {
        return this.priceExpiredTime;
    }

    public void setPriceExpiredTime(Date priceExpiredTime) {
        this.priceExpiredTime = priceExpiredTime;
    }

    public String getPriceCtrlSign() {
        return this.priceCtrlSign;
    }

    public void setPriceCtrlSign(String priceCtrlSign) {
        this.priceCtrlSign = priceCtrlSign == null ? null : priceCtrlSign.trim();
    }

    public BigDecimal getCycleUnitPrice() {
        return this.cycleUnitPrice;
    }

    public void setCycleUnitPrice(BigDecimal cycleUnitPrice) {
        this.cycleUnitPrice = cycleUnitPrice;
    }

    public BigDecimal getStandardPrice() {
        return this.standardPrice;
    }

    public void setStandardPrice(BigDecimal standardPrice) {
        this.standardPrice = standardPrice;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType == null ? null : dataType.trim();
    }

    public Long getInnerTableIndex() {
        return this.innerTableIndex;
    }

    public void setInnerTableIndex(Long innerTableIndex) {
        this.innerTableIndex = innerTableIndex;
    }

    public String getConditionType() {
        return this.conditionType;
    }

    public void setConditionType(String conditionType) {
        this.conditionType = conditionType == null ? null : conditionType.trim();
    }

    public BigDecimal getConditionPrice() {
        return this.conditionPrice;
    }

    public void setConditionPrice(BigDecimal conditionPrice) {
        this.conditionPrice = conditionPrice;
    }

    public String getConditionPriceUnit() {
        return this.conditionPriceUnit;
    }

    public void setConditionPriceUnit(String conditionPriceUnit) {
        this.conditionPriceUnit = conditionPriceUnit == null ? null : conditionPriceUnit.trim();
    }

    public Integer getAdditionalStartDays() {
        return this.additionalStartDays;
    }

    public void setAdditionalStartDays(Integer additionalStartDays) {
        this.additionalStartDays = additionalStartDays;
    }

    @Override
    public String getMeasurementUnit() {
        return this.measurementUnit;
    }

    public void setMeasurementUnit(String measurementUnit) {
        this.measurementUnit = measurementUnit == null ? null : measurementUnit.trim();
    }

    public String getFixedSupply() {
        return this.fixedSupply;
    }

    public void setFixedSupply(String fixedSupply) {
        this.fixedSupply = fixedSupply == null ? null : fixedSupply.trim();
    }

    public String getZid() {
        return this.zid;
    }

    public void setZid(String zid) {
        this.zid = zid == null ? null : zid.trim();
    }

    @Override
    public String getTargetId() {
        return this.targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId == null ? null : targetId.trim();
    }

    @Override
    public BigDecimal getTargetPrice() {
        return this.targetPrice;
    }

    @Override
    public void setTargetPrice(BigDecimal targetPrice) {
        this.targetPrice = targetPrice;
    }

    @Override
    public BigDecimal getErpSystemPrice() {
        return this.erpSystemPrice;
    }

    @Override
    public void setErpSystemPrice(BigDecimal erpSystemPrice) {
        this.erpSystemPrice = erpSystemPrice;
    }

    public String getSaleTaxCode() {
        return this.saleTaxCode;
    }

    public void setSaleTaxCode(String saleTaxCode) {
        this.saleTaxCode = saleTaxCode == null ? null : saleTaxCode.trim();
    }

    public String getProVersion() {
        return this.proVersion;
    }

    public void setProVersion(String proVersion) {
        this.proVersion = proVersion == null ? null : proVersion.trim();
    }
}

