/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.file.entity.FileData;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.dao.OrderItemM001Mapper;
import com.els.base.inquiry.entity.OrderItemM001;
import com.els.base.inquiry.entity.OrderItemM001Example;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import com.els.base.inquiry.service.InquiryQuoteLadderService;
import com.els.base.inquiry.service.MaterielParityService;
import com.els.base.inquiry.service.OrderItemM001Service;
import com.els.base.inquiry.service.PropertyValueService;
import com.els.base.inquiry.utils.PropertyValueUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultOrderItemM001Service")
public class OrderItemM001ServiceImpl
implements OrderItemM001Service {
    @Resource
    protected OrderItemM001Mapper orderItemM001Mapper;
    @Resource
    private InquiryQuoteLadderService quoteLadderService;
    @Resource
    private MaterielParityService materielParityService;
    @Resource
    protected PropertyValueService propertyValueService;

    @Transactional
    @CacheEvict(value={"orderItemM001"}, allEntries=true)
    public void addObj(OrderItemM001 t) {
        this.orderItemM001Mapper.insertSelective(t);
        PropertyValueUtils.addPropertyValue(Arrays.asList(t), PropertyDefTplType.ORDER_ITEM.getCode());
    }

    @Transactional
    @CacheEvict(value={"orderItemM001"}, allEntries=true)
    public void deleteObjById(String id) {
        this.orderItemM001Mapper.deleteByPrimaryKey(id);
        PropertyValueUtils.deleteByExtenable(Arrays.asList(id), PropertyDefTplType.ORDER_ITEM.getCode());
    }

    @Transactional
    @CacheEvict(value={"orderItemM001"}, allEntries=true)
    public void modifyObj(OrderItemM001 t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.orderItemM001Mapper.updateByPrimaryKeySelective(t);
        PropertyValueUtils.deleteByExtenable(Arrays.asList(t.getId()), PropertyDefTplType.ORDER_ITEM.getCode());
        PropertyValueUtils.addPropertyValue(Arrays.asList(t), PropertyDefTplType.ORDER_ITEM.getCode());
    }

    @Cacheable(value={"orderItemM001"}, keyGenerator="redisKeyGenerator")
    public OrderItemM001 queryObjById(String id) {
        OrderItemM001 orderItem = this.orderItemM001Mapper.selectByPrimaryKey(id);
        PropertyValueUtils.queryAndSetValue(Arrays.asList(orderItem), PropertyDefTplType.ORDER_ITEM.getCode());
        return orderItem;
    }

    @Cacheable(value={"orderItemM001"}, keyGenerator="redisKeyGenerator")
    public List<OrderItemM001> queryAllObjByExample(OrderItemM001Example example) {
        List<OrderItemM001> orderItemList = this.orderItemM001Mapper.selectByExample(example);
        PropertyValueUtils.queryAndSetValue(orderItemList, PropertyDefTplType.ORDER_ITEM.getCode());
        return orderItemList;
    }

    @Cacheable(value={"orderItemM001"}, keyGenerator="redisKeyGenerator")
    public PageView<OrderItemM001> queryObjByPage(OrderItemM001Example example) {
        PageView<OrderItemM001> pageView = example.getPageView();
        List<OrderItemM001> orderItemList = this.orderItemM001Mapper.selectByExampleByPage(example);
        PropertyValueUtils.queryAndSetValue(orderItemList, PropertyDefTplType.ORDER_ITEM.getCode());
        pageView.setQueryResult(orderItemList);
        return pageView;
    }

    @Override
    @Cacheable(value={"orderItemM001"}, keyGenerator="redisKeyGenerator")
    public List<OrderItemM001> queryByPurOrderId(String purOrderId) {
        OrderItemM001Example example = new OrderItemM001Example();
        example.createCriteria().andPurOrderIdEqualTo(purOrderId);
        List<OrderItemM001> orderItemList = this.orderItemM001Mapper.selectByExample(example);
        PropertyValueUtils.queryAndSetValue(orderItemList, PropertyDefTplType.ORDER_ITEM.getCode());
        return orderItemList;
    }

    @Override
    @Cacheable(value={"orderItemM001"}, keyGenerator="redisKeyGenerator")
    public List<OrderItemM001> queryBySupOrderId(String supOrderId) {
        OrderItemM001Example example = new OrderItemM001Example();
        example.createCriteria().andSupOrderIdEqualTo(supOrderId);
        List<OrderItemM001> orderItemM001s = this.orderItemM001Mapper.selectByExample(example);
        PropertyValueUtils.queryAndSetValue(orderItemM001s, PropertyDefTplType.ORDER_ITEM.getCode());
        return orderItemM001s;
    }

    @Override
    public FileData print(String projectId, String companyId, List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u4f20\u8f93\u6570\u636e\u4e3a\u7a7a");
        return null;
    }

    @Override
    @Transactional
    @CacheEvict(value={"orderItemM001"}, allEntries=true)
    public void deleteByPurOrderId(String purOrderId) {
        OrderItemM001Example example = new OrderItemM001Example();
        example.createCriteria().andPurOrderIdEqualTo(purOrderId);
        List<OrderItemM001> orderItemList = this.orderItemM001Mapper.selectByExample(example);
        List<String> orderItemIdList = orderItemList.stream().map(OrderItemM001::getId).collect(Collectors.toList());
        PropertyValueUtils.deleteByExtenable(orderItemIdList, PropertyDefTplType.ORDER_ITEM.getCode());
        this.orderItemM001Mapper.deleteByExample(example);
    }

    @Transactional
    @CacheEvict(value={"orderItemM001"}, allEntries=true)
    public void addAll(List<OrderItemM001> orderItemList) {
        if (CollectionUtils.isEmpty(orderItemList)) {
            return;
        }
        orderItemList.stream().forEach(orderItem -> {
            if (StringUtils.isBlank((String)orderItem.getId())) {
                orderItem.setId(UUIDGenerator.generateUUID());
            }
        });
        this.orderItemM001Mapper.insertBatch(orderItemList);
        PropertyValueUtils.addPropertyValue(orderItemList, PropertyDefTplType.ORDER_ITEM.getCode());
    }

    @Override
    @CacheEvict(value={"orderItemM001"}, allEntries=true)
    public void modifyStatus(IOrderItem item) {
        Assert.isNotBlank((String)item.getId(), (String)"Id\u4e3a\u7a7a\u65e0\u6cd5\u66f4\u65b0");
        OrderItemM001 temp = (OrderItemM001)item;
        this.orderItemM001Mapper.updateByPrimaryKeySelective(temp);
    }

    @Override
    @Transactional
    @CacheEvict(value={"orderItemM001"}, allEntries=true)
    public void deleteBySupOrderId(String supOrderId) {
        OrderItemM001Example example = new OrderItemM001Example();
        example.createCriteria().andSupOrderIdEqualTo(supOrderId);
        List<OrderItemM001> orderItemList = this.orderItemM001Mapper.selectByExample(example);
        List<String> orderItemIdList = orderItemList.stream().map(OrderItemM001::getId).collect(Collectors.toList());
        PropertyValueUtils.deleteByExtenable(orderItemIdList, PropertyDefTplType.ORDER_ITEM.getCode());
        this.orderItemM001Mapper.deleteByExample(example);
    }

    @Override
    @Cacheable(value={"orderItemM001"}, keyGenerator="redisKeyGenerator")
    public List<OrderItemM001> queryPublishedItemByPurOrderId(String purOrderId) {
        OrderItemM001Example example = new OrderItemM001Example();
        example.createCriteria().andPurOrderIdEqualTo(purOrderId).andQuotationStatusIn((List)Arrays.asList(InquiryQuoteStatus.REQUOTED.getCode(), InquiryQuoteStatus.QUOTED.getCode(), InquiryQuoteStatus.REQUOTE.getCode()));
        List<OrderItemM001> orderItemList = this.orderItemM001Mapper.selectByExample(example);
        PropertyValueUtils.queryAndSetValue(orderItemList, PropertyDefTplType.ORDER_ITEM.getCode());
        return orderItemList;
    }

    public void deleteByExample(OrderItemM001Example example) {
    }
}

