/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.dao.OrderItemM002Mapper;
import com.els.base.inquiry.entity.OrderItemM002;
import com.els.base.inquiry.entity.OrderItemM002Example;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import com.els.base.inquiry.service.OrderItemM002Service;
import com.els.base.inquiry.utils.PropertyValueUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultOrderItemM002Service")
public class OrderItemM002ServiceImpl
implements OrderItemM002Service {
    @Resource
    protected OrderItemM002Mapper orderItemM002Mapper;

    @Transactional
    @CacheEvict(value={"orderItemM002"}, allEntries=true)
    public void addObj(OrderItemM002 t) {
        this.orderItemM002Mapper.insertSelective(t);
        PropertyValueUtils.addPropertyValue(Arrays.asList(t), PropertyDefTplType.ORDER_ITEM.getCode());
    }

    @Transactional
    @CacheEvict(value={"orderItemM002"}, allEntries=true)
    public void addAll(List<OrderItemM002> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.orderItemM002Mapper.insertBatch(list);
        PropertyValueUtils.addPropertyValue(list, PropertyDefTplType.ORDER_ITEM.getCode());
    }

    @Transactional
    @CacheEvict(value={"orderItemM002"}, allEntries=true)
    public void deleteObjById(String id) {
        this.orderItemM002Mapper.deleteByPrimaryKey(id);
        PropertyValueUtils.deleteByExtenable(Arrays.asList(id), PropertyDefTplType.ORDER_ITEM.getCode());
    }

    @Transactional
    @CacheEvict(value={"orderItemM002"}, allEntries=true)
    public void deleteByExample(OrderItemM002Example example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
    }

    @Transactional
    @CacheEvict(value={"orderItemM002"}, allEntries=true)
    public void modifyObj(OrderItemM002 t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.orderItemM002Mapper.updateByPrimaryKeySelective(t);
        PropertyValueUtils.deleteByExtenable(Arrays.asList(t.getId()), PropertyDefTplType.ORDER_ITEM.getCode());
        PropertyValueUtils.addPropertyValue(Arrays.asList(t), PropertyDefTplType.ORDER_ITEM.getCode());
    }

    @Cacheable(value={"orderItemM002"}, keyGenerator="redisKeyGenerator")
    public OrderItemM002 queryObjById(String id) {
        OrderItemM002 orderItem = this.orderItemM002Mapper.selectByPrimaryKey(id);
        PropertyValueUtils.queryAndSetValue(Arrays.asList(orderItem), PropertyDefTplType.ORDER_ITEM.getCode());
        return orderItem;
    }

    @Cacheable(value={"orderItemM002"}, keyGenerator="redisKeyGenerator")
    public List<OrderItemM002> queryAllObjByExample(OrderItemM002Example example) {
        List<OrderItemM002> orderItemList = this.orderItemM002Mapper.selectByExample(example);
        PropertyValueUtils.queryAndSetValue(orderItemList, PropertyDefTplType.ORDER_ITEM.getCode());
        return orderItemList;
    }

    @Cacheable(value={"orderItemM002"}, keyGenerator="redisKeyGenerator")
    public PageView<OrderItemM002> queryObjByPage(OrderItemM002Example example) {
        PageView<OrderItemM002> pageView = example.getPageView();
        List<OrderItemM002> orderItemList = this.orderItemM002Mapper.selectByExampleByPage(example);
        PropertyValueUtils.queryAndSetValue(orderItemList, PropertyDefTplType.ORDER_ITEM.getCode());
        pageView.setQueryResult(orderItemList);
        return pageView;
    }

    @Override
    @Cacheable(value={"orderItemM002"}, keyGenerator="redisKeyGenerator")
    public List<OrderItemM002> queryByPurOrderId(String purOrderId) {
        OrderItemM002Example example = new OrderItemM002Example();
        example.createCriteria().andPurOrderIdEqualTo(purOrderId);
        List<OrderItemM002> orderItemList = this.orderItemM002Mapper.selectByExample(example);
        PropertyValueUtils.queryAndSetValue(orderItemList, PropertyDefTplType.ORDER_ITEM.getCode());
        return orderItemList;
    }

    @Override
    @Cacheable(value={"orderItemM002"}, keyGenerator="redisKeyGenerator")
    public List<OrderItemM002> queryBySupOrderId(String supOrderId) {
        OrderItemM002Example example = new OrderItemM002Example();
        example.createCriteria().andSupOrderIdEqualTo(supOrderId);
        List<OrderItemM002> orderItemM001s = this.orderItemM002Mapper.selectByExample(example);
        PropertyValueUtils.queryAndSetValue(orderItemM001s, PropertyDefTplType.ORDER_ITEM.getCode());
        return orderItemM001s;
    }

    @Override
    @Transactional
    @CacheEvict(value={"orderItemM002"}, allEntries=true)
    public void deleteByPurOrderId(String purOrderId) {
        OrderItemM002Example example = new OrderItemM002Example();
        example.createCriteria().andPurOrderIdEqualTo(purOrderId);
        List<OrderItemM002> orderItemList = this.orderItemM002Mapper.selectByExample(example);
        List<String> orderItemIdList = orderItemList.stream().map(OrderItemM002::getId).collect(Collectors.toList());
        PropertyValueUtils.deleteByExtenable(orderItemIdList, PropertyDefTplType.ORDER_ITEM.getCode());
        this.orderItemM002Mapper.deleteByExample(example);
    }

    @Override
    @Transactional
    @CacheEvict(value={"orderItemM002"}, allEntries=true)
    public void modifyStatus(IOrderItem tempItem) {
        Assert.isNotBlank((String)tempItem.getId(), (String)"Id\u4e3a\u7a7a\u65e0\u6cd5\u66f4\u65b0");
        OrderItemM002 temp = (OrderItemM002)tempItem;
        this.orderItemM002Mapper.updateByPrimaryKeySelective(temp);
    }

    @Override
    @Transactional
    @CacheEvict(value={"orderItemM002"}, allEntries=true)
    public void deleteBySupOrderId(String supOrderId) {
        OrderItemM002Example example = new OrderItemM002Example();
        example.createCriteria().andSupOrderIdEqualTo(supOrderId);
        List<OrderItemM002> orderItemList = this.orderItemM002Mapper.selectByExample(example);
        List<String> orderItemIdList = orderItemList.stream().map(OrderItemM002::getId).collect(Collectors.toList());
        PropertyValueUtils.deleteByExtenable(orderItemIdList, PropertyDefTplType.ORDER_ITEM.getCode());
        this.orderItemM002Mapper.deleteByExample(example);
    }

    @Override
    @Cacheable(value={"orderItemM002"}, keyGenerator="redisKeyGenerator")
    public List<OrderItemM002> queryPublishedItemByPurOrderId(String purOrderId) {
        OrderItemM002Example example = new OrderItemM002Example();
        example.createCriteria().andPurOrderIdEqualTo(purOrderId).andQuotationStatusIn((List)Arrays.asList(InquiryQuoteStatus.REQUOTED.getCode(), InquiryQuoteStatus.QUOTED.getCode(), InquiryQuoteStatus.REQUOTE.getCode()));
        List<OrderItemM002> orderItemList = this.orderItemM002Mapper.selectByExample(example);
        PropertyValueUtils.queryAndSetValue(orderItemList, PropertyDefTplType.ORDER_ITEM.getCode());
        return orderItemList;
    }
}

