/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.dao.PurOrderMapper;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.PurOrderExample;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import com.els.base.inquiry.event.ApprovePassListener;
import com.els.base.inquiry.service.PurOrderService;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.service.WorkFlowService;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultPurOrderService")
public class PurOrderServiceImpl
implements PurOrderService {
    private static Logger logger = LoggerFactory.getLogger(PurOrderServiceImpl.class);
    @Resource
    protected PurOrderMapper purOrderMapper;
    @Resource
    private WorkFlowService workFlowService;

    @CacheEvict(value={"purOrder"}, allEntries=true)
    public void addObj(PurOrder t) {
        this.purOrderMapper.insertSelective(t);
    }

    @CacheEvict(value={"purOrder"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purOrderMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purOrder"}, allEntries=true)
    public void modifyObj(PurOrder t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.purOrderMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purOrder"}, keyGenerator="redisKeyGenerator")
    public PurOrder queryObjById(String id) {
        return this.purOrderMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purOrder"}, keyGenerator="redisKeyGenerator")
    public List<PurOrder> queryAllObjByExample(PurOrderExample example) {
        return this.purOrderMapper.selectByExample(example);
    }

    @Cacheable(value={"purOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<PurOrder> queryObjByPage(PurOrderExample example) {
        PageView<PurOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.purOrderMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"purOrder"}, allEntries=true)
    public void transformToUnPublish(List<String> ids) {
        logger.info("\u5c06\u8be2\u4ef7\u5355\u72b6\u6001\u6539\u6210\u672a\u53d1\u5e03");
        this.modifyOrderStatusByIds(ids, InquiryOrderStatus.UNPUBLISHED);
    }

    private void modifyOrderStatusByIds(List<String> ids, InquiryOrderStatus status) {
        Assert.isNotEmpty(ids, (String)"\u8ba2\u5355id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        PurOrderExample purOrderExample = new PurOrderExample();
        purOrderExample.createCriteria().andIdIn((List)ids);
        PurOrder record = new PurOrder();
        record.setInquiryOrderStatus(status.getCode());
        this.purOrderMapper.updateByExampleSelective(record, purOrderExample);
    }

    @Override
    @CacheEvict(value={"purOrder"}, allEntries=true)
    public void cancelAllPurOrders(List<String> ids) {
        this.modifyOrderStatusByIds(ids, InquiryOrderStatus.INVALID);
    }

    @Override
    @CacheEvict(value={"purOrder"}, allEntries=true)
    public void deleteAllPurOrders(List<String> ids) {
        this.modifyOrderStatusByIds(ids, InquiryOrderStatus.DELETE);
    }

    @Override
    public void sendToApprove(PurOrder purOrder) {
        ProcessStartVO vo = ProcessStartVO.newInstance((String)"xjdgl", (String)purOrder.getOrderNo(), (String)purOrder.getId(), null);
        vo.setListenerClass(ApprovePassListener.class);
        ProcessInstance startProcess = this.workFlowService.startProcess(vo);
        if (startProcess == null) {
            throw new CommonException("\u542f\u52a8\u5ba1\u6279\u6d41\u7a0b\u5931\u8d25");
        }
    }

    public void deleteByExample(PurOrderExample example) {
    }

    public void addAll(List<PurOrder> list) {
    }
}

