/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.utils.json;

import com.els.base.core.utils.Constant;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.entity.OrderItemM001;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.utils.json.DetailDeSerializer;
import com.els.base.inquiry.utils.json.ExtendableObjectJsonDeSerialzer;
import com.els.base.utils.SpringContextHolder;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderItemM001JsonDeSerialzer
extends ExtendableObjectJsonDeSerialzer<OrderItemM001> {
    protected static final Logger logger = LoggerFactory.getLogger(OrderItemM001JsonDeSerialzer.class);
    private String itemDetailJson = null;

    @Override
    public OrderItemM001 deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        OrderItemM001 instance = (OrderItemM001)super.deserialize(p, ctxt);
        if (StringUtils.isBlank((String)this.itemDetailJson)) {
            return instance;
        }
        if (StringUtils.isBlank((String)instance.getTemplateId())) {
            logger.warn("OrderItemM001.template == null \uff0c\u65e0\u6cd5\u89e3\u6790\u7269\u6599\u6210\u672c\u6e05\u5355");
            return instance;
        }
        IOrderItemDetail orderItemDetail = null;
        try {
            orderItemDetail = this.deserializeOrderItemDetail(this.itemDetailJson, instance);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("\u53c2\u6570\u89e3\u6790\u5931\u8d25", e);
        }
        instance.setOrderItemDetail(orderItemDetail);
        return instance;
    }

    @Override
    protected void setPrimitFieldValue(OrderItemM001 t, Field field, JsonNode jsonNode) throws Exception {
        if (jsonNode == null) {
            return;
        }
        if ("orderItemDetail".equals(field.getName())) {
            this.itemDetailJson = jsonNode.toString();
            return;
        }
        super.setPrimitFieldValue(t, field, jsonNode);
    }

    private IOrderItemDetail deserializeOrderItemDetail(String itemDetailJson, OrderItemM001 orderItem) throws JsonParseException, JsonMappingException, IOException, InstantiationException, IllegalAccessException {
        TemplateConf templateConf = (TemplateConf)((TemplateConfService)SpringContextHolder.getOneBean(TemplateConfService.class)).queryObjById(orderItem.getTemplateId());
        if (!Constant.YES_INT.equals(templateConf.getIsOrderItemDetailEnable())) {
            return null;
        }
        Class<? extends IOrderItemDetail> clazz = templateConf.getTplOrderItemDetail().getOrderItemDetailClass();
        DetailDeSerializer<? extends IOrderItemDetail> serializer = new DetailDeSerializer<IOrderItemDetail>(clazz);
        IOrderItemDetail instance = serializer.serializer(itemDetailJson);
        return instance;
    }

    @Override
    public Class<OrderItemM001> getInstanceClass() {
        return OrderItemM001.class;
    }
}

