/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.pur.ViewDetailCommand;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryAuditStatus;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.enumclass.OperationTypeEnum;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class BatchPricingCommand
extends AbstractInquiryCommand<String> {
    private List<IOrderItem> orderItemList;

    public BatchPricingCommand(List<IOrderItem> orderItemList) {
        this.orderItemList = orderItemList;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        Assert.isNotEmpty(this.orderItemList, (String)"\u5b9a\u4ef7\u7684\u62a5\u4ef7\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
        List orderList = this.orderItemList.parallelStream().map(IOrderItem::getPurOrderId).distinct().map(orderId -> invoker.invoke(new ViewDetailCommand((String)orderId))).collect(Collectors.toList());
        List templateConfList = orderList.stream().map(PurOrder::getTemplateId).distinct().map(templateConfId -> (TemplateConf)invoker.getTemplateConfService().queryObjById(templateConfId)).collect(Collectors.toList());
        for (PurOrder purOrder : orderList) {
            List<IOrderItem> tempList = this.orderItemList.stream().filter(tmp -> tmp.getPurOrderId().equals(purOrder.getId())).collect(Collectors.toList());
            TemplateConf templateConf = templateConfList.stream().filter(tmp -> tmp.getId().equals(purOrder.getTemplateId())).findAny().orElse(null);
            this.pricing(purOrder, tempList, templateConf);
        }
        return null;
    }

    private void pricing(PurOrder purOrder, List<IOrderItem> orderItemList, TemplateConf templateConf) {
        if (purOrder == null || templateConf == null || CollectionUtils.isEmpty(orderItemList)) {
            throw new CommonException("\u914d\u7f6e\u6570\u636e\u6216\u8005\u8be2\u4ef7\u5355\u6570\u636e\u5f02\u5e38");
        }
        this.valid(purOrder);
        this.valid(purOrder, orderItemList);
        try {
            this.updateOrderItemStatus(templateConf, orderItemList);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void updateOrderItemStatus(TemplateConf templateConf, List<IOrderItem> orderItemList) throws InstantiationException, IllegalAccessException {
        for (IOrderItem orderItem : orderItemList) {
            IOrderItem tempItem = templateConf.getOrderItemClass().newInstance();
            tempItem.setId(orderItem.getId());
            tempItem.setOperation(orderItem.getOperation());
            tempItem.setMaterialCode(orderItem.getMaterialCode());
            tempItem.setSupCompanySapCode(orderItem.getSupCompanySapCode());
            tempItem.setPurRemark(orderItem.getPurRemark());
            templateConf.getOrderItemService().modifyStatus(tempItem);
        }
    }

    private void valid(PurOrder purOrder, List<IOrderItem> orderItemList) {
        for (IOrderItem item : orderItemList) {
            if (!OperationTypeEnum.isPricingOperation(item.getOperation())) {
                throw new CommonException(String.format("\u8be2\u4ef7\u5355\u65e0\u6cd5\u8bc6\u522b\u5b9a\u4ef7\u64cd\u4f5c, \u8be2\u4ef7\u5355[%s],\u7269\u6599[%s],\u62a5\u4ef7\u4f9b\u5e94\u5546[%s]", purOrder.getOrderNo(), item.getMaterialDesc(), item.getSupCompanyName()));
            }
            if (InquiryQuoteStatus.QUOTED.getCode().equals(item.getQuotationStatus()) || InquiryQuoteStatus.REQUOTED.getCode().equals(item.getQuotationStatus())) continue;
            throw new CommonException(String.format("\u4f9b\u5e94\u5546\u672a\u62a5\u4ef7\u65e0\u6cd5\u5b9a\u4ef7\u3002\u8be2\u4ef7\u5355[%s],\u7269\u6599[%s],\u62a5\u4ef7\u4f9b\u5e94\u5546[%s]\u5355", purOrder.getOrderNo(), item.getMaterialDesc(), item.getSupCompanyName()));
        }
    }

    private void valid(PurOrder purOrder) {
        if (!InquiryOrderStatus.PUBLISHED.getCode().equals(purOrder.getInquiryOrderStatus())) {
            throw new CommonException(String.format("\u8be2\u4ef7\u5355[%s]\u53d1\u5e03\u4e4b\u540e\u624d\u80fd\u8fdb\u884c\u5b9a\u4ef7", purOrder.getOrderNo()));
        }
        if (InquiryAuditStatus.AUDITING.getCode().equals(purOrder.getAuditStatus())) {
            throw new CommonException(String.format("\u8be2\u4ef7\u5355[%s]\u5ba1\u6838\u4e2d\uff0c\u65e0\u6cd5\u5b9a\u4ef7", purOrder.getOrderNo()));
        }
        if (InquiryAuditStatus.AUDIT_PASS.getCode().equals(purOrder.getAuditStatus())) {
            throw new CommonException(String.format("\u8be2\u4ef7\u5355[%s]\u5ba1\u6838\u5df2\u901a\u8fc7\uff0c\u65e0\u6cd5\u5b9a\u4ef7", purOrder.getOrderNo()));
        }
    }
}

