/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.pur.ReQuoteCommand;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BatchReQuoteCommand
extends AbstractInquiryCommand<String> {
    private List<IOrderItem> orderItemList;

    public BatchReQuoteCommand(List<IOrderItem> orderItemList) {
        this.orderItemList = orderItemList;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        Assert.isNotEmpty(this.orderItemList, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Map<String, List<IOrderItem>> purOrderGroup = this.orderItemList.stream().collect(Collectors.groupingBy(IOrderItem::getPurOrderId));
        for (String purOrderId : purOrderGroup.keySet()) {
            List<IOrderItem> orderItemGroup = purOrderGroup.get(purOrderId);
            ReQuoteCommand reQuoteCommand = new ReQuoteCommand(purOrderId, orderItemGroup);
            reQuoteCommand.copyProperties(this);
            this.invoker.invoke(reQuoteCommand);
        }
        return null;
    }
}

