/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.pur.SyncPriceToSapCmd;
import com.els.base.inquiry.command.pur.ViewPricingDetailCommand;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.enumclass.InquiryAuditStatus;
import com.els.base.inquiry.web.vo.OrderItemVo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class BatchSyncPriceToSapCmd
extends AbstractInquiryCommand<List<IOrderItem>> {
    private List<OrderItemVo> vos;

    public BatchSyncPriceToSapCmd(List<OrderItemVo> vos) {
        this.vos = vos;
    }

    @Override
    public List<IOrderItem> execute(InquiryCommandInvoker invoker) {
        for (OrderItemVo orderItemVo : this.vos) {
            Assert.isNotBlank((String)orderItemVo.getPurOrderId(), (String)"\u4f20\u5165\u7684\u91c7\u8d2d\u5546\u8868\u5934ID\u4e3a\u7a7a");
            Assert.isNotBlank((String)orderItemVo.getItemId(), (String)"\u4f20\u5165\u7684\u91c7\u8d2d\u5546\u8868\u5934ID\u4e3a\u7a7a");
        }
        List itemIdList = this.vos.stream().map(OrderItemVo::getItemId).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        Map<String, List<OrderItemVo>> group = this.vos.stream().collect(Collectors.groupingBy(OrderItemVo::getPurOrderId));
        List orderList = group.keySet().stream().map(purOrderId -> invoker.invoke(new ViewPricingDetailCommand(this.vos.get(0).getPurOrderId()))).collect(Collectors.toList());
        for (PurOrder purOrder2 : orderList) {
            if (InquiryAuditStatus.AUDIT_PASS.getCode().equals(purOrder2.getAuditStatus())) continue;
            throw new CommonException(String.format("\u8be2\u4ef7\u5355%s\u5ba1\u6279\u8fd8\u6ca1\u6709\u901a\u8fc7\uff0c\u4e0d\u80fd\u5199\u5165SAP", purOrder2.getOrderNo()));
        }
        List<IOrderItem> itemList = orderList.stream().flatMap(purOrder -> purOrder.getItemList().stream()).filter(item -> itemIdList.contains(item.getId())).collect(Collectors.toList());
        Assert.isNotEmpty(itemList, (String)"\u4f20\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u53cd\u5199sap\u5931\u8d25");
        SyncPriceToSapCmd syncPriceToSapCmd = new SyncPriceToSapCmd(itemList);
        syncPriceToSapCmd.copyProperties(this);
        return invoker.invoke(syncPriceToSapCmd);
    }
}

