/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.company.entity.Company;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquiryPurFile;
import com.els.base.inquiry.entity.InquiryQuoteLadder;
import com.els.base.inquiry.entity.InquirySupplier;
import com.els.base.inquiry.entity.InquiryWaitMaterial;
import com.els.base.inquiry.entity.InquiryWaitMaterialExample;
import com.els.base.inquiry.entity.PropertyValue;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryAuditStatus;
import com.els.base.inquiry.enumclass.InquiryFileType;
import com.els.base.inquiry.enumclass.InquiryLadderBelongType;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import com.els.base.inquiry.enumclass.InquiryQuoteLadderType;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.utils.LaddPriceValider;
import com.els.base.inquiry.utils.PropertyValueUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class CreateCommand
extends AbstractInquiryCommand<String> {
    private PurOrder order;
    private TemplateConf templateConf;

    public CreateCommand(PurOrder inquiryPurOrder) {
        this.order = inquiryPurOrder;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        this.templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(this.order.getTemplateId());
        this.valid(this.order);
        this.init(this.order);
        invoker.getPurOrderService().addObj(this.order);
        this.saveTarget(this.order);
        this.saveLadderPrice(this.order.getTargetList());
        this.setWaitMaterialStatus(this.order);
        this.savePurFile(this.order);
        invoker.getInquirySupplierService().addAll(this.order.getId(), this.order.getInquirySuppliers());
        this.saveBusiCondition(this.order);
        this.saveDataToOrder(this.order.getInquirySuppliers(), this.order.getTargetList());
        return this.order.getId();
    }

    private void saveDataToOrder(List<InquirySupplier> inquirySuppliers, List<ITarget> targetList) {
        String tempSupCompanyName = inquirySuppliers.stream().map(inquirySupplier -> inquirySupplier.getSupCompanyName() != null ? inquirySupplier.getSupCompanyName() : null).distinct().filter(name -> name != null).collect(Collectors.joining("&"));
        String tempMaterialCode = targetList.stream().map(iTarget -> iTarget.getMaterialCode() != null ? iTarget.getMaterialCode() : null).distinct().filter(materialCode -> materialCode != null).collect(Collectors.joining("&"));
        String tempMaterialDesc = targetList.stream().map(iTarget -> iTarget.getMaterialDesc() != null ? iTarget.getMaterialDesc() : null).distinct().filter(materialDesc -> materialDesc != null).collect(Collectors.joining("&"));
        String tempBrand = targetList.stream().map(iTarget -> iTarget.getBrand() != null ? iTarget.getBrand() : null).distinct().filter(brand -> brand != null).collect(Collectors.joining("&"));
        PurOrder tempOrder = new PurOrder();
        tempOrder.setId(this.order.getId());
        tempOrder.setSupCompanyNameList(tempSupCompanyName);
        tempOrder.setMaterialCodeList(tempMaterialCode);
        tempOrder.setMaterialDescList(tempMaterialDesc);
        tempOrder.setBrandList(tempBrand);
        this.invoker.getPurOrderService().modifyObj(tempOrder);
    }

    private void saveBusiCondition(PurOrder purOrder) {
        if (Constant.NO_INT.equals(this.templateConf.getIsBusiCondEnable())) {
            return;
        }
        List<InquiryBusiCondition> busiConditionList = purOrder.getInquirySuppliers().stream().map(supplier -> {
            InquiryBusiCondition inquiryBusiCondition = new InquiryBusiCondition();
            inquiryBusiCondition.setPurOrderId(purOrder.getId());
            inquiryBusiCondition.setSupCompanyId(supplier.getSupCompanyId());
            inquiryBusiCondition.setSupCompanyName(supplier.getSupCompanyName());
            inquiryBusiCondition.setSupCompanySrmCode(supplier.getSupCompanySrmCode());
            Company company = (Company)this.invoker.getCompanyService().queryObjById((Object)supplier.getSupCompanyId());
            if (company == null) {
                throw new CommonException("\u4f9b\u5e94\u5546ID\u9519\u8bef,\u751f\u6210\u4fe1\u606f\u5931\u8d25");
            }
            inquiryBusiCondition.setCurrency(company.getOrderCurren());
            inquiryBusiCondition.setTaxRate(company.getTax());
            inquiryBusiCondition.setTaxType(company.getTaxType());
            inquiryBusiCondition.setPayTerms(company.getPayConditionsCode());
            inquiryBusiCondition.setTemplateConfId(purOrder.getTemplateId());
            List<PropertyValue> defaultValueList = PropertyValueUtils.getDefaultPropertyValue(inquiryBusiCondition);
            List<PropertyValue> existValueList = inquiryBusiCondition.getPropertyValueList();
            this.addDefaultValue(existValueList, defaultValueList);
            return inquiryBusiCondition;
        }).collect(Collectors.toList());
        this.invoker.getInquiryBusiConditionService().addAll(busiConditionList);
    }

    private void savePurFile(PurOrder order) {
        if (CollectionUtils.isEmpty(order.getPurFileList())) {
            return;
        }
        for (InquiryPurFile inquiryPurFile : order.getPurFileList()) {
            inquiryPurFile.setPurOrderId(order.getId());
            if ("-10".equals(inquiryPurFile.getPurOrderItemNo().trim())) {
                inquiryPurFile.setType(InquiryFileType.PUBLIC.getCode());
            } else {
                inquiryPurFile.setType(InquiryFileType.PRIVATE.getCode());
            }
            this.invoker.getInquiryPurFileService().addObj(inquiryPurFile);
        }
    }

    protected void saveTarget(PurOrder order) {
        if (CollectionUtils.isEmpty(order.getTargetList())) {
            return;
        }
        order.getTargetList().forEach(target -> {
            target.setPurOrderId(order.getId());
            target.setOrderNo(order.getOrderNo());
            target.setTemplateId(this.templateConf.getId());
            target.setUnableToQuote(null);
            List<PropertyValue> defaultValueList = PropertyValueUtils.getDefaultPropertyValue(target);
            List<PropertyValue> existValueList = target.getPropertyValueList();
            this.addDefaultValue(existValueList, defaultValueList);
        });
        this.templateConf.getTargetService().addAll(order.getTargetList());
    }

    protected void init(PurOrder order) {
        this.generatePurOrder(order);
        this.generateTarget(order);
    }

    private void generateTarget(PurOrder order) {
        order.getTargetList().sort((t1, t2) -> {
            if (StringUtils.isBlank((String)t1.getMaterialCode())) {
                return -1;
            }
            if (StringUtils.isBlank((String)t2.getMaterialCode())) {
                return 1;
            }
            return t1.getMaterialCode().compareTo(t2.getMaterialCode());
        });
        for (int i = 0; i < order.getTargetList().size(); ++i) {
            ITarget target = order.getTargetList().get(i);
            target.setSortNo(i + 1);
            target.setTemplateId(order.getTemplateId());
            target.setOrderNo(order.getOrderNo());
        }
    }

    protected void valid(PurOrder order) {
        Assert.isNotNull((Object)order, (String)"\u8be2\u4ef7\u5355\u5934\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)order.getOrderNo(), (String)"\u8be2\u4ef7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)order.getTemplateId(), (String)"\u8be2\u4ef7\u5355\u7684\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(order.getTargetList(), (String)"\u8be2\u4ef7\u5355\u7684\u7269\u6599\u6e05\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(order.getInquirySuppliers(), (String)"\u8be2\u4ef7\u5355\u7684\u4f9b\u5e94\u5546\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isNotEmpty(order.getPurFileList())) {
            order.getPurFileList().forEach(purFile -> Assert.isNotNull((Object)purFile.getPurOrderItemNo(), (String)"\u8868\u5355\u6587\u4ef6\uff0c\u884c\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (CollectionUtils.isNotEmpty(order.getInquirySuppliers())) {
            order.getInquirySuppliers().forEach(supCompany -> {
                Assert.isNotBlank((String)supCompany.getSupCompanyId(), (String)"\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isNotBlank((String)supCompany.getSupCompanyName(), (String)"\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isNotBlank((String)supCompany.getSupCompanySrmCode(), (String)"\u4f9b\u5e94\u5546SRM\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            });
        }
        ArrayList<String> materialDesList = new ArrayList<String>();
        for (int i = 0; CollectionUtils.isNotEmpty(order.getTargetList()) && i < order.getTargetList().size(); ++i) {
            ITarget target = order.getTargetList().get(i);
            Assert.isNotBlank((String)target.getMaterialDesc(), (String)String.format("\u7b2c %s \u884c\uff0c\u7269\u6599\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a", i + 1));
            String key = String.format("%s-%s", target.getMaterialCode(), target.getMaterialDesc());
            if (materialDesList.contains(key)) {
                throw new CommonException(String.format("\u8be2\u4ef7\u5355\u4e2d\u51fa\u73b0\u91cd\u590d\u7269\u6599\uff0c\u8bf7\u52ff\u91cd\u590d\u8be2\u4ef7\u3002\u7269\u6599: [%s]", target.getMaterialDesc()));
            }
            materialDesList.add(key);
            if (StringUtils.isNotBlank((String)target.getMaterialCode()) && !this.invoker.getMaterialService().isExists(target.getMaterialCode()).booleanValue()) {
                throw new CommonException(String.format("\u7269\u6599\u7f16\u7801[%s],\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728!", target.getMaterialCode()));
            }
            if (StringUtils.isBlank((String)target.getWaitMaterialId())) continue;
            InquiryWaitMaterial temp = (InquiryWaitMaterial)this.invoker.getInquiryWaitMaterialService().queryObjById(target.getWaitMaterialId());
            if (temp != null && Constant.YES_INT.equals(temp.getIsCreateInquiryOrder())) {
                throw new CommonException("\u5f85\u8be2\u4ef7\u7269\u6599\u5df2\u7ecf\u521b\u5efa\u4e86\u8be2\u4ef7\u5355\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u521b\u5efa");
            }
            LaddPriceValider.valid(target.getInquiryQuoteLadders());
        }
    }

    private void generatePurOrder(PurOrder order) {
        if (StringUtils.isBlank((String)order.getPurCompanyId())) {
            order.setPurCompanyId(this.getPurCompany().getId());
        }
        if (StringUtils.isBlank((String)order.getPurCompanyName())) {
            order.setPurCompanyName(this.getPurCompany().getCompanyName());
        }
        if (StringUtils.isBlank((String)order.getPurUserId())) {
            order.setPurUserId(this.getPurUser().getId());
        }
        if (StringUtils.isBlank((String)order.getPurUserName())) {
            order.setPurUserName(this.getPurUser().getLoginName());
        }
        if (order.getCreateDate() == null) {
            order.setCreateDate(new Date());
        }
        if (order.getInquiryOrderStatus() == null) {
            order.setInquiryOrderStatus(InquiryOrderStatus.UNPUBLISHED.getCode());
        }
        if (order.getQuoteStatus() == null) {
            order.setQuoteStatus(InquiryQuoteStatus.UNQUOTED.getCode());
        }
        if (order.getAuditStatus() == null) {
            order.setAuditStatus(InquiryAuditStatus.UNAUDITED.getCode());
        }
    }

    protected void setWaitMaterialStatus(PurOrder order) {
        if (CollectionUtils.isEmpty(order.getTargetList())) {
            return;
        }
        List waitMaterialIdList = order.getTargetList().stream().filter(target -> StringUtils.isNotBlank((String)target.getWaitMaterialId())).map(ITarget::getWaitMaterialId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(waitMaterialIdList)) {
            InquiryWaitMaterialExample example = new InquiryWaitMaterialExample();
            example.createCriteria().andIdIn(waitMaterialIdList);
            InquiryWaitMaterial tmp = new InquiryWaitMaterial();
            tmp.setIsCreateInquiryOrder(Constant.YES_INT);
            tmp.setInquiryOrderNo(order.getOrderNo());
            this.invoker.getInquiryWaitMaterialService().modifyByExample(tmp, example);
        }
    }

    protected void saveLadderPrice(List<ITarget> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(target -> Assert.isNotBlank((String)target.getId(), (String)"targetId\u4e0d\u80fd\u4e3a\u7a7a"));
        List<InquiryQuoteLadder> totalinquiryQuoteLadder = list.stream().filter(target -> InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(target.getQuoteType()) && CollectionUtils.isNotEmpty(target.getInquiryQuoteLadders())).flatMap(target -> {
            List<InquiryQuoteLadder> inquiryQuoteLadders = target.getInquiryQuoteLadders();
            inquiryQuoteLadders.forEach(inquiryQuoteLadder -> {
                inquiryQuoteLadder.setMaterialCode(target.getMaterialCode());
                inquiryQuoteLadder.setMaterialDesc(target.getMaterialDesc());
                inquiryQuoteLadder.setBelongType(InquiryLadderBelongType.BELONG_TO_TARGET.getCode());
                inquiryQuoteLadder.setTargetId(target.getId());
            });
            return inquiryQuoteLadders.stream();
        }).collect(Collectors.toList());
        this.invoker.getInquiryQuoteLadderService().addAll(totalinquiryQuoteLadder);
    }

    private void addDefaultValue(List<PropertyValue> existValueList, List<PropertyValue> defaultValueList) {
        for (PropertyValue defaultValue : defaultValueList) {
            PropertyValue existObject = existValueList.stream().filter(existValue -> defaultValue.getCode().equals(existValue.getCode())).findAny().orElse(null);
            if (existObject == null) {
                existValueList.add(defaultValue);
                continue;
            }
            if (!StringUtils.isBlank((String)existObject.getValueStr()) || !StringUtils.isNotBlank((String)defaultValue.getValueStr())) continue;
            existObject.setValueStr(defaultValue.getValueStr());
        }
    }
}

