/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.ITargetService;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquiryBusiConditionExample;
import com.els.base.inquiry.entity.InquiryPurFileExample;
import com.els.base.inquiry.entity.InquiryQuoteLadderExample;
import com.els.base.inquiry.entity.InquirySupplierExample;
import com.els.base.inquiry.entity.InquiryWaitMaterial;
import com.els.base.inquiry.entity.InquiryWaitMaterialExample;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryLadderBelongType;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class DeleteCommand
extends AbstractInquiryCommand<String> {
    private String id;

    public DeleteCommand(String id) {
        this.id = id;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        Assert.isNotBlank((String)this.id, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        PurOrder purOrder = (PurOrder)this.invoker.getPurOrderService().queryObjById(this.id);
        TemplateConf templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(purOrder.getTemplateId());
        this.valid(purOrder);
        invoker.getPurOrderService().deleteObjById(this.id);
        ITargetService targetService = templateConf.getTargetService();
        List<ITarget> targetList = targetService.queryByPurOrderId(this.id);
        targetService.deleteObjByPurOrderId(this.id);
        this.deleteLadderPrice(targetList);
        this.clearWaitMaterial(targetList);
        InquiryPurFileExample example = new InquiryPurFileExample();
        example.createCriteria().andPurOrderIdEqualTo(this.id);
        this.invoker.getInquiryPurFileService().deleteByExample(example);
        InquirySupplierExample inquirySupplierExample = new InquirySupplierExample();
        inquirySupplierExample.createCriteria().andPurOrderIdEqualTo(this.id);
        this.invoker.getInquirySupplierService().deleteByExample(inquirySupplierExample);
        InquiryBusiConditionExample busiConditionExample = new InquiryBusiConditionExample();
        busiConditionExample.createCriteria().andPurOrderIdEqualTo(this.id);
        this.invoker.getInquiryBusiConditionService().deleteByExample(busiConditionExample);
        return null;
    }

    private void clearWaitMaterial(List<ITarget> targetList) {
        if (CollectionUtils.isEmpty(targetList)) {
            return;
        }
        List waitMaterialIdList = targetList.stream().filter(target -> StringUtils.isNotBlank((String)target.getWaitMaterialId())).map(ITarget::getWaitMaterialId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(waitMaterialIdList)) {
            return;
        }
        InquiryWaitMaterialExample example = new InquiryWaitMaterialExample();
        example.createCriteria().andIdIn(waitMaterialIdList);
        InquiryWaitMaterial tmp = new InquiryWaitMaterial();
        tmp.setIsCreateInquiryOrder(Constant.NO_INT);
        tmp.setInquiryOrderNo("");
        this.invoker.getInquiryWaitMaterialService().modifyByExample(tmp, example);
    }

    private void deleteLadderPrice(List<ITarget> targetList) {
        if (CollectionUtils.isEmpty(targetList)) {
            return;
        }
        List targetIdList = targetList.stream().map(ITarget::getId).collect(Collectors.toList());
        InquiryQuoteLadderExample example = new InquiryQuoteLadderExample();
        example.createCriteria().andTargetIdIn(targetIdList).andBelongTypeEqualTo(InquiryLadderBelongType.BELONG_TO_TARGET.getCode());
        this.invoker.getInquiryQuoteLadderService().deleteByExample(example);
    }

    private void valid(PurOrder purOrder) {
        Assert.isNotNull((Object)purOrder, (String)"\u8be2\u4ef7\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        if (!InquiryOrderStatus.UNPUBLISHED.getCode().equals(purOrder.getInquiryOrderStatus())) {
            throw new CommonException(String.format("\u53ea\u80fd\u5220\u9664\u672a\u53d1\u5e03\u7684\u8be2\u4ef7\u5355\uff0c\u8bf7\u68c0\u67e5\u5355\u53f7\u4e3a[%s]\u7684\u8be2\u4ef7\u5355\u662f\u5426\u7b26\u5408\u6761\u4ef6", purOrder.getOrderNo()));
        }
    }
}

