/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.SyncPriceService;
import com.els.base.inquiry.command.pur.ViewPricingDetailCommand;
import com.els.base.inquiry.entity.InformationRecord;
import com.els.base.inquiry.entity.InformationRecordExample;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquiryQuoteLadder;
import com.els.base.inquiry.entity.OrderItemM001;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.SystemPrice;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import com.els.base.inquiry.enumclass.InquiryQuoteLadderType;
import com.els.base.inquiry.enumclass.OperationTypeEnum;
import com.els.base.utils.SpringContextHolder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class SyncPriceToSapCmd
extends AbstractInquiryCommand<List<IOrderItem>> {
    List<IOrderItem> orderItemList;
    SyncPriceService syncPriceService;
    private List<TemplateConf> templateConfList;
    private List<PurOrder> orderList;

    public SyncPriceToSapCmd(List<IOrderItem> orderItemList) {
        this.orderItemList = orderItemList;
        this.syncPriceService = (SyncPriceService)SpringContextHolder.getOneBean(SyncPriceService.class);
        if (this.syncPriceService == null) {
            throw new CommonException("\u7cfb\u7edf\u8fd8\u6ca1\u6709\u542f\u52a8\u4ef7\u683c\u56de\u5199\u5230sap\u7684\u914d\u7f6e");
        }
    }

    @Override
    public List<IOrderItem> execute(InquiryCommandInvoker invoker) {
        this.getOrderList();
        List<IOrderItem> failOrderItemList = this.writeToSapAndReturnFailList(this.orderItemList);
        if (CollectionUtils.isNotEmpty(failOrderItemList)) {
            this.updateFailReason(failOrderItemList);
        }
        return failOrderItemList;
    }

    private void updateFailReason(List<IOrderItem> failOrderItemList) {
        for (IOrderItem orderItem : failOrderItemList) {
            TemplateConf templateConf = this.getTemplateConf(orderItem.getTemplateId());
            orderItem.setIsImportSap(Constant.NO_INT);
            templateConf.getOrderItemService().modifyStatus(orderItem);
        }
    }

    public List<IOrderItem> writeToSapAndReturnFailList(List<IOrderItem> orderItemList) {
        ArrayList<IOrderItem> failOrderItemList = new ArrayList<IOrderItem>();
        failOrderItemList.addAll(this.getInvalidItem(orderItemList));
        orderItemList.removeAll(failOrderItemList);
        if (CollectionUtils.isEmpty(orderItemList)) {
            return failOrderItemList;
        }
        List orderIdList = orderItemList.stream().map(IOrderItem::getPurOrderId).distinct().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        InformationRecordExample example = new InformationRecordExample();
        example.createCriteria().andPurOrderIdIn(orderIdList);
        List inforList = this.invoker.getInformationRecordService().queryAllObjByExample((IExample)example);
        List<IOrderItem> invalidItemList = this.getInvalidItem(this.getOrderList(), inforList, orderItemList);
        failOrderItemList.addAll(invalidItemList);
        orderItemList.removeAll(invalidItemList);
        if (CollectionUtils.isNotEmpty(orderItemList)) {
            List<IOrderItem> failWriteToSap = this.writeToSapAndReturnFailList(orderItemList, this.getOrderList(), inforList);
            failOrderItemList.addAll(failWriteToSap);
            orderItemList.removeAll(failWriteToSap);
        }
        if (CollectionUtils.isEmpty(orderItemList)) {
            return failOrderItemList;
        }
        List successOrderList = this.getOrderList().stream().filter(order -> orderItemList.stream().anyMatch(orderItem -> orderItem.getPurOrderId().equals(order.getId()))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(successOrderList)) {
            return failOrderItemList;
        }
        for (PurOrder order2 : successOrderList) {
            TemplateConf templateConf = this.getTemplateConf(order2.getTemplateId());
            boolean isAllImportToSap = templateConf.getOrderItemService().checkIsAllImportToSap(order2.getId());
            if (!isAllImportToSap) continue;
            PurOrder tmPurOrder = new PurOrder();
            tmPurOrder.setId(order2.getId());
            tmPurOrder.setInquiryOrderStatus(InquiryOrderStatus.FINISHED.getCode());
            this.invoker.getPurOrderService().modifyObj(tmPurOrder);
        }
        return failOrderItemList;
    }

    private List<PurOrder> getOrderList() {
        if (CollectionUtils.isNotEmpty(this.orderList)) {
            return this.orderList;
        }
        List orderIdList = this.orderItemList.stream().map(IOrderItem::getPurOrderId).distinct().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orderIdList)) {
            throw new CommonException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8be2\u4ef7\u5355\u884c\u9879\u76ee");
        }
        this.orderList = orderIdList.parallelStream().map(purOrderId -> this.invoker.invoke(new ViewPricingDetailCommand((String)purOrderId))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(this.orderList)) {
            throw new CommonException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8be2\u4ef7\u5355");
        }
        return this.orderList;
    }

    private List<IOrderItem> getInvalidItem(List<PurOrder> orderList, List<InformationRecord> inforList, List<IOrderItem> orderItemList) {
        ArrayList<IOrderItem> failOrderItemList = new ArrayList<IOrderItem>();
        for (IOrderItem orderItem : orderItemList) {
            ArrayList<String> reason = new ArrayList<String>();
            PurOrder purOrder = this.getPurOrder(orderList, orderItem.getPurOrderId());
            if (purOrder == null) {
                reason.add("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8be2\u4ef7\u5355\u5934");
            } else {
                InquiryBusiCondition busiCondition = this.getBusiCondition(purOrder.getBusiConditions(), orderItem);
                if (busiCondition == null) {
                    reason.add("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5546\u52a1\u6761\u4ef6");
                } else if (StringUtils.isBlank((String)busiCondition.getTaxRate())) {
                    reason.add("\u5546\u52a1\u6761\u4ef6-\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            InformationRecord infor = this.getInformationRecord(inforList, orderItem.getPurOrderId());
            if (infor == null) {
                reason.add("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4fe1\u606f\u8bb0\u5f55\u6570\u636e");
            } else {
                if (StringUtils.isBlank((String)infor.getConditionalType())) {
                    reason.add("\u4fe1\u606f\u8bb0\u5f55\u4e2d\u6761\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((String)infor.getFactoryCode())) {
                    reason.add("\u4fe1\u606f\u8bb0\u5f55\u4e2d\u5de5\u5382\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((String)infor.getInformationRecordCategory())) {
                    reason.add("\u4fe1\u606f\u8bb0\u5f55\u4e2d\u4fe1\u606f\u8bb0\u5f55\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((String)infor.getPurchaseOrganization())) {
                    reason.add("\u4fe1\u606f\u8bb0\u5f55\u4e2d\u91c7\u8d2d\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((String)infor.getPurchasingGroup())) {
                    reason.add("\u4fe1\u606f\u8bb0\u5f55\u4e2d\u91c7\u8d2d\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (!CollectionUtils.isNotEmpty(reason)) continue;
            orderItem.setFailReason(StringUtils.join(reason, (String)","));
            failOrderItemList.add(orderItem);
        }
        return failOrderItemList;
    }

    private InformationRecord getInformationRecord(List<InformationRecord> inforList, String purOrderId) {
        if (CollectionUtils.isEmpty(inforList)) {
            return null;
        }
        return inforList.stream().filter(infor -> infor.getPurOrderId().equals(purOrderId)).findAny().orElse(null);
    }

    private InquiryBusiCondition getBusiCondition(List<InquiryBusiCondition> busiConditions, IOrderItem orderItem) {
        if (CollectionUtils.isEmpty(busiConditions)) {
            return null;
        }
        return busiConditions.stream().filter(busiCondition -> busiCondition.getSupCompanyId().equals(orderItem.getSupCompanyId()) && (StringUtils.isBlank((String)busiCondition.getSupCompanySapCode()) || StringUtils.isNotBlank((String)busiCondition.getSupCompanySapCode()) && busiCondition.getSupCompanySapCode().equals(orderItem.getSupCompanySapCode()))).findAny().orElse(null);
    }

    private PurOrder getPurOrder(List<PurOrder> orderList, String purOrderId) {
        return orderList.stream().filter(order -> order.getId().equals(purOrderId)).findAny().orElse(null);
    }

    private List<IOrderItem> getInvalidItem(List<IOrderItem> orderItemList) {
        ArrayList<IOrderItem> failOrderItemList = new ArrayList<IOrderItem>();
        for (IOrderItem orderItem : orderItemList) {
            Assert.isNotBlank((String)orderItem.getId(), (String)"\u8be2\u4ef7\u5355\u884cid\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)orderItem.getPurOrderId(), (String)"\u8be2\u4ef7\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)orderItem.getSupCompanyId(), (String)"\u8be2\u4ef7\u5355\u884c\uff0c\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)orderItem.getTemplateId(), (String)"\u8be2\u4ef7\u5355\u884c\uff0c\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
            ArrayList<String> reason = new ArrayList<String>();
            if (StringUtils.isBlank((String)orderItem.getMaterialDesc())) {
                reason.add("\u7269\u6599\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)orderItem.getMaterialCode())) {
                reason.add("\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (orderItem.getUntaxedUnitPrice() == null) {
                reason.add("\u4e0d\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)orderItem.getMeasurementUnit())) {
                reason.add("\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (orderItem.getValuationUnit() == null) {
                reason.add("\u8ba1\u4ef7\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!OperationTypeEnum.ACCEPTED.getCode().equals(orderItem.getOperation())) {
                throw new CommonException("\u8be5\u5355\u636e\u672a\u63a5\u53d7,\u65e0\u6cd5\u5bfc\u5165");
            }
            if (!CollectionUtils.isNotEmpty(reason)) continue;
            orderItem.setFailReason(StringUtils.join(reason, (String)","));
            failOrderItemList.add(orderItem);
        }
        return failOrderItemList;
    }

    private List<IOrderItem> writeToSapAndReturnFailList(List<IOrderItem> orderItemList, List<PurOrder> orderList, List<InformationRecord> inforList) {
        if (CollectionUtils.isEmpty(orderItemList)) {
            return null;
        }
        ArrayList<IOrderItem> failOrderItemList = new ArrayList<IOrderItem>();
        for (IOrderItem orderItem : orderItemList) {
            PurOrder purOrder = this.getPurOrder(orderList, orderItem.getPurOrderId());
            InquiryBusiCondition busiCondition = this.getBusiCondition(purOrder.getBusiConditions(), orderItem);
            TemplateConf templateConf = this.getTemplateConf(orderItem.getTemplateId());
            InformationRecord infor = this.getInformationRecord(inforList, orderItem.getPurOrderId());
            SystemPrice sys = this.buildSystemPrice(orderItem, busiCondition, infor);
            try {
                this.syncPriceService.sendData(sys);
                this.invoker.getSystemPriceService().addObj(sys);
                orderItem.setIsImportSap(Constant.YES_INT);
                templateConf.getOrderItemService().modifyStatus(orderItem);
            }
            catch (Exception e) {
                this.logger.error("\u4f9b\u5e94\u5546\u62a5\u4ef7\u4fe1\u606f\u53cd\u5199SAP\u63a5\u53e3\u8c03\u7528\u5f02\u5e38:", (Throwable)e);
                orderItem.setFailReason(String.format("SAP\u63a5\u53e3\u5f02\u5e38\uff0c\u91c7\u8d2d\u4fe1\u606f\u8bb0\u5f55\u56de\u5199\u5931\u8d25:%s", e.getMessage()));
                failOrderItemList.add(orderItem);
            }
        }
        return failOrderItemList;
    }

    private SystemPrice buildSystemPrice(IOrderItem iOrderItem, InquiryBusiCondition busiCondition, InformationRecord infor) {
        OrderItemM001 orderItem = (OrderItemM001)iOrderItem;
        SystemPrice sys = new SystemPrice();
        sys.setInformationRecordCategory(infor.getInformationRecordCategory());
        sys.setFactoryCode(infor.getFactoryCode());
        sys.setPurchaseOrganization(infor.getPurchaseOrganization());
        sys.setPurchasingGroup(infor.getPurchasingGroup());
        sys.setConditionalType(infor.getConditionalType());
        sys.setOrderItemId(orderItem.getId());
        sys.setCreateTime(new Date());
        sys.setUpdateTime(new Date());
        sys.setIsEnable(Constant.YES_INT);
        sys.setUntaxedUnitPrice(orderItem.getUntaxedUnitPrice());
        sys.setSaleTaxCode(StringUtils.defaultIfBlank((String)orderItem.getSaleTaxCode(), (String)busiCondition.getTaxRate()));
        sys.setMoq(orderItem.getMoq());
        sys.setQuoteType(orderItem.getQuoteType());
        sys.setInquiryQuoteLadders(orderItem.getInquiryQuoteLadders());
        sys.setCompanySapCode(orderItem.getSupCompanySapCode());
        if (StringUtils.isNotBlank((String)orderItem.getMeasurementUnit())) {
            sys.setPurPriceUnit(orderItem.getMeasurementUnit());
        }
        if (orderItem.getValuationUnit() != null) {
            sys.setPriceUnit(orderItem.getValuationUnit());
        }
        sys.setMaterialCode(orderItem.getMaterialCode());
        sys.setSupMaterialGroup(orderItem.getSupMaterialGroup());
        sys.setSupMaterialCode(orderItem.getOriginalModelOrName());
        if (orderItem.getPriceValidTime() != null) {
            sys.setPriceEffectiveStartTime(DateUtils.truncate((Date)orderItem.getPriceValidTime(), (int)5));
        } else {
            sys.setPriceEffectiveStartTime(DateUtils.truncate((Date)new Date(), (int)5));
        }
        if (orderItem.getPriceExpiredTime() != null) {
            Date expiredTime = DateUtils.truncate((Date)orderItem.getPriceExpiredTime(), (int)5);
            expiredTime = DateUtils.addDays((Date)expiredTime, (int)1);
            expiredTime = DateUtils.addSeconds((Date)expiredTime, (int)-1);
            sys.setPriceEffectiveEndTime(expiredTime);
        }
        if (busiCondition != null) {
            sys.setCountry(busiCondition.getCountry());
            sys.setRegion(busiCondition.getRegion());
            sys.setCurrency(busiCondition.getCurrency());
        }
        if (InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(orderItem.getQuoteType())) {
            List<InquiryQuoteLadder> ladder = this.invoker.getInquiryQuoteLadderService().queryByOrderItemId(orderItem.getId());
            sys.setInquiryQuoteLadders(ladder);
        }
        return sys;
    }

    private TemplateConf getTemplateConf(String templateId) {
        return this.getTemplateConfList().stream().filter(conf -> conf.getId().equals(templateId)).findAny().orElse(null);
    }

    private List<TemplateConf> getTemplateConfList() {
        if (CollectionUtils.isNotEmpty(this.templateConfList)) {
            return this.templateConfList;
        }
        this.templateConfList = this.getOrderList().parallelStream().map(order -> (TemplateConf)this.invoker.getTemplateConfService().queryObjById(order.getTemplateId())).collect(Collectors.toList());
        return this.templateConfList;
    }
}

