/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.IOrderItemDetailService;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquiryBusiConditionExample;
import com.els.base.inquiry.entity.InquiryQuoteLadder;
import com.els.base.inquiry.entity.MaterielParityExample;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryQuoteLadderType;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class ViewDetailCommand
extends AbstractInquiryCommand<PurOrder> {
    private String purOrderId;
    private TemplateConf templateConf;

    public ViewDetailCommand(String purOrderId) {
        Assert.isNotBlank((String)purOrderId, (String)"\u8be2\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.purOrderId = purOrderId;
    }

    @Override
    public PurOrder execute(InquiryCommandInvoker invoker) {
        PurOrder order = (PurOrder)invoker.getPurOrderService().queryObjById(this.purOrderId);
        this.templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(order.getTemplateId());
        order.setTemplateConf(this.templateConf);
        order.setTargetList(this.getTargetList(this.purOrderId));
        order.setPurFileList(invoker.getInquiryPurFileService().queryByPurOrderId(this.purOrderId));
        order.setInquirySuppliers(invoker.getInquirySupplierService().queryByPurOrderId(this.purOrderId));
        order.setItemList(this.getItemList(this.purOrderId));
        order.setBusiConditions(this.getBusiConditionsByPupOrderId(this.purOrderId));
        return order;
    }

    private List<ITarget> getTargetList(String purOrderId) {
        List<ITarget> targetList = this.templateConf.getTargetService().queryByPurOrderId(purOrderId);
        targetList.parallelStream().filter(target -> InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(target.getQuoteType())).forEach(target -> {
            List<InquiryQuoteLadder> ladderPrice = this.invoker.getInquiryQuoteLadderService().queryByTargetId(target.getId());
            target.setInquiryQuoteLadders(ladderPrice);
        });
        if (Constant.YES_INT.equals(this.templateConf.getIsOrderItemDetailEnable()) && CollectionUtils.isNotEmpty(targetList)) {
            this.setOrderDetailTOTarget(targetList);
        }
        return targetList;
    }

    private void setOrderDetailTOTarget(List<ITarget> targetList) {
        if (CollectionUtils.isEmpty(targetList)) {
            return;
        }
        targetList.parallelStream().forEach(item -> {
            IOrderItemDetailService orderItemService = this.templateConf.getTplOrderItemDetail().getOrderItemDetailService();
            item.setOrderItemDetail(orderItemService.queryObjByOrderItemId(item.getId()));
        });
    }

    private List<IOrderItem> getItemList(String purOrderId) {
        List<IOrderItem> itemList = this.templateConf.getOrderItemService().queryPublishedItemByPurOrderId(purOrderId);
        if (CollectionUtils.isEmpty(itemList)) {
            return null;
        }
        itemList.parallelStream().forEach(item -> {
            if (InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(item.getQuoteType())) {
                item.setInquiryQuoteLadders(this.invoker.getInquiryQuoteLadderService().queryByOrderItemId(item.getId()));
            }
        });
        if (Constant.YES_INT.equals(this.templateConf.getIsOrderItemDetailEnable()) && CollectionUtils.isNotEmpty(itemList)) {
            this.setOrderDetail(itemList);
        }
        for (IOrderItem orderItemM001 : itemList) {
            MaterielParityExample example3 = new MaterielParityExample();
            example3.createCriteria().andOrderItemIdEqualTo(orderItemM001.getId());
            orderItemM001.setMaterielParitys(this.invoker.getMaterielParityService().queryAllObjByExample((IExample)example3));
        }
        return itemList;
    }

    private void setOrderDetail(List<IOrderItem> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        itemList.parallelStream().forEach(item -> {
            IOrderItemDetailService orderItemService = this.templateConf.getTplOrderItemDetail().getOrderItemDetailService();
            item.setOrderItemDetail(orderItemService.queryObjByOrderItemId(item.getId()));
        });
    }

    private List<InquiryBusiCondition> getBusiConditionsByPupOrderId(String pupOrderId) {
        InquiryBusiConditionExample example = new InquiryBusiConditionExample();
        example.createCriteria().andPurOrderIdEqualTo(pupOrderId);
        List busiList = this.invoker.getInquiryBusiConditionService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)busiList)) {
            return null;
        }
        return busiList;
    }
}

