/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.IOrderItemDetailService;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquiryBusiConditionExample;
import com.els.base.inquiry.entity.InquiryQuoteLadder;
import com.els.base.inquiry.entity.InquirySupFile;
import com.els.base.inquiry.entity.InquirySupFileExample;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.InquirySupOrderExample;
import com.els.base.inquiry.entity.MaterielParityExample;
import com.els.base.inquiry.entity.OrderItemM001;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryAuditStatus;
import com.els.base.inquiry.enumclass.InquiryQuoteLadderType;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.enumclass.OperationTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class ViewPricingDetailCommand
extends AbstractInquiryCommand<PurOrder> {
    private String purOrderId;
    private TemplateConf templateConf;

    public ViewPricingDetailCommand(String purOrderId) {
        Assert.isNotBlank((String)purOrderId, (String)"\u8be2\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.purOrderId = purOrderId;
    }

    @Override
    public PurOrder execute(InquiryCommandInvoker invoker) {
        PurOrder order = (PurOrder)invoker.getPurOrderService().queryObjById(this.purOrderId);
        this.templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(order.getTemplateId());
        order.setTemplateConf(this.templateConf);
        order.setTargetList(this.getTargetList(this.purOrderId));
        order.setPurFileList(invoker.getInquiryPurFileService().queryByPurOrderId(this.purOrderId));
        order.setInquirySuppliers(invoker.getInquirySupplierService().queryByPurOrderId(this.purOrderId));
        List<String> supOrderIdList = this.getAvailabelSupOrderIds(this.purOrderId);
        order.setItemList(this.getItemList(this.purOrderId));
        order.setSupFileList(this.getSupFilesByPurOrderId(this.purOrderId, supOrderIdList));
        order.setBusiConditions(this.getBusiConditionsByPupOrderId(this.purOrderId, supOrderIdList));
        return order;
    }

    private List<String> getAvailabelSupOrderIds(String purOrderId) {
        InquirySupOrderExample example = new InquirySupOrderExample();
        example.createCriteria().andPurOrderIdEqualTo(purOrderId).andQuoteStatusNotEqualTo(InquiryQuoteStatus.UNQUOTED.getCode());
        List supOrderList = this.invoker.getInquirySupOrderService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)supOrderList)) {
            return null;
        }
        return supOrderList.stream().map(InquirySupOrder::getId).collect(Collectors.toList());
    }

    private List<ITarget> getTargetList(String purOrderId) {
        List<ITarget> targetList = this.templateConf.getTargetService().queryByPurOrderId(purOrderId);
        targetList.parallelStream().filter(target -> InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(target.getQuoteType())).forEach(target -> {
            List<InquiryQuoteLadder> ladderPrice = this.invoker.getInquiryQuoteLadderService().queryByTargetId(target.getId());
            target.setInquiryQuoteLadders(ladderPrice);
        });
        return targetList;
    }

    private List<IOrderItem> getItemList(String purOrderId) {
        List<OrderItemM001> itemList = this.templateConf.getOrderItemService().queryPublishedItemByPurOrderId(purOrderId);
        if (CollectionUtils.isEmpty(itemList)) {
            return null;
        }
        List<Object> tempItemList = new ArrayList();
        PurOrder purOrder = (PurOrder)this.invoker.getPurOrderService().queryObjById(purOrderId);
        tempItemList = InquiryAuditStatus.AUDITING.getCode().equals(purOrder.getAuditStatus()) || InquiryAuditStatus.AUDIT_PASS.getCode().equals(purOrder.getAuditStatus()) ? itemList.stream().filter(item -> OperationTypeEnum.REFUSED.getCode().equals(item.getOperation()) || OperationTypeEnum.ACCEPTED.getCode().equals(item.getOperation())).collect(Collectors.toList()) : itemList;
        if (CollectionUtils.isEmpty(tempItemList)) {
            return null;
        }
        tempItemList.parallelStream().forEach(item -> {
            if (InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(item.getQuoteType())) {
                item.setInquiryQuoteLadders(this.invoker.getInquiryQuoteLadderService().queryByOrderItemId(item.getId()));
            }
        });
        if (Constant.YES_INT.equals(this.templateConf.getIsOrderItemDetailEnable()) && CollectionUtils.isNotEmpty(tempItemList)) {
            this.setOrderDetail(tempItemList);
        }
        for (IOrderItem iOrderItem : tempItemList) {
            MaterielParityExample example3 = new MaterielParityExample();
            example3.createCriteria().andOrderItemIdEqualTo(iOrderItem.getId());
            iOrderItem.setMaterielParitys(this.invoker.getMaterielParityService().queryAllObjByExample((IExample)example3));
        }
        return tempItemList;
    }

    private void setOrderDetail(List<IOrderItem> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        itemList.parallelStream().forEach(item -> {
            IOrderItemDetailService orderItemService = this.templateConf.getTplOrderItemDetail().getOrderItemDetailService();
            item.setOrderItemDetail(orderItemService.queryObjByOrderItemId(item.getId()));
        });
    }

    private List<InquiryBusiCondition> getBusiConditionsByPupOrderId(String pupOrderId, List<String> supOrderIdList) {
        InquiryBusiConditionExample example = new InquiryBusiConditionExample();
        example.createCriteria().andPurOrderIdEqualTo(pupOrderId);
        List busiList = this.invoker.getInquiryBusiConditionService().queryAllObjByExample((IExample)example);
        return busiList;
    }

    private List<InquirySupFile> getSupFilesByPurOrderId(String purOrderId, List<String> supOrderIdList) {
        List fileList;
        PurOrder purOrder = (PurOrder)this.invoker.getPurOrderService().queryObjById(purOrderId);
        InquirySupFileExample example = new InquirySupFileExample();
        InquirySupFileExample.Criteria criteria = example.createCriteria().andPurOrderIdEqualTo(purOrder.getId());
        if (InquiryAuditStatus.AUDIT_PASS.getCode().equals(purOrder.getAuditStatus()) || InquiryAuditStatus.AUDITING.getCode().equals(purOrder.getAuditStatus())) {
            List<IOrderItem> itemList = this.templateConf.getOrderItemService().queryByPurOrderId(purOrderId);
            List auditSupCompanyIdList = itemList.stream().filter(item -> OperationTypeEnum.ACCEPTED.getCode().equals(item.getOperation())).map(item -> item.getSupCompanyId()).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(auditSupCompanyIdList)) {
                return null;
            }
            criteria.andSupCompanyIdIn(auditSupCompanyIdList);
        }
        if (CollectionUtils.isEmpty((Collection)(fileList = this.invoker.getInquirySupFileService().queryAllObjByExample((IExample)example))) || CollectionUtils.isEmpty(supOrderIdList)) {
            return null;
        }
        return fileList.stream().filter(file -> supOrderIdList.contains(file.getSupOrderId())).collect(Collectors.toList());
    }
}

