/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.sup;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.sup.DeleteSupOrderCommand;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryFileType;
import com.els.base.utils.uuid.UUIDGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class CreateCommand
extends AbstractInquiryCommand<String> {
    private InquirySupOrder supOrder;
    private TemplateConf templateConf;

    public CreateCommand(InquirySupOrder supOrder) {
        this.supOrder = supOrder;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        this.valid(this.supOrder);
        if (StringUtils.isNotBlank((String)this.supOrder.getId())) {
            DeleteSupOrderCommand deleteSupOrderCommand = new DeleteSupOrderCommand(this.supOrder);
            deleteSupOrderCommand.copyProperties(this);
            invoker.invoke(deleteSupOrderCommand);
        }
        this.templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(this.supOrder.getTemplateId());
        this.saveSupOrder(this.supOrder);
        this.saveBusinessCondition(this.supOrder);
        this.saveOrderItem(this.supOrder);
        this.saveSupFile(this.supOrder);
        return null;
    }

    private void saveSupFile(InquirySupOrder supOrder) {
        if (CollectionUtils.isEmpty(supOrder.getSupFileList())) {
            return;
        }
        supOrder.getSupFileList().forEach(inquirySupFile -> {
            inquirySupFile.setId(UUIDGenerator.generateUUID());
            inquirySupFile.setType(InquiryFileType.PUBLIC.getCode());
            inquirySupFile.setSupOrderId(supOrder.getId());
            inquirySupFile.setPurOrderId(supOrder.getPurOrderId());
            inquirySupFile.setSupCompanyId(this.getSupCompany().getId());
            inquirySupFile.setSupCompanyName(this.getSupCompany().getCompanyName());
            inquirySupFile.setSupUserId(this.getSupUser().getId());
            inquirySupFile.setSupUserName(this.getSupUser().getLoginName());
            this.invoker.getInquirySupFileService().addObj((Serializable)inquirySupFile);
        });
    }

    private void saveBusinessCondition(InquirySupOrder supOrder) {
        List<InquiryBusiCondition> busiConditions = supOrder.getBusiConditions();
        for (InquiryBusiCondition inquiryBusiCondition : busiConditions) {
            inquiryBusiCondition.setSupOrderId(supOrder.getId());
            inquiryBusiCondition.setTemplateConfId(supOrder.getTemplateId());
            inquiryBusiCondition.setSupUserId(this.getSupUser().getId());
            inquiryBusiCondition.setSupUserName(this.getSupUser().getNickName());
            inquiryBusiCondition.setSupCompanyId(this.getSupCompany().getId());
        }
        this.invoker.getInquiryBusiConditionService().addAll(busiConditions);
    }

    private void saveSupOrder(InquirySupOrder inquirySupOrder) {
        inquirySupOrder.setSupCompanyName(this.getSupCompany().getCompanyName());
        inquirySupOrder.setSupCompanySrmCode(this.getSupCompany().getCompanyCode());
        inquirySupOrder.setSupCompanyId(this.getSupCompany().getId());
        inquirySupOrder.setSupCompanySapCode(this.getSupCompany().getCompanySapCode());
        this.invoker.getInquirySupOrderService().addObj(inquirySupOrder);
    }

    private void valid(InquirySupOrder supOrder) {
        Assert.isNotNull((Object)supOrder, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)supOrder.getOrderNo(), (String)"\u8be2\u4ef7\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)supOrder.getTemplateId(), (String)"\u8be2\u4ef7\u5355\u6a21\u677fId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)supOrder.getType(), (String)"\u8be2\u4ef7\u5355\u6a21\u677f\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(supOrder.getBusiConditions(), (String)"\u5546\u52a1\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<String> materialDesList = new ArrayList<String>();
        for (int i = 0; i < supOrder.getItemList().size(); ++i) {
            IOrderItem item = supOrder.getItemList().get(i);
            Assert.isNotBlank((String)item.getMaterialDesc(), (String)String.format("\u7b2c %s \u884c\uff0c\u7269\u6599\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a", i + 1));
            if (materialDesList.contains(item.getMaterialDesc())) {
                throw new CommonException(String.format("\u8be2\u4ef7\u5355\u4e2d\u51fa\u73b0\u91cd\u590d\u7269\u6599\uff0c\u8bf7\u52ff\u91cd\u590d\u8be2\u4ef7\u3002\u7269\u6599: [%s]", item.getMaterialDesc()));
            }
            materialDesList.add(item.getMaterialDesc());
        }
    }

    private void saveOrderItem(InquirySupOrder supOrder) {
        if (CollectionUtils.isEmpty(supOrder.getItemList())) {
            return;
        }
        for (int i = 0; i < supOrder.getItemList().size(); ++i) {
            IOrderItem orderItem = supOrder.getItemList().get(i);
            orderItem.setSupOrderId(supOrder.getId());
            orderItem.setOrderItemNo(i + 1);
            orderItem.setOrderNo(supOrder.getOrderNo());
            orderItem.setSupCompanySapCode(supOrder.getSupCompanySapCode());
        }
        this.templateConf.getOrderItemService().addAll(supOrder.getItemList());
        if (!Constant.YES_INT.equals(this.templateConf.getIsOrderItemDetailEnable())) {
            return;
        }
        List detailList = supOrder.getItemList().stream().map(item -> {
            IOrderItemDetail detail = item.getOrderItemDetail();
            detail.setOrderItemId(item.getId());
            detail.setTemplateId(this.templateConf.getId());
            return detail;
        }).collect(Collectors.toList());
        this.templateConf.getTplOrderItemDetail().getOrderItemDetailService().addAll(detailList);
    }
}

