/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.sup;

import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquiryBusiConditionExample;
import com.els.base.inquiry.entity.InquirySupFileExample;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.TemplateConf;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class DeleteSupOrderCommand
extends AbstractInquiryCommand<String> {
    private InquirySupOrder supOrder;
    private TemplateConf templateConf;

    public DeleteSupOrderCommand(InquirySupOrder supOrder) {
        this.supOrder = supOrder;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        this.valid(this.supOrder);
        this.supOrder = (InquirySupOrder)invoker.getInquirySupOrderService().queryObjById(this.supOrder.getId());
        this.templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(this.supOrder.getTemplateId());
        this.deleleteSupFile(this.supOrder);
        this.deleteOrderItem(this.supOrder);
        this.deleteBusinessCondition(this.supOrder);
        this.deleteSupOrder(this.supOrder);
        return null;
    }

    private void deleteSupOrder(InquirySupOrder supOrder) {
        this.invoker.getInquirySupOrderService().deleteObjById(supOrder.getId());
    }

    private void deleteBusinessCondition(InquirySupOrder supOrder) {
        InquiryBusiConditionExample busiConditionExample = new InquiryBusiConditionExample();
        busiConditionExample.createCriteria().andSupOrderIdEqualTo(supOrder.getId());
        this.invoker.getInquiryBusiConditionService().deleteByExample(busiConditionExample);
    }

    private void deleteOrderItem(InquirySupOrder supOrder) {
        List itemList = this.templateConf.getOrderItemService().queryBySupOrderId(supOrder.getId());
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        this.templateConf.getOrderItemService().deleteBySupOrderId(supOrder.getId());
        if (!Constant.YES_INT.equals(this.templateConf.getIsOrderItemDetailEnable())) {
            return;
        }
        List<String> orderItemIdList = itemList.stream().map(IOrderItem::getId).collect(Collectors.toList());
        this.templateConf.getTplOrderItemDetail().getOrderItemDetailService().deleteByOrderItemIds(orderItemIdList);
    }

    private void deleleteSupFile(InquirySupOrder supOrder) {
        InquirySupFileExample example = new InquirySupFileExample();
        example.createCriteria().andSupOrderIdEqualTo(supOrder.getId());
        this.invoker.getInquirySupFileService().deleteByExample(example);
    }

    private void valid(InquirySupOrder supOrder) {
        Assert.isNotNull((Object)supOrder, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)supOrder.getId(), (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

