/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.sup;

import com.els.base.company.entity.Company;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.dictonary.DicUtils;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.PropertyValue;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.utils.PropertyValueUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class PreviewCommand
extends AbstractInquiryCommand<InquirySupOrder> {
    private static final String ORDER_NO_GENERATE_CODE = "INQUIRY_ORDER_CODE";
    private String templateId;

    public PreviewCommand(String templateId) {
        Assert.isNotBlank((String)templateId, (String)"\u6a21\u677f\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        this.templateId = templateId;
    }

    @Override
    public InquirySupOrder execute(InquiryCommandInvoker invoker) {
        Company supCompany = this.getSupCompany();
        Assert.isNotBlank((String)this.templateId, (String)"\u4f9b\u5e94\u5546\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        TemplateConf templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(this.templateId);
        this.vaild(templateConf);
        InquirySupOrder supOrder = this.generateInquirySupOrder(templateConf, supCompany);
        InquiryBusiCondition busiCondition = this.generateBusiCondition(templateConf, supCompany);
        supOrder.setBusiConditions(Arrays.asList(busiCondition));
        supOrder.setTemplateConf(templateConf);
        return supOrder;
    }

    private InquiryBusiCondition generateBusiCondition(TemplateConf templateConf, Company supCompany) {
        InquiryBusiCondition inquiryBusiCondition = new InquiryBusiCondition();
        inquiryBusiCondition.setSupCompanyId(supCompany.getId());
        inquiryBusiCondition.setSupCompanyName(supCompany.getCompanyName());
        inquiryBusiCondition.setSupCompanySrmCode(supCompany.getCompanyCode());
        inquiryBusiCondition.setSupCompanySapCode(supCompany.getCompanySapCode());
        inquiryBusiCondition.setCountry(this.getCountry(supCompany.getCountry()));
        inquiryBusiCondition.setRegion(this.getRegion(supCompany.getProvince()));
        inquiryBusiCondition.setCurrency(this.getSupCompany().getOrderCurren());
        inquiryBusiCondition.setTaxRate(this.getSupCompany().getTax());
        inquiryBusiCondition.setTaxType(this.getSupCompany().getTaxType());
        inquiryBusiCondition.setPayTerms(this.getSupCompany().getPayConditionsCode());
        inquiryBusiCondition.setTemplateConfId(templateConf.getId());
        List<PropertyValue> defaultValueList = PropertyValueUtils.getDefaultPropertyValue(inquiryBusiCondition);
        List<PropertyValue> existValueList = inquiryBusiCondition.getPropertyValueList();
        this.addDefaultValue(existValueList, defaultValueList);
        return inquiryBusiCondition;
    }

    private InquirySupOrder generateInquirySupOrder(TemplateConf templateConf, Company inquirySupplier) {
        InquirySupOrder inquirySupOrder = new InquirySupOrder();
        inquirySupOrder.setSupCompanyName(inquirySupplier.getCompanyName());
        inquirySupOrder.setSupCompanySrmCode(inquirySupplier.getCompanyCode());
        inquirySupOrder.setSupCompanyId(inquirySupplier.getId());
        inquirySupOrder.setSupCompanySapCode(inquirySupplier.getCompanySapCode());
        inquirySupOrder.setType(templateConf.getName());
        inquirySupOrder.setTemplateId(templateConf.getId());
        inquirySupOrder.setOrderNo(this.invoker.getGenerateCodeService().getNextCode(ORDER_NO_GENERATE_CODE));
        inquirySupOrder.setCreateDate(new Date());
        inquirySupOrder.setPublishDate(new Date());
        inquirySupOrder.setInquiryOrderStatus(InquiryOrderStatus.PUBLISHED.getCode());
        inquirySupOrder.setQuoteStatus(InquiryQuoteStatus.UNQUOTED.getCode());
        inquirySupOrder.setTemplateId(templateConf.getId());
        return inquirySupOrder;
    }

    private void vaild(TemplateConf templateConf) {
        Assert.isNotNull((Object)templateConf, (String)"\u6a21\u677f\u914d\u7f6e\u4e0d\u5b58\u5728");
        if (Constant.YES_INT.equals(templateConf.getIsMouldEnable())) {
            Assert.isNotEmpty(templateConf.getMouldPropertyDefList(), (String)"\u6a21\u677f\u914d\u7f6e\u5f02\u5e38\uff0c\u6a21\u5177\u6e05\u5355\u7684\u5b57\u6bb5\u914d\u7f6e\u4e3a\u7a7a");
        }
        if (Constant.YES_INT.equals(templateConf.getIsBusiCondEnable())) {
            Assert.isNotEmpty(templateConf.getBusiConditionPropertyDefList(), (String)"\u6a21\u677f\u914d\u7f6e\u5f02\u5e38\uff0c\u5546\u52a1\u6761\u4ef6\u7684\u5b57\u6bb5\u914d\u7f6e\u4e3a\u7a7a");
        }
    }

    private void addDefaultValue(List<PropertyValue> existValueList, List<PropertyValue> defaultValueList) {
        for (PropertyValue defaultValue : defaultValueList) {
            PropertyValue existObject = existValueList.stream().filter(existValue -> defaultValue.getCode().equals(existValue.getCode())).findAny().orElse(null);
            if (existObject == null) {
                existValueList.add(defaultValue);
                continue;
            }
            if (!StringUtils.isBlank((String)existObject.getValueStr()) || !StringUtils.isNotBlank((String)defaultValue.getValueStr())) continue;
            existObject.setValueStr(defaultValue.getValueStr());
        }
    }

    private String getRegion(String province) {
        if (StringUtils.isBlank((String)province)) {
            return null;
        }
        if (province.matches("\\d+")) {
            return province;
        }
        DicGroupItem dicItem = DicUtils.getDicGroupItemByValue((String)"area_code", (String)province);
        if (dicItem == null) {
            return null;
        }
        return dicItem.getCode();
    }

    private String getCountry(String country) {
        if (StringUtils.isBlank((String)country)) {
            return null;
        }
        if (country.matches("[A-W]+")) {
            return country;
        }
        DicGroupItem dicItem = DicUtils.getDicGroupItemByValue((String)"country_code", (String)country);
        if (dicItem == null) {
            return null;
        }
        return dicItem.getCode();
    }
}

