/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.sup;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.material.entity.Material;
import java.util.List;
import java.util.stream.Collectors;

public class PreviewOrderItemCommand
extends AbstractInquiryCommand<List<IOrderItem>> {
    private String templateId;
    private List<Material> materialList;

    public PreviewOrderItemCommand(String templateId, List<Material> materialList) {
        this.templateId = templateId;
        this.materialList = materialList;
    }

    @Override
    public List<IOrderItem> execute(InquiryCommandInvoker invoker) {
        Assert.isNotBlank((String)this.templateId, (String)"\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(this.materialList, (String)"\u7269\u6599\u4e0d\u80fd\u4e3a\u7a7a");
        TemplateConf templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(this.templateId);
        Class<? extends ITarget> clazz = templateConf.getTargetClass();
        List<IOrderItem> itemList = this.materialList.stream().map(material -> {
            ITarget target = null;
            try {
                target = (ITarget)clazz.newInstance();
                target.buildFromMaterial(this.templateId, (Material)material);
                return target;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new CommonException(String.format("\u8f6c\u6210\u8be2\u4ef7\u5355\u7269\u6599\u51fa\u9519,\u4e0d\u5b58\u5728\u7c7b[%s]", templateConf.getTargetClassName()), (Throwable)e);
            }
        }).map(target -> {
            Class<? extends IOrderItem> orderItemCls = templateConf.getOrderItemClass();
            IOrderItem orderItem = null;
            try {
                orderItem = orderItemCls.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            orderItem.build(null, null, (ITarget)target);
            if (!Constant.YES_INT.equals(templateConf.getIsOrderItemDetailEnable())) {
                return orderItem;
            }
            IOrderItemDetail detail = null;
            try {
                detail = templateConf.getTplOrderItemDetail().getOrderItemDetailClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            detail.build(orderItem);
            detail.setTemplateId(templateConf.getTplOrderItemDetail().getId());
            orderItem.setOrderItemDetail(detail);
            return orderItem;
        }).collect(Collectors.toList());
        return itemList;
    }
}

