/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.sup;

import com.els.base.company.entity.Company;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.sup.CreateCommand;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquiryQuoteLadder;
import com.els.base.inquiry.entity.InquirySupFile;
import com.els.base.inquiry.entity.InquirySupFileExample;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.InquirySupplier;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryAuditStatus;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import com.els.base.inquiry.enumclass.InquiryQuoteLadderType;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.enumclass.MessageNotify;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

public class PublishSupOrderCommand
extends AbstractInquiryCommand<String> {
    private InquirySupOrder preSupOrder;
    private InquirySupOrder supOrder;
    private TemplateConf templateConf;

    public PublishSupOrderCommand(InquirySupOrder supOrder) {
        this.supOrder = supOrder;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        CreateCommand command = new CreateCommand(this.supOrder);
        command.copyProperties(this);
        invoker.invoke(command);
        Assert.isNotNull((Object)this.supOrder, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.supOrder.getTemplateId(), (String)"\u8be2\u4ef7\u5355\u7684\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.supOrder.getId(), (String)"\u8be2\u4ef7\u5355\u7684id\u4e0d\u80fd\u4e3a\u7a7a");
        this.templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(this.supOrder.getTemplateId());
        this.preSupOrder = (InquirySupOrder)invoker.getInquirySupOrderService().queryObjById(this.supOrder.getId());
        this.valid(this.supOrder);
        this.publish(this.supOrder);
        this.sendMsg(this.supOrder);
        return null;
    }

    private void sendMsg(InquirySupOrder order) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("purOrderId", order.getPurOrderId());
        data.put("orderNo", order.getOrderNo());
        data.put("supCompanyName", order.getSupCompanyName());
        Message msg = Message.init(data).setCompanyCode(this.getSupCompany().getCompanyCode()).setBusinessTypeCode(MessageNotify.INQUIRY_ORDER_QUOTE.getCode()).setSenderId(this.getSupUser().getId()).addReceiverId(order.getPurUserId()).setMsgLevel(MessageLevelEnum.HIGH);
        MessageSendUtils.sendMessage((Message)msg);
    }

    private void publish(InquirySupOrder order) {
        PurOrder purOrder = this.generatePurOrder(order);
        this.invoker.getPurOrderService().addObj(purOrder);
        this.setPurOrderIntoSupOrder(purOrder, order);
        InquirySupplier supplier = this.setValueIntoSupplier(purOrder, order);
        List<ITarget> targetList = this.generateTarget(order, purOrder);
        this.templateConf.getTargetService().addAll(targetList);
        this.setValueIntoItem(purOrder, order, targetList, supplier);
        this.setValueIntoBusiConditions(purOrder, order);
        this.setValueIntoSupFileList(purOrder, order);
    }

    private void setValueIntoSupFileList(PurOrder purOrder, InquirySupOrder order) {
        if (CollectionUtils.isEmpty(order.getSupFileList())) {
            return;
        }
        InquirySupFileExample example = new InquirySupFileExample();
        example.createCriteria().andSupOrderIdEqualTo(order.getId());
        InquirySupFile supFile = new InquirySupFile();
        supFile.setPurOrderId(purOrder.getId());
        this.invoker.getInquirySupFileService().modifyByExample(supFile, example);
    }

    private void setValueIntoBusiConditions(PurOrder purOrder, InquirySupOrder order) {
        List<InquiryBusiCondition> busiConditionList = order.getBusiConditions();
        for (InquiryBusiCondition inquiryBusiCondition : busiConditionList) {
            inquiryBusiCondition.setPurOrderId(purOrder.getId());
            this.invoker.getInquiryBusiConditionService().modifyObjExPro(inquiryBusiCondition);
        }
    }

    private void setValueIntoItem(PurOrder purOrder, InquirySupOrder order, List<ITarget> targetList, InquirySupplier supplier) {
        for (IOrderItem item : order.getItemList()) {
            item.setPurOrderId(purOrder.getId());
            item.setTargetId(item.getId());
            item.setQuotationStatus(InquiryQuoteStatus.QUOTED.getCode());
            item.setSupTempCompanyId(supplier.getId());
            item.setSupCompanySapCode(order.getSupCompanySapCode());
            item.setSupCompanySrmCode(order.getSupCompanySrmCode());
            item.setSupCompanyName(order.getSupCompanyName());
            item.setSupUserId(order.getSupUserId());
            item.setSupUserName(order.getSupUserName());
            item.setQuoteTime(order.getQuoteTime());
            this.templateConf.getOrderItemService().modifyStatus(item);
        }
    }

    private InquirySupplier setValueIntoSupplier(PurOrder purOrder, InquirySupOrder order) {
        InquirySupplier supplier = new InquirySupplier();
        supplier.setPurOrderId(purOrder.getId());
        supplier.setSupCompanyId(order.getSupCompanyId());
        supplier.setSupCompanyName(order.getSupCompanyName());
        supplier.setSupCompanySapCode(order.getSupCompanySapCode());
        supplier.setSupCompanySrmCode(order.getSupCompanySrmCode());
        this.invoker.getInquirySupplierService().addObj(supplier);
        InquirySupOrder tmpSupOrder = new InquirySupOrder();
        tmpSupOrder.setId(order.getId());
        tmpSupOrder.setSupTempCompanyId(supplier.getId());
        this.invoker.getInquirySupOrderService().modifyObj(tmpSupOrder);
        return supplier;
    }

    private void setPurOrderIntoSupOrder(PurOrder purOrder, InquirySupOrder order) {
        Date now = new Date();
        order.setPurOrderId(purOrder.getId());
        order.setPurCompanyId(purOrder.getPurCompanyId());
        order.setPurCompanyName(purOrder.getPurCompanyName());
        order.setPurUserId(purOrder.getPurUserId());
        order.setPurUserName(purOrder.getPurUserName());
        order.setQuoteStatus(InquiryQuoteStatus.QUOTED.getCode());
        order.setInquiryOrderStatus(InquiryOrderStatus.PUBLISHED.getCode());
        order.setPublishDate(now);
        order.setQuoteTime(now);
        order.setSupUserId(this.getSupUser().getId());
        order.setSupUserName(this.getSupUser().getNickName());
        this.invoker.getInquirySupOrderService().modifyObj(order);
    }

    private List<ITarget> generateTarget(InquirySupOrder order, PurOrder purOrder) {
        ArrayList<ITarget> targetList = new ArrayList<ITarget>(order.getItemList().size());
        for (IOrderItem orderItem : order.getItemList()) {
            ITarget target;
            try {
                target = this.templateConf.getTargetClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            BeanUtils.copyProperties((Object)orderItem, (Object)target);
            target.setPurOrderId(purOrder.getId());
            targetList.add(target);
        }
        return targetList;
    }

    private PurOrder generatePurOrder(InquirySupOrder order) {
        PurOrder purOrder = new PurOrder();
        purOrder.setOrderNo(order.getOrderNo());
        purOrder.setType(order.getType());
        purOrder.setTemplateId(order.getTemplateId());
        purOrder.setDigestExplain(order.getDigestExplain());
        purOrder.setCreateDate(new Date());
        purOrder.setPublishDate(new Date());
        purOrder.setQuoteStartDate(order.getQuoteStartDate());
        purOrder.setQuoteEndDate(order.getQuoteEndDate());
        purOrder.setInquiryOrderStatus(InquiryOrderStatus.PUBLISHED.getCode());
        purOrder.setQuoteStatus(InquiryQuoteStatus.QUOTED.getCode());
        purOrder.setAuditStatus(InquiryAuditStatus.UNAUDITED.getCode());
        purOrder.setPurUserName(this.getSupUser().getNickName());
        Company purCompany = (Company)this.invoker.getCompanyService().queryObjById((Object)order.getPurCompanyId());
        purOrder.setPurCompanyId(purCompany.getId());
        purOrder.setPurCompanyName(purCompany.getCompanyName());
        User user = this.queryPurUser(order.getPurUserName(), purCompany.getId());
        if (user == null) {
            throw new CommonException(String.format("\u7cfb\u7edf\u4e0d\u5b58\u5728\u5e10\u53f7 %s", order.getPurUserName()));
        }
        purOrder.setPurUserId(user.getId());
        String tempMaterialCode = this.supOrder.getItemList().stream().map(IOrderItem::getMaterialCode).filter(StringUtils::isNotBlank).collect(Collectors.joining(","));
        purOrder.setMaterialCodeList(tempMaterialCode);
        String tempMaterialDesc = this.supOrder.getItemList().stream().map(IOrderItem::getMaterialDesc).filter(StringUtils::isNotBlank).collect(Collectors.joining(","));
        purOrder.setMaterialDescList(tempMaterialDesc);
        purOrder.setSupCompanyNameList(order.getSupCompanyName());
        return purOrder;
    }

    private User queryPurUser(String purUserName, String companyId) {
        List userList = this.invoker.getCompanyUserRefService().queryUserListOfCompany(companyId);
        if (CollectionUtils.isEmpty((Collection)userList)) {
            return null;
        }
        return userList.stream().filter(user -> purUserName.equals(user.getNickName())).findAny().orElse(null);
    }

    private void valid(InquirySupOrder supOrder) {
        Assert.isNotNull((Object)supOrder, (String)"\u8be2\u4ef7\u5355\u5934\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)supOrder.getPurCompanyId(), (String)"\u91c7\u8d2d\u65b9id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)supOrder.getOrderNo(), (String)"\u8be2\u4ef7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(supOrder.getItemList(), (String)"\u8be2\u4ef7\u5355\u7684\u62a5\u4ef7\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)supOrder.getPurUserName(), (String)"\u91c7\u8d2d\u65b9\u63a5\u6536\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(supOrder.getBusiConditions(), (String)"\u5546\u52a1\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        if (!InquiryQuoteStatus.UNQUOTED.getCode().equals(this.preSupOrder.getQuoteStatus()) && !InquiryQuoteStatus.REQUOTE.getCode().equals(this.preSupOrder.getQuoteStatus())) {
            throw new CommonException("\u53ea\u6709\u5904\u4e8e\u672a\u62a5\u4ef7\u6216\u91cd\u62a5\u4ef7\u72b6\u6001\u4e0b\u7684\u8be2\u4ef7\u5355\u624d\u5141\u8bb8\u53d1\u5e03\u62a5\u4ef7");
        }
        Assert.isNotBlank((String)supOrder.getPurUserName(), (String)"\u91c7\u8d2d\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        List<IOrderItem> orderItems = supOrder.getItemList();
        for (IOrderItem orderItem : orderItems) {
            Assert.isNotBlank((String)orderItem.getMaterialDesc(), (String)"\u7269\u6599\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
            if (Constant.YES_INT.equals(orderItem.getUnableToQuote())) {
                throw new CommonException("\u4e0d\u80fd\u9009\u62e9\u65e0\u6cd5\u62a5\u4ef7");
            }
            if (!InquiryQuoteLadderType.CONVENTIONAL_QUOTE.getCode().equals(orderItem.getQuoteType()) && !InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(orderItem.getQuoteType())) {
                throw new CommonException("\u62a5\u4ef7\u7c7b\u578b\u65e0\u6cd5\u8bc6\u522b");
            }
            if (InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(orderItem.getQuoteType()) && !CollectionUtils.isEmpty(orderItem.getInquiryQuoteLadders())) {
                this.validLadderPrice(orderItem);
            }
            if (InquiryQuoteLadderType.CONVENTIONAL_QUOTE.getCode().equals(orderItem.getQuoteType()) && (orderItem.getUntaxedUnitPrice() == null || BigDecimal.ZERO.compareTo(orderItem.getUntaxedUnitPrice()) == 0)) {
                throw new CommonException(String.format("\u8be2\u4ef7\u5355\u5c1a\u672a\u62a5\u4ef7\uff0c\u65e0\u6cd5\u53d1\u5e03\uff01\u8bf7\u68c0\u67e5\u7269\u6599[%s]\u3002", orderItem.getMaterialDesc()));
            }
            orderItem.isVaildForQuote();
        }
        if (Constant.YES_INT.equals(this.templateConf.getIsBusiCondEnable())) {
            Assert.isNotEmpty(supOrder.getBusiConditions(), (String)"\u5546\u52a1\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            supOrder.getBusiConditions().forEach(inquiryBusiCondition -> inquiryBusiCondition.isVaildForQuote());
        }
    }

    private void validLadderPrice(IOrderItem orderItem) {
        for (InquiryQuoteLadder ladderPrice : orderItem.getInquiryQuoteLadders()) {
            Assert.isNotNull((Object)ladderPrice.getUntaxedUnitPrice(), (String)"\u9636\u68af\u62a5\u4ef7\uff0c\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
            if (ladderPrice.getUntaxedUnitPrice().compareTo(BigDecimal.ZERO) > 0) continue;
            throw new CommonException(String.format("\u8be2\u4ef7\u5355\u5c1a\u672a\u62a5\u4ef7\u5b8c\u6210\uff0c\u65e0\u6cd5\u53d1\u5e03\uff01\u8bf7\u68c0\u67e5\u7269\u6599 [%s] \u7684\u9636\u68af\u4ef7", orderItem.getMaterialDesc()));
        }
    }
}

