/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.template;

import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.entity.TplOrderItemDetailExample;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import com.els.base.inquiry.utils.InquiryConstant;
import com.els.base.inquiry.utils.PropertyDefUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class CreateOrderItemDetailTplCmd
extends AbstractInquiryCommand<String> {
    private TplOrderItemDetail tplOrderItemDetail;

    public CreateOrderItemDetailTplCmd(TplOrderItemDetail tplOrderItemDetail) {
        this.tplOrderItemDetail = tplOrderItemDetail;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        this.valid(this.tplOrderItemDetail);
        if (!this.tplOrderItemDetail.getCode().matches("[\\w_-]+")) {
            throw new CommonException("\u7f16\u7801\u53ea\u80fd\u4f7f\u7528\u82f1\u6587\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3001\u6a2a\u7ebf");
        }
        if (this.tplOrderItemDetail.getCode().length() > 32) {
            throw new CommonException("\u7f16\u7801\u6700\u591a\u53ea\u652f\u630132\u4e2a\u5b57\u7b26");
        }
        if (StringUtils.isBlank((String)this.tplOrderItemDetail.getOrderDtlClassName())) {
            this.tplOrderItemDetail.setOrderDtlClassName(InquiryConstant.DEFALUT_ORDER_TIEM_DETAIL_CLS.getName());
        }
        if (StringUtils.isBlank((String)this.tplOrderItemDetail.getOrderDtlServiceName())) {
            this.tplOrderItemDetail.setOrderDtlServiceName(InquiryConstant.DEFALUT_ORDER_TIEM_DETAIL_SERVICE_CLS.getName());
        }
        this.tplOrderItemDetail.setIsHis(Constant.NO_INT);
        if (this.getPurUser() != null) {
            this.tplOrderItemDetail.setCreateUserId(this.getPurUser().getId());
            this.tplOrderItemDetail.setCreateUserName(this.getPurUser().getNickName());
        }
        if (this.tplOrderItemDetail.getCreateTime() == null) {
            this.tplOrderItemDetail.setCreateTime(new Date());
        }
        this.invoker.getTplOrderItemDetailService().addObj(this.tplOrderItemDetail);
        List<PropertyDef> propertyDefList = this.tplOrderItemDetail.getPropertyDefList();
        if (CollectionUtils.isEmpty(propertyDefList)) {
            return this.tplOrderItemDetail.getId();
        }
        propertyDefList.stream().forEach(propertyDef -> {
            propertyDef.setId(null);
            propertyDef.setTplId(this.tplOrderItemDetail.getId());
            propertyDef.setTplType(PropertyDefTplType.ORDER_DETAIL_TYPE.getCode());
        });
        this.getInvoker().getPropertyDefService().addAll(propertyDefList);
        return this.tplOrderItemDetail.getId();
    }

    private void valid(TplOrderItemDetail tplOrderItemDetail) {
        Assert.isNotBlank((String)tplOrderItemDetail.getCode(), (String)"\u7269\u6599\u6210\u672c\u6e05\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)tplOrderItemDetail.getName(), (String)"\u7269\u6599\u6210\u672c\u6e05\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(tplOrderItemDetail.getPropertyDefList(), (String)"\u5b57\u6bb5\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        PropertyDefUtils.valid(tplOrderItemDetail.getPropertyDefList());
        TplOrderItemDetailExample example = new TplOrderItemDetailExample();
        example.createCriteria().andCodeEqualTo(tplOrderItemDetail.getCode()).andIsHisEqualTo(Constant.NO_INT);
        List list = this.invoker.getTplOrderItemDetailService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new CommonException("\u8be5\u6a21\u677f\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        }
        example.clear();
        example.createCriteria().andNameEqualTo(tplOrderItemDetail.getName()).andIsHisEqualTo(Constant.NO_INT);
        list = this.invoker.getTplOrderItemDetailService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new CommonException("\u8be5\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        }
    }
}

