/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.template;

import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.entity.TemplateConfExample;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import com.els.base.inquiry.utils.InquiryConstant;
import com.els.base.inquiry.utils.PropertyDefUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class CreateTemplateConfCmd
extends AbstractInquiryCommand<String> {
    private TemplateConf templateConf;

    public CreateTemplateConfCmd(TemplateConf templateConf) {
        this.templateConf = templateConf;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        this.valid(this.templateConf);
        this.complete(this.templateConf);
        invoker.getTemplateConfService().addObj(this.templateConf);
        ArrayList<PropertyDef> propertyDefList = new ArrayList<PropertyDef>();
        this.templateConf.getOrderItemPropertyDefList().forEach(propertyDef -> {
            propertyDef.setId(null);
            propertyDef.setTplId(this.templateConf.getId());
            propertyDef.setTplType(PropertyDefTplType.ORDER_ITEM.getCode());
            propertyDefList.add((PropertyDef)propertyDef);
        });
        if (Constant.YES_INT.equals(this.templateConf.getIsMouldEnable())) {
            this.templateConf.getMouldPropertyDefList().forEach(propertyDef -> {
                propertyDef.setId(null);
                propertyDef.setTplId(this.templateConf.getId());
                propertyDef.setTplType(PropertyDefTplType.MOULD_TYPE.getCode());
                propertyDefList.add((PropertyDef)propertyDef);
            });
        }
        if (Constant.YES_INT.equals(this.templateConf.getIsBusiCondEnable())) {
            this.templateConf.getBusiConditionPropertyDefList().forEach(propertyDef -> {
                propertyDef.setId(null);
                propertyDef.setTplId(this.templateConf.getId());
                propertyDef.setTplType(PropertyDefTplType.BUSI_TYPE.getCode());
                propertyDefList.add((PropertyDef)propertyDef);
            });
        }
        invoker.getPropertyDefService().addAll(propertyDefList);
        return this.templateConf.getId();
    }

    private void complete(TemplateConf templateConf) {
        templateConf.setIsHis(Constant.NO_INT);
        if (templateConf.getCreateTime() == null) {
            templateConf.setCreateTime(new Date());
        }
        if (this.getPurUser() != null) {
            templateConf.setCreateUserId(this.getPurUser().getId());
            templateConf.setCreateUserName(this.getPurUser().getNickName());
        }
        if (StringUtils.isBlank((String)templateConf.getItemClassName())) {
            templateConf.setItemClassName(InquiryConstant.DEFALUT_ORDER_TIEM_CLS.getName());
        }
        if (StringUtils.isBlank((String)templateConf.getItemServiceClassName())) {
            templateConf.setItemServiceClassName(InquiryConstant.DEFALUT_ORDER_TIEM_SERVICE_CLS.getName());
        }
        if (StringUtils.isBlank((String)templateConf.getBusiCondClassName())) {
            templateConf.setBusiCondClassName(InquiryConstant.DEFALUT_BUSI_CONDITION_CLS.getName());
        }
        if (StringUtils.isBlank((String)templateConf.getBusiCondServiceClassName())) {
            templateConf.setBusiCondServiceClassName(InquiryConstant.DEFALUT_BUSI_CONDITION_SERVICE_CLS.getName());
        }
    }

    private void valid(TemplateConf templateConf) {
        Assert.isNotNull((Object)templateConf, (String)"\u6a21\u677f\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)templateConf.getCode(), (String)"\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)templateConf.getName(), (String)"\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)templateConf.getCategoryCode(), (String)"\u7269\u6599\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)templateConf.getCategoryName(), (String)"\u7269\u6599\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(templateConf.getOrderItemPropertyDefList(), (String)"\u7269\u6599\u6e05\u5355\u81ea\u5b9a\u4e49\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        if (!templateConf.getCode().matches("[\\w_-]+")) {
            throw new CommonException("\u6a21\u677f\u7f16\u7801\u53ea\u80fd\u4f7f\u7528\u82f1\u6587\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3001\u6a2a\u7ebf");
        }
        if (templateConf.getCode().length() > 32) {
            throw new CommonException("\u6a21\u677f\u7f16\u7801\u6700\u591a\u53ea\u652f\u630132\u4e2a\u5b57\u7b26");
        }
        if (Constant.YES_INT.equals(templateConf.getIsMouldEnable())) {
            Assert.isNotEmpty(templateConf.getMouldPropertyDefList(), (String)"\u6a21\u5177\u6e05\u5355\u81ea\u5b9a\u4e49\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Constant.YES_INT.equals(templateConf.getIsBusiCondEnable())) {
            Assert.isNotEmpty(templateConf.getBusiConditionPropertyDefList(), (String)"\u5546\u52a1\u6761\u4ef6\u81ea\u5b9a\u4e49\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Constant.YES_INT.equals(templateConf.getIsMouldDetailEnable())) {
            Assert.isNotBlank((String)templateConf.getMouldItemDtlTplId(), (String)"\u8bf7\u9009\u62e9\u6a21\u5177\u6210\u672c\u6e05\u5355\u7684\u6a21\u677f");
        }
        if (Constant.YES_INT.equals(templateConf.getIsOrderItemDetailEnable())) {
            Assert.isNotBlank((String)templateConf.getOrderItemDtlTplId(), (String)"\u8bf7\u9009\u62e9\u7269\u6599\u6210\u672c\u6e05\u5355\u7684\u6a21\u677f");
        }
        PropertyDefUtils.valid(templateConf.getOrderItemPropertyDefList());
        if (Constant.YES_INT.equals(templateConf.getIsMouldEnable())) {
            PropertyDefUtils.valid(templateConf.getMouldPropertyDefList());
        }
        if (Constant.YES_INT.equals(templateConf.getIsBusiCondEnable())) {
            PropertyDefUtils.valid(templateConf.getBusiConditionPropertyDefList());
        }
        TemplateConfExample example = new TemplateConfExample();
        example.createCriteria().andCodeEqualTo(templateConf.getCode()).andIsHisEqualTo(Constant.NO_INT);
        List list = this.invoker.getTemplateConfService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new CommonException("\u8be5\u6a21\u677f\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        }
        example.clear();
        example.createCriteria().andNameEqualTo(templateConf.getName()).andIsHisEqualTo(Constant.NO_INT);
        list = this.invoker.getTemplateConfService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new CommonException("\u8be5\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        }
    }
}

