/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.dao.InquirySupReadMapper;
import com.els.base.inquiry.entity.InquirySupRead;
import com.els.base.inquiry.entity.InquirySupReadExample;
import com.els.base.inquiry.service.InquirySupReadService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultInquirySupReadService")
public class InquirySupReadServiceImpl
implements InquirySupReadService {
    @Resource
    protected InquirySupReadMapper inquirySupReadMapper;

    @CacheEvict(value={"inquirySupRead"}, allEntries=true)
    public void addObj(InquirySupRead t) {
        this.inquirySupReadMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"inquirySupRead"}, allEntries=true)
    public void addAll(List<InquirySupRead> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.inquirySupReadMapper.insertBatch(list);
    }

    @CacheEvict(value={"inquirySupRead"}, allEntries=true)
    public void deleteObjById(String id) {
        this.inquirySupReadMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"inquirySupRead"}, allEntries=true)
    public void modifyObj(InquirySupRead t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.inquirySupReadMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"inquirySupRead"}, keyGenerator="redisKeyGenerator")
    public InquirySupRead queryObjById(String id) {
        return this.inquirySupReadMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"inquirySupRead"}, keyGenerator="redisKeyGenerator")
    public List<InquirySupRead> queryAllObjByExample(InquirySupReadExample example) {
        return this.inquirySupReadMapper.selectByExample(example);
    }

    @Cacheable(value={"inquirySupRead"}, keyGenerator="redisKeyGenerator")
    public PageView<InquirySupRead> queryObjByPage(InquirySupReadExample example) {
        PageView<InquirySupRead> pageView = example.getPageView();
        pageView.setQueryResult(this.inquirySupReadMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"inquirySupRead"}, allEntries=true)
    public void deleteByExample(InquirySupReadExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.inquirySupReadMapper.deleteByExample(arg0);
    }
}

