/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.dao.InquiryWaitMaterialMapper;
import com.els.base.inquiry.entity.InquiryWaitMaterial;
import com.els.base.inquiry.entity.InquiryWaitMaterialExample;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.service.InquiryWaitMaterialService;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.web.vo.WaitMaterialTransformVo;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultInquiryWaitMaterialService")
public class InquiryWaitMaterialServiceImpl
implements InquiryWaitMaterialService {
    @Resource
    protected InquiryWaitMaterialMapper inquiryWaitMaterialMapper;
    @Resource
    private TemplateConfService templateConfService;

    @CacheEvict(value={"inquiryWaitMaterial"}, allEntries=true)
    public void addObj(InquiryWaitMaterial t) {
        this.inquiryWaitMaterialMapper.insertSelective(t);
    }

    @CacheEvict(value={"inquiryWaitMaterial"}, allEntries=true)
    public void deleteObjById(String id) {
        this.inquiryWaitMaterialMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"inquiryWaitMaterial"}, allEntries=true)
    public void modifyObj(InquiryWaitMaterial t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.inquiryWaitMaterialMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"inquiryWaitMaterial"}, keyGenerator="redisKeyGenerator")
    public InquiryWaitMaterial queryObjById(String id) {
        return this.inquiryWaitMaterialMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"inquiryWaitMaterial"}, keyGenerator="redisKeyGenerator")
    public List<InquiryWaitMaterial> queryAllObjByExample(InquiryWaitMaterialExample example) {
        return this.inquiryWaitMaterialMapper.selectByExample(example);
    }

    @Cacheable(value={"inquiryWaitMaterial"}, keyGenerator="redisKeyGenerator")
    public PageView<InquiryWaitMaterial> queryObjByPage(InquiryWaitMaterialExample example) {
        PageView<InquiryWaitMaterial> pageView = example.getPageView();
        pageView.setQueryResult(this.inquiryWaitMaterialMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public List<ITarget> transformToPurOrderMaterial(WaitMaterialTransformVo waitMaterialTransformVo) {
        ArrayList<ITarget> targets = null;
        if (waitMaterialTransformVo != null && StringUtils.isNotBlank((String)waitMaterialTransformVo.getTemplateId()) && CollectionUtils.isNotEmpty(waitMaterialTransformVo.getMaterials())) {
            TemplateConf templateConf = (TemplateConf)this.templateConfService.queryObjById(waitMaterialTransformVo.getTemplateId());
            String className = templateConf.getTargetClassName();
            targets = new ArrayList<ITarget>();
            try {
                Class<?> clazz = Class.forName(className);
                for (InquiryWaitMaterial inquiryWaitMaterial : waitMaterialTransformVo.getMaterials()) {
                    ITarget target = (ITarget)clazz.newInstance();
                    target.buildFromWaitMaterial(waitMaterialTransformVo.getTemplateId(), inquiryWaitMaterial);
                    targets.add(target);
                }
            }
            catch (ClassNotFoundException e) {
                throw new CommonException(String.format("\u8f6c\u6210\u8be2\u4ef7\u5355\u7269\u6599\u51fa\u9519,\u4e0d\u5b58\u5728\u7c7b[%s]", className), (Throwable)e);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CommonException("\u5f85\u8be2\u4ef7\u6e05\u5355\u8f6c\u6210\u8be2\u4ef7\u5355\u7269\u6599\u5931\u8d25");
            }
        }
        return targets;
    }

    @Override
    @CacheEvict(value={"inquiryWaitMaterial"}, keyGenerator="redisKeyGenerator")
    public void initDataFromPLM(String param1) throws Exception {
    }

    @Override
    @CacheEvict(value={"inquiryWaitMaterial"}, allEntries=true)
    public void modifyByExample(InquiryWaitMaterial waitMaterial, InquiryWaitMaterialExample example) {
        this.inquiryWaitMaterialMapper.updateByExampleSelective(waitMaterial, example);
    }

    @Override
    @CacheEvict(value={"inquiryWaitMaterial"}, allEntries=true)
    public void batchInsertWaitMaterial(List<InquiryWaitMaterial> waitMaterials) {
        for (InquiryWaitMaterial waitMaterial : waitMaterials) {
            this.addObj(waitMaterial);
        }
    }

    @Transactional
    @CacheEvict(value={"inquiryWaitMaterial"}, allEntries=true)
    public void addAll(List<InquiryWaitMaterial> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
                this.inquiryWaitMaterialMapper.insertSelective((InquiryWaitMaterial)item);
            }
        });
    }

    @CacheEvict(value={"inquiryWaitMaterial"}, allEntries=true)
    public void deleteByExample(InquiryWaitMaterialExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.inquiryWaitMaterialMapper.deleteByExample(arg0);
    }
}

