/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.dao.TemplateConfMapper;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.entity.TemplateConfExample;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import com.els.base.inquiry.service.PropertyDefService;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.inquiry.utils.PropertyDefUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultTemplateConfService")
public class TemplateConfServiceImpl
implements TemplateConfService {
    @Resource
    protected TemplateConfMapper templateConfMapper;
    @Resource
    protected PropertyDefService propertyDefService;
    @Resource
    protected TplOrderItemDetailService tplOrderItemDetailService;

    @CacheEvict(value={"templateConf"}, allEntries=true)
    public void addObj(TemplateConf t) {
        Assert.isNotBlank((String)t.getCode(), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        TemplateConfExample example = new TemplateConfExample();
        example.createCriteria().andCodeEqualTo(t.getCode()).andIsHisEqualTo(Constant.NO_INT);
        if (this.templateConfMapper.countByExample(example) > 0) {
            throw new CommonException("\u7f16\u7801\u5df2\u5b58\u5728");
        }
        this.templateConfMapper.insertSelective(t);
    }

    @CacheEvict(value={"templateConf"}, allEntries=true)
    public void deleteObjById(String id) {
        this.templateConfMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"templateConf"}, allEntries=true)
    public void modifyObj(TemplateConf t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        if (t.getCode() == null) {
            this.templateConfMapper.updateByPrimaryKeySelective(t);
            return;
        }
        TemplateConfExample example = new TemplateConfExample();
        example.createCriteria().andCodeEqualTo(t.getCode()).andIdNotEqualTo(t.getId()).andIsHisEqualTo(Constant.NO_INT);
        if (this.templateConfMapper.countByExample(example) > 0) {
            throw new CommonException("\u7f16\u7801\u5df2\u5b58\u5728");
        }
        this.templateConfMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"templateConf"}, keyGenerator="redisKeyGenerator")
    public TemplateConf queryObjById(String id) {
        TemplateConf templateConf = this.templateConfMapper.selectByPrimaryKey(id);
        Assert.isNotNull((Object)templateConf, (String)"\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
        if (!Constant.YES_INT.equals(templateConf.getIsHis())) {
            return this.initData(templateConf);
        }
        return this.initHisData(templateConf);
    }

    private TemplateConf initHisData(TemplateConf templateConf) {
        List<PropertyDef> itemProDefList = this.propertyDefService.queryHisPropertyDefList(templateConf.getId(), PropertyDefTplType.ORDER_ITEM.getCode());
        templateConf.setOrderItemPropertyDefList(itemProDefList);
        if (Constant.YES_INT.equals(templateConf.getIsMouldEnable())) {
            List<PropertyDef> mouldProDefList = this.propertyDefService.queryHisPropertyDefList(templateConf.getId(), PropertyDefTplType.MOULD_TYPE.getCode());
            templateConf.setMouldPropertyDefList(mouldProDefList);
        }
        if (Constant.YES_INT.equals(templateConf.getIsBusiCondEnable())) {
            List<PropertyDef> busProDefList = this.propertyDefService.queryHisPropertyDefList(templateConf.getId(), PropertyDefTplType.BUSI_TYPE.getCode());
            templateConf.setBusiConditionPropertyDefList(busProDefList);
        }
        if (Constant.YES_INT.equals(templateConf.getIsOrderItemDetailEnable()) && StringUtils.isNotBlank((String)templateConf.getOrderItemDtlTplId())) {
            templateConf.setTplOrderItemDetail((TplOrderItemDetail)this.tplOrderItemDetailService.queryObjById(templateConf.getOrderItemDtlTplId()));
        }
        return templateConf;
    }

    private TemplateConf initData(TemplateConf templateConf) {
        templateConf.setOrderItemPropertyDefList(PropertyDefUtils.queryOrderItemProDef(templateConf));
        if (Constant.YES_INT.equals(templateConf.getIsBusiCondEnable())) {
            templateConf.setBusiConditionPropertyDefList(PropertyDefUtils.queryBusiConditionProDef(templateConf));
        }
        if (Constant.YES_INT.equals(templateConf.getIsOrderItemDetailEnable()) && StringUtils.isNotBlank((String)templateConf.getOrderItemDtlTplId())) {
            templateConf.setTplOrderItemDetail((TplOrderItemDetail)this.tplOrderItemDetailService.queryObjById(templateConf.getOrderItemDtlTplId()));
        }
        return templateConf;
    }

    @Cacheable(value={"templateConf"}, keyGenerator="redisKeyGenerator")
    public List<TemplateConf> queryAllObjByExample(TemplateConfExample example) {
        return this.templateConfMapper.selectByExample(example);
    }

    @Cacheable(value={"templateConf"}, keyGenerator="redisKeyGenerator")
    public PageView<TemplateConf> queryObjByPage(TemplateConfExample example) {
        PageView<TemplateConf> pageView = example.getPageView();
        pageView.setQueryResult(this.templateConfMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Transactional
    @CacheEvict(value={"templateConf"}, allEntries=true)
    public void addAll(List<TemplateConf> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
                this.templateConfMapper.insertSelective((TemplateConf)item);
            }
        });
    }

    @CacheEvict(value={"templateConf"}, allEntries=true)
    public void deleteByExample(TemplateConfExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.templateConfMapper.deleteByExample(arg0);
    }
}

