/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.utils;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.IOrderItemService;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.ITargetService;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.utils.SpringContextHolder;

public class InquiryTemplateFactory {
    private TemplateConf templateConf;

    public static InquiryTemplateFactory getInstance(String templateId) {
        Assert.isNotBlank((String)templateId, (String)"\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
        TemplateConfService service = (TemplateConfService)SpringContextHolder.getOneBean(TemplateConfService.class);
        TemplateConf templateConf = (TemplateConf)service.queryObjById(templateId);
        Assert.isNotNull((Object)templateConf, (String)"\u6a21\u677f\u914d\u7f6e\u6570\u636e\u4e0d\u5b58\u5728");
        Assert.isNotBlank((String)templateConf.getTargetClassName(), (String)"\u6a21\u677f\u914d\u7f6e\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u7f3a\u5c11targetClass");
        Assert.isNotBlank((String)templateConf.getTargetServiceClassName(), (String)"\u6a21\u677f\u914d\u7f6e\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u7f3a\u5c11targetService");
        Assert.isNotBlank((String)templateConf.getItemClassName(), (String)"\u6a21\u677f\u914d\u7f6e\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u7f3a\u5c11itemClass");
        Assert.isNotBlank((String)templateConf.getItemServiceClassName(), (String)"\u6a21\u677f\u914d\u7f6e\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u7f3a\u5c11itemService");
        return new InquiryTemplateFactory(templateConf);
    }

    private InquiryTemplateFactory(TemplateConf templateConf) {
        this.templateConf = templateConf;
    }

    public <T extends ITarget> Class<T> getTargetClass() {
        try {
            return Class.forName(this.templateConf.getTargetClassName());
        }
        catch (ClassNotFoundException e) {
            throw new CommonException(String.format("\u6a21\u677f\u914d\u7f6e\u5f02\u5e38,\u4e0d\u5b58\u5728\u7c7b[%s]", this.templateConf.getTargetClassName()), (Throwable)e);
        }
    }

    public <TS extends ITargetService> TS getTargetService() {
        try {
            Class<?> clazz = Class.forName(this.templateConf.getTargetServiceClassName());
            return (TS)((ITargetService)SpringContextHolder.getOneBean(clazz));
        }
        catch (ClassNotFoundException e) {
            throw new CommonException(String.format("\u6a21\u677f\u914d\u7f6e\u5f02\u5e38,\u4e0d\u5b58\u5728\u7c7b[%s]", this.templateConf.getTargetClassName()), (Throwable)e);
        }
    }

    public String getTargetName() {
        return "M001";
    }

    public <IT extends IOrderItem> Class<IT> getItemClass() {
        try {
            return Class.forName(this.templateConf.getItemClassName());
        }
        catch (ClassNotFoundException e) {
            throw new CommonException(String.format("\u6a21\u677f\u914d\u7f6e\u5f02\u5e38,\u4e0d\u5b58\u5728\u7c7b[%s]", this.templateConf.getTargetClassName()), (Throwable)e);
        }
    }

    public <ITS extends IOrderItemService> ITS getItemService() {
        try {
            Class<?> clazz = Class.forName(this.templateConf.getItemServiceClassName());
            return (ITS)((IOrderItemService)SpringContextHolder.getOneBean(clazz));
        }
        catch (ClassNotFoundException e) {
            throw new CommonException(String.format("\u6a21\u677f\u914d\u7f6e\u5f02\u5e38,\u4e0d\u5b58\u5728\u7c7b[%s]", this.templateConf.getTargetClassName()), (Throwable)e);
        }
    }
}

