/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.utils.excel;

import com.els.base.core.utils.Assert;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

public class OrderItemExcelUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void export(String templateId, ServletOutputStream os) throws RowsExceededException, WriteException, IOException, ParseException {
        TemplateConf templateConf = (TemplateConf)((TemplateConfService)SpringContextHolder.getOneBean(TemplateConfService.class)).queryObjById(templateId);
        Assert.isNotNull((Object)templateConf, (String)"\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
        List<PropertyDef> propertyDefList = templateConf.getOrderItemPropertyDefList();
        Assert.isNotEmpty(templateConf.getOrderItemPropertyDefList(), (String)"\u6a21\u677f\u7684\u5b57\u6bb5\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
        List<TitleAndModelKey> titleAndModelKeys = OrderItemExcelUtils.transfromProDef(propertyDefList);
        WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)os, titleAndModelKeys, null, (String)"\u5bfc\u5165\u7269\u6599", null, (int)0);
        try {
            writableWorkbook.write();
            os.flush();
        }
        finally {
            writableWorkbook.close();
            os.close();
        }
    }

    private static List<TitleAndModelKey> transfromProDef(List<PropertyDef> propertyDefList) {
        Assert.isNotEmpty(propertyDefList, (String)"\u6a21\u677f\u7684\u5b57\u6bb5\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u54c1\u540d", (String)"materialName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u54c1\u724c", (String)"brand"));
        return titleAndModelKeys;
    }

    public static List<? extends ITarget> importFromExcel(String templateId, InputStream in) throws Exception {
        TemplateConf templateConf = (TemplateConf)((TemplateConfService)SpringContextHolder.getOneBean(TemplateConfService.class)).queryObjById(templateId);
        Assert.isNotNull((Object)templateConf, (String)"\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
        List<PropertyDef> propertyDefList = templateConf.getOrderItemPropertyDefList();
        Assert.isNotEmpty(templateConf.getOrderItemPropertyDefList(), (String)"\u6a21\u677f\u7684\u5b57\u6bb5\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
        List<TitleAndModelKey> titleAndModelKeys = OrderItemExcelUtils.transfromProDef(propertyDefList);
        List targetList = ExcelUtils.importExcelDataToMap((InputStream)in, (int)0, (int)1, (int)0, titleAndModelKeys, templateConf.getTargetClass());
        targetList.forEach(target -> target.setTemplateId(templateId));
        return targetList;
    }
}

