/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.template.CreateOrderItemDetailTplCmd;
import com.els.base.inquiry.command.template.DeleteOrderItemDetailTplCmd;
import com.els.base.inquiry.command.template.ModifyOrderItemDetailTplCmd;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.entity.TplOrderItemDetailExample;
import com.els.base.inquiry.service.PropertyDefService;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.inquiry.utils.ClassReflectionUtils;
import com.els.base.inquiry.utils.InquiryConstant;
import com.els.base.inquiry.utils.PropertyDefUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u8be2\u62a5\u4ef7-\u7269\u6599\u6210\u672c\u6e05\u5355\u6a21\u677f")
@Controller
@RequestMapping(value={"tplOrderItemDetail"})
public class TplOrderItemDetailController {
    @Resource
    protected TplOrderItemDetailService tplOrderItemDetailService;
    @Resource
    protected PropertyDefService propertyDefService;
    @Resource
    private InquiryCommandInvoker invoker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8be2\u62a5\u4ef7-\u7269\u6599\u6210\u672c\u6e05\u5355\u6a21\u677f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody TplOrderItemDetail tplOrderItemDetail) {
        CreateOrderItemDetailTplCmd cmd = new CreateOrderItemDetailTplCmd(tplOrderItemDetail);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        return ResponseResult.success((Object)this.invoker.invoke(cmd));
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8be2\u62a5\u4ef7-\u7269\u6599\u6210\u672c\u6e05\u5355\u6a21\u677f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody TplOrderItemDetail tplOrderItemDetail) {
        Assert.isNotBlank((String)tplOrderItemDetail.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        ModifyOrderItemDetailTplCmd cmd = new ModifyOrderItemDetailTplCmd(tplOrderItemDetail);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        return ResponseResult.success((Object)this.invoker.invoke(cmd));
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8be2\u62a5\u4ef7-\u7269\u6599\u6210\u672c\u6e05\u5355\u6a21\u677f")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestBody List<String> idList) {
        Assert.isNotEmpty(idList, (String)"\u5220\u9664\u5931\u8d25,\u6a21\u677f\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        DeleteOrderItemDetailTplCmd cmd = new DeleteOrderItemDetailTplCmd(idList);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8be2\u62a5\u4ef7-\u7269\u6599\u6210\u672c\u6e05\u5355\u6a21\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 TplOrderItemDetail", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<TplOrderItemDetail>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        TplOrderItemDetailExample example = new TplOrderItemDetailExample();
        example.setPageView((PageView<TplOrderItemDetail>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        TplOrderItemDetailExample.Criteria criteria = example.createCriteria();
        criteria.andIsHisEqualTo(Constant.NO_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.tplOrderItemDetailService.queryObjByPage((IExample)example);
        for (TplOrderItemDetail tplOrderItemDetail : pageData.getQueryResult()) {
            tplOrderItemDetail.setPropertyDefList(PropertyDefUtils.queryOrderItemDetailProDef(tplOrderItemDetail));
        }
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u8be2\u62a5\u4ef7-\u7269\u6599\u6210\u672c\u6e05\u5355\u6a21\u677f-\u521b\u5efa\u9884\u89c8")
    @ApiImplicitParams(value={@ApiImplicitParam(name="className", required=false, value="\u6a21\u677f\u6307\u5b9a\u7c7b\u540d(\u975e\u5fc5\u586b)", paramType="query", dataType="String", defaultValue="0")})
    @RequestMapping(value={"service/preview"})
    @ResponseBody
    public ResponseResult<TplOrderItemDetail> preview(String className) throws InstantiationException, IllegalAccessException {
        Class clazz = null;
        clazz = StringUtils.isNotBlank((String)className) ? ClassReflectionUtils.getClassByName(className) : InquiryConstant.DEFALUT_ORDER_TIEM_DETAIL_CLS;
        TplOrderItemDetail tplOrderItemDetail = new TplOrderItemDetail();
        String dateFormat = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
        tplOrderItemDetail.setCode(String.format("TPL_ORDER_ITEM_DETAIL_%s", dateFormat));
        tplOrderItemDetail.setName(String.format("\u7269\u6599\u6210\u672c\u6e05\u5355%s", dateFormat));
        tplOrderItemDetail.setPropertyDefList(PropertyDefUtils.getProperyDefByClass(clazz));
        tplOrderItemDetail.setOrderDtlClassName(clazz.getName());
        tplOrderItemDetail.setOrderDtlServiceName(((IOrderItemDetail)clazz.newInstance()).getItemDetailService().getName());
        return ResponseResult.success((Object)tplOrderItemDetail);
    }
}

