/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.pur.PricingCommand;
import com.els.base.inquiry.entity.InformationRecord;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.InquirySupOrderExample;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryAuditStatus;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.enumclass.OperationTypeEnum;
import com.els.base.inquiry.event.ApprovePassListener;
import com.els.base.inquiry.web.vo.ApproveSubmitVo;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.entity.WorkOrderVo;
import java.util.List;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.lang.StringUtils;

public class ApproveSubmitCommand
extends AbstractInquiryCommand<String> {
    private PurOrder purOrder;
    private InformationRecord informationRecord;

    public ApproveSubmitCommand(ApproveSubmitVo vo) {
        this.purOrder = vo.getPurOrder();
        this.informationRecord = vo.getInformationRecord();
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        this.vaild(this.purOrder, this.informationRecord);
        PricingCommand pricingCommand = new PricingCommand(this.purOrder);
        pricingCommand.copyProperties(this);
        invoker.invoke(pricingCommand);
        this.informationRecord.setPurOrderId(this.purOrder.getId());
        invoker.getInformationRecordService().addObj(this.informationRecord);
        this.logger.info("\u8bb0\u5f55\u91c7\u8d2d\u65b9\u7684\u63a5\u53d7\u6216\u62d2\u7edd\u64cd\u4f5c");
        this.purOrder.getItemList().stream().filter(item -> OperationTypeEnum.isPricingOperation(item.getOperation())).forEach(item -> {
            TemplateConf templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(this.purOrder.getTemplateId());
            try {
                IOrderItem tmpItem = templateConf.getOrderItemClass().newInstance();
                tmpItem.setId(item.getId());
                tmpItem.setOperation(item.getOperation());
                if (InquiryQuoteStatus.REQUOTED.getCode().equals(item.getQuotationStatus())) {
                    tmpItem.setIsReQuote(Constant.YES_INT);
                }
                if (OperationTypeEnum.ACCEPTED.getCode().equals(tmpItem.getOperation()) || OperationTypeEnum.REFUSED.getCode().equals(tmpItem.getOperation())) {
                    tmpItem.setQuotationStatus(InquiryQuoteStatus.AUDITING.getCode());
                }
                templateConf.getOrderItemService().modifyStatus(tmpItem);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        });
        this.logger.info("\u5c06\u91c7\u8d2d\u65b9\u8be2\u4ef7\u5355\u5934\u72b6\u6001\u6539\u6210\u201c\u5ba1\u6279\u4e2d\u201d\u72b6\u6001");
        PurOrder temp = new PurOrder();
        temp.setId(this.purOrder.getId());
        temp.setAuditStatus(InquiryAuditStatus.AUDITING.getCode());
        invoker.getPurOrderService().modifyObj(temp);
        this.logger.info("\u5c06\u4f9b\u5e94\u5546\u8be2\u4ef7\u5355\u5934\u72b6\u6001\u6539\u6210\u201c\u5df2\u51bb\u7ed3\u201d\u72b6\u6001");
        this.transformSupOrderToFrozen(this.purOrder);
        this.logger.info("\u63d0\u4ea4\u8be2\u4ef7\u5355\u5ba1\u6838\uff0c\u5f00\u542f\u5ba1\u6279\u6d41");
        String displayPage = String.format("inquiryBillManagerPur?id=%s", this.purOrder.getId());
        ProcessStartVO vo = ProcessStartVO.newInstance((String)"xjdgl", (String)this.purOrder.getOrderNo(), (String)this.purOrder.getId(), (String)displayPage);
        vo.setListenerClass(ApprovePassListener.class);
        ProcessInstance startProcess = invoker.getWorkFlowService().startProcess(vo);
        if (startProcess == null) {
            throw new CommonException("\u542f\u52a8\u5ba1\u6279\u6d41\u7a0b\u5931\u8d25");
        }
        if (StringUtils.isNotBlank((String)startProcess.getProcessInstanceId())) {
            PurOrder tempOrder = new PurOrder();
            tempOrder.setId(this.purOrder.getId());
            tempOrder.setApproveFlowId(startProcess.getProcessInstanceId());
            List taskListForProcess = invoker.getWorkFlowService().findTaskListForProcess(startProcess.getProcessInstanceId());
            tempOrder.setNextApprover(((WorkOrderVo)taskListForProcess.get(0)).getTaskDefinitionName());
            invoker.getPurOrderService().modifyObj(tempOrder);
        }
        return null;
    }

    private void vaild(PurOrder purOrder, InformationRecord informationRecord) {
        Assert.isNotNull((Object)informationRecord, (String)"\u4fe1\u606f\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)purOrder, (String)"\u8be2\u4ef7\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(purOrder.getItemList(), (String)"\u8be2\u4ef7\u5355\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)informationRecord.getInformationRecordCategory(), (String)"\u4fe1\u606f\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)informationRecord.getConditionalType(), (String)"\u6761\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)informationRecord.getPurchaseOrganization(), (String)"\u91c7\u8d2d\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)informationRecord.getPurchasingGroup(), (String)"\u91c7\u8d2d\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)informationRecord.getFactoryCode(), (String)"\u5de5\u5382\u4e0d\u80fd\u4e3a\u7a7a");
        if (!InquiryOrderStatus.PUBLISHED.getCode().equals(purOrder.getInquiryOrderStatus())) {
            throw new CommonException("\u53ea\u6709\u5df2\u53d1\u5e03\u7684\u8be2\u4ef7\u5355\u624d\u80fd\u63d0\u4ea4\u5ba1\u6279");
        }
        if (InquiryQuoteStatus.UNQUOTED.getCode().equals(purOrder.getQuoteStatus())) {
            throw new CommonException("\u8be2\u4ef7\u5355\u662f\u672a\u62a5\u4ef7\uff0c\u65e0\u6cd5\u63d0\u4ea4\u5ba1\u6279");
        }
        long quotedCount = purOrder.getItemList().stream().filter(orderItem -> InquiryQuoteStatus.QUOTED.getCode().equals(orderItem.getQuotationStatus()) || InquiryQuoteStatus.REQUOTED.getCode().equals(orderItem.getQuotationStatus())).count();
        if (quotedCount <= 0L) {
            throw new CommonException("\u6ca1\u6709\u5df2\u62a5\u4ef7\u7684\u884c\u9879\u76ee\uff0c\u65e0\u6cd5\u63d0\u4ea4\u5ba1\u6279");
        }
        List<IOrderItem> orderItems = purOrder.getItemList();
        orderItems.forEach(orderItem -> {
            if ((InquiryQuoteStatus.QUOTED.getCode().equals(orderItem.getQuotationStatus()) || InquiryQuoteStatus.REQUOTED.getCode().equals(orderItem.getQuotationStatus())) && !OperationTypeEnum.ACCEPTED.getCode().equals(orderItem.getOperation())) {
                orderItem.setOperation(OperationTypeEnum.REFUSED.getCode());
            }
        });
    }

    private void transformSupOrderToFrozen(PurOrder purOrder) {
        InquirySupOrderExample example = new InquirySupOrderExample();
        example.createCriteria().andPurOrderIdEqualTo(purOrder.getId());
        InquirySupOrder tmp = new InquirySupOrder();
        tmp.setInquiryOrderStatus(InquiryOrderStatus.FROZEN.getCode());
        tmp.setAuditStatus(InquiryAuditStatus.AUDITING.getCode());
        this.invoker.getInquirySupOrderService().modifyByExample(tmp, example);
    }
}

