/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.sup;

import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.sup.PublishQuoteCommand;
import com.els.base.inquiry.command.sup.PublishSupOrderCommand;
import com.els.base.inquiry.command.sup.SupViewDetailCommand;
import com.els.base.inquiry.entity.InquirySupOrder;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class BatchPublishQuoteCommand
extends AbstractInquiryCommand<String> {
    private List<String> ids;

    public BatchPublishQuoteCommand(List<String> ids) {
        this.ids = ids;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        Assert.isNotEmpty(this.ids, (String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        List supOrders = this.ids.parallelStream().map(this::getSupOrdersById).collect(Collectors.toList());
        Assert.isNotEmpty(supOrders, (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        for (InquirySupOrder inquirySupOrder : supOrders) {
            if (StringUtils.isNotBlank((String)inquirySupOrder.getPurOrderId())) {
                PublishQuoteCommand cmd = new PublishQuoteCommand(inquirySupOrder);
                cmd.copyProperties(this);
                invoker.invoke(cmd);
                continue;
            }
            InquirySupOrder supOrder = invoker.invoke(new SupViewDetailCommand(inquirySupOrder.getId()));
            PublishSupOrderCommand cmd = new PublishSupOrderCommand(supOrder);
            cmd.copyProperties(this);
            invoker.invoke(cmd);
        }
        return null;
    }

    private InquirySupOrder getSupOrdersById(String supOrderId) {
        SupViewDetailCommand cmd = new SupViewDetailCommand(supOrderId);
        cmd.copyProperties(this);
        return this.invoker.invoke(cmd);
    }
}

