/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.inquiry.dao.InquirySupFileMapper;
import com.els.base.inquiry.entity.InquirySupFile;
import com.els.base.inquiry.entity.InquirySupFileExample;
import com.els.base.inquiry.service.InquirySupFileService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultInquirySupFileService")
public class InquirySupFileServiceImpl
implements InquirySupFileService {
    @Resource
    protected InquirySupFileMapper inquirySupFileMapper;

    @CacheEvict(value={"inquirySupFile"}, allEntries=true)
    public void addObj(InquirySupFile t) {
        this.inquirySupFileMapper.insertSelective(t);
    }

    @CacheEvict(value={"inquirySupFile"}, allEntries=true)
    public void deleteObjById(String id) {
        this.inquirySupFileMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"inquirySupFile"}, allEntries=true)
    public void modifyObj(InquirySupFile t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.inquirySupFileMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"inquirySupFile"}, keyGenerator="redisKeyGenerator")
    public InquirySupFile queryObjById(String id) {
        return this.inquirySupFileMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"inquirySupFile"}, keyGenerator="redisKeyGenerator")
    public List<InquirySupFile> queryAllObjByExample(InquirySupFileExample example) {
        return this.inquirySupFileMapper.selectByExample(example);
    }

    @Cacheable(value={"inquirySupFile"}, keyGenerator="redisKeyGenerator")
    public PageView<InquirySupFile> queryObjByPage(InquirySupFileExample example) {
        PageView<InquirySupFile> pageView = example.getPageView();
        pageView.setQueryResult(this.inquirySupFileMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"inquirySupFile"}, allEntries=true)
    public void deleteByExample(InquirySupFileExample example) {
        if (example == null || CollectionUtils.isEmpty(example.getOredCriteria())) {
            return;
        }
        this.inquirySupFileMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"inquirySupFile"}, allEntries=true)
    public void modifyByExample(InquirySupFile supFile, InquirySupFileExample example) {
        this.inquirySupFileMapper.updateByExampleSelective(supFile, example);
    }

    @Transactional
    @CacheEvict(value={"inquirySupFile"}, allEntries=true)
    public void addAll(List<InquirySupFile> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
                this.inquirySupFileMapper.insertSelective((InquirySupFile)item);
            }
        });
    }
}

