/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.dao.MaterielParityMapper;
import com.els.base.inquiry.entity.MaterielParity;
import com.els.base.inquiry.entity.MaterielParityExample;
import com.els.base.inquiry.service.MaterielParityService;
import com.els.base.inquiry.web.vo.MaterielParityVo;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="defaultMaterielParityService")
public class MaterielParityServiceImpl
implements MaterielParityService {
    @Resource
    protected MaterielParityMapper materielParityMapper;

    @CacheEvict(value={"materielParity"}, allEntries=true)
    public void addObj(MaterielParity t) {
        this.materielParityMapper.insertSelective(t);
    }

    @CacheEvict(value={"materielParity"}, allEntries=true)
    public void deleteObjById(String id) {
        this.materielParityMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"materielParity"}, allEntries=true)
    public void modifyObj(MaterielParity t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.materielParityMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"materielParity"}, keyGenerator="redisKeyGenerator")
    public MaterielParity queryObjById(String id) {
        return this.materielParityMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"materielParity"}, keyGenerator="redisKeyGenerator")
    public List<MaterielParity> queryAllObjByExample(MaterielParityExample example) {
        return this.materielParityMapper.selectByExample(example);
    }

    @Cacheable(value={"materielParity"}, keyGenerator="redisKeyGenerator")
    public PageView<MaterielParity> queryObjByPage(MaterielParityExample example) {
        PageView<MaterielParity> pageView = example.getPageView();
        pageView.setQueryResult(this.materielParityMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"materielParity"}, allEntries=true)
    public void batchModify(MaterielParityVo materielParityVo) {
        String orderItemId = materielParityVo.getOrderItemId();
        if (StringUtils.isBlank((String)orderItemId)) {
            throw new CommonException("\u884c\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MaterielParityExample example = new MaterielParityExample();
        example.createCriteria().andOrderItemIdEqualTo(orderItemId);
        this.materielParityMapper.deleteByExample(example);
        if (!CollectionUtils.isEmpty(materielParityVo.getMaterielParitys())) {
            materielParityVo.getMaterielParitys().forEach(materielParity -> {
                materielParity.setOrderItemId(orderItemId);
                this.addObj((MaterielParity)materielParity);
            });
        }
    }

    @Transactional
    @CacheEvict(value={"materielParity"}, allEntries=true)
    public void addAll(List<MaterielParity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
                this.materielParityMapper.insertSelective((MaterielParity)item);
            }
        });
    }

    @CacheEvict(value={"materielParity"}, allEntries=true)
    public void deleteByExample(MaterielParityExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.materielParityMapper.deleteByExample(arg0);
    }
}

