/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.dao.PropertyDefMapper;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.PropertyDefExample;
import com.els.base.inquiry.service.PropertyDefService;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPropertyDefService")
public class PropertyDefServiceImpl
implements PropertyDefService {
    @Resource
    protected PropertyDefMapper propertyDefMapper;
    @Resource
    protected TemplateConfService templateConfService;
    @Resource
    protected TplOrderItemDetailService tplOrderItemDetailService;

    @CacheEvict(value={"propertyDef"}, allEntries=true)
    public void addObj(PropertyDef t) {
        Assert.isNotBlank((String)t.getCode(), (String)"\u5b57\u6bb5\u7684\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)t.getName(), (String)"\u5b57\u6bb5\u7684\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        if (!t.getCode().matches("[\\w_-]+")) {
            throw new CommonException("\u9879\u76ee\u4ee3\u7801\u53ea\u80fd\u4f7f\u7528\u82f1\u6587\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3001\u6a2a\u7ebf");
        }
        if (t.getCode().length() > 32) {
            throw new CommonException("\u7f16\u7801\u6700\u591a\u53ea\u652f\u630132\u4e2a\u5b57\u7b26");
        }
        this.propertyDefMapper.insertSelective(t);
    }

    @CacheEvict(value={"propertyDef"}, allEntries=true)
    public void deleteObjById(String id) {
        this.propertyDefMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"propertyDef"}, allEntries=true)
    public void modifyObj(PropertyDef t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.propertyDefMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"propertyDef"}, keyGenerator="redisKeyGenerator")
    public PropertyDef queryObjById(String id) {
        return this.propertyDefMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"propertyDef"}, keyGenerator="redisKeyGenerator")
    public List<PropertyDef> queryAllObjByExample(PropertyDefExample example) {
        return this.propertyDefMapper.selectByExample(example);
    }

    @Cacheable(value={"propertyDef"}, keyGenerator="redisKeyGenerator")
    public PageView<PropertyDef> queryObjByPage(PropertyDefExample example) {
        PageView<PropertyDef> pageView = example.getPageView();
        pageView.setQueryResult(this.propertyDefMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"propertyDef"}, keyGenerator="redisKeyGenerator")
    public List<PropertyDef> queryPropertyDefList(String templateId, String tplType) {
        PropertyDefExample example = new PropertyDefExample();
        example.createCriteria().andTplIdEqualTo(templateId).andTplTypeEqualTo(tplType);
        example.setOrderByClause("SORT_NO ASC");
        return this.queryAllObjByExample(example);
    }

    @Override
    @Cacheable(value={"propertyDef"}, keyGenerator="redisKeyGenerator")
    public List<PropertyDef> queryHisPropertyDefList(String templateId, String tplType) {
        PropertyDefExample example = new PropertyDefExample();
        example.createCriteria().andTplIdEqualTo(templateId).andTplTypeEqualTo(tplType);
        return this.propertyDefMapper.selectHisByExample(example);
    }

    @Override
    @CacheEvict(value={"propertyDef"}, allEntries=true)
    public void removeAllByTpl(String tplId, String propertyTplTypeCod) {
        Assert.isNotNull((Object)tplId, (String)"\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)tplId, (String)"\u6a21\u677f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        PropertyDefExample example = new PropertyDefExample();
        example.createCriteria().andTplIdEqualTo(tplId).andTplTypeEqualTo(propertyTplTypeCod);
        this.propertyDefMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"propertyDef"}, allEntries=true)
    public void moveAllToHisByTpl(String tplId, String propertyTplTypeCod) {
        Assert.isNotNull((Object)tplId, (String)"\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)tplId, (String)"\u6a21\u677f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        PropertyDefExample example = new PropertyDefExample();
        example.createCriteria().andTplIdEqualTo(tplId).andTplTypeEqualTo(propertyTplTypeCod);
        this.propertyDefMapper.insertHisByExample(example);
        this.propertyDefMapper.deleteByExample(example);
    }

    @Override
    @Transactional
    @CacheEvict(value={"propertyDef"}, allEntries=true)
    public void addAll(List<PropertyDef> propertyDefList) {
        Assert.isNotEmpty(propertyDefList, (String)"\u5b57\u6bb5\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
        for (PropertyDef t : propertyDefList) {
            Assert.isNotBlank((String)t.getCode(), (String)"\u5b57\u6bb5\u7684\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)t.getName(), (String)"\u5b57\u6bb5\u7684\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            t.setId(UUIDGenerator.generateUUID());
        }
        this.propertyDefMapper.insertBatch(propertyDefList);
    }

    @CacheEvict(value={"propertyDef"}, allEntries=true)
    public void deleteByExample(PropertyDefExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.propertyDefMapper.deleteByExample(arg0);
    }
}

