/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.web.controller;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.Department;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.DepartmentService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.sup.SupViewDetailCommand;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.InquirySupOrderExample;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.service.InquirySupOrderService;
import com.els.base.inquiry.utils.excel.OrderExcelUtils;
import com.els.base.inquiry.utils.excel.OrderItemExcelUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(tags={"\u8be2\u62a5\u4ef7-\u5bfc\u5165\u5bfc\u51fa"})
@Controller
@RequestMapping(value={"inquiryExcel"})
public class InquiryExcelController {
    @Resource
    protected InquiryCommandInvoker invoker;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected UserService userService;
    @Resource
    protected InquirySupOrderService inquirySupOrderService;
    @Resource
    protected DepartmentService departmentService;

    @ApiOperation(httpMethod="POST", value="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f")
    @RequestMapping(value={"service/downloadExcel"})
    @ResponseBody
    public String downloadExcel(@RequestParam(required=true) String templateId, HttpServletResponse response) throws RowsExceededException, WriteException, IOException, ParseException {
        String fileName = String.format("\u7269\u6599\u6e05\u5355\u6a21\u677f%s.xls", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        this.setDownloadHeader(fileName, response);
        OrderItemExcelUtils.export(templateId, response.getOutputStream());
        return null;
    }

    @ApiOperation(httpMethod="POST", value="\u4e0a\u4f20excel\u5bfc\u5165\u6570\u636e")
    @RequestMapping(value={"service/uploadForImportExcel"})
    @ResponseBody
    public ResponseResult<List<? extends ITarget>> uploadForImportExcel(@RequestParam(required=true) String templateId, MultipartHttpServletRequest request) throws Exception {
        Map fileMap = request.getFileMap();
        if (MapUtils.isEmpty((Map)fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u53ea\u63a5\u53d7\u5355\u4e2a\u6587\u4ef6\u5bfc\u5165");
        }
        MultipartFile file = (MultipartFile)fileMap.entrySet().iterator().next().getValue();
        List<? extends ITarget> iTargets = null;
        try {
            iTargets = OrderItemExcelUtils.importFromExcel(templateId, file.getInputStream());
        }
        catch (IllegalArgumentException e) {
            throw new CommonException("EXCEL\u8868\u683c\u5f0f\u5f02\u5e38,\u8bf7\u6309\u7167EXCEL\u6a21\u677f\u683c\u5f0f\u586b\u5199");
        }
        return ResponseResult.success(iTargets);
    }

    @ApiOperation(httpMethod="POST", value="\u5bfc\u51fa\u8be2\u4ef7\u5355\u7684\u6570\u636e")
    @RequestMapping(value={"service/exportPurOrder"})
    @ResponseBody
    public ResponseResult<FileData> exportPurOrder(@RequestParam(required=true) String supOrderId, HttpServletResponse response) throws RowsExceededException, WriteException, IOException, ParseException, InterruptedException {
        boolean noneExistQuotedItem;
        InquirySupOrder supOrder = this.invoker.invoke(new SupViewDetailCommand(supOrderId));
        if (InquiryQuoteStatus.UNQUOTED.getCode().equals(supOrder.getQuoteStatus())) {
            throw new CommonException("\u8be5\u4f9b\u5e94\u5546\u62a5\u4ef7\u5355\u8fd8\u6ca1\u6709\u62a5\u4ef7\uff0c\u65e0\u6cd5\u5bfc\u51fa");
        }
        if (InquiryQuoteStatus.REQUOTE.getCode().equals(supOrder.getQuoteStatus()) && (noneExistQuotedItem = supOrder.getItemList().stream().noneMatch(item -> InquiryQuoteStatus.QUOTED.getCode().equals(item.getQuotationStatus()) || InquiryQuoteStatus.REQUOTED.getCode().equals(item.getQuotationStatus())))) {
            throw new CommonException("\u8be5\u4f9b\u5e94\u5546\u62a5\u4ef7\u5355\u8fd8\u6ca1\u6709\u62a5\u4ef7\uff0c\u65e0\u6cd5\u5bfc\u51fa");
        }
        TemplateConf templateConf = (TemplateConf)this.invoker.getTemplateConfService().queryObjById(supOrder.getTemplateId());
        Optional<Department> purDepartment = Optional.ofNullable(this.departmentService.queryDepartmentOfUser(supOrder.getPurUserId()));
        Optional<Department> supDepartment = Optional.ofNullable(this.departmentService.queryDepartmentOfUser(supOrder.getSupUserId()));
        HashMap<String, Object> other = new HashMap<String, Object>();
        other.put("purDepartmentName", purDepartment.map(Department::getDepartmentName).orElse(""));
        other.put("supDepartmentName", supDepartment.map(Department::getDepartmentName).orElse(""));
        OrderExcelUtils.ExportParam param = OrderExcelUtils.createParam().setPurUser((User)this.userService.queryObjById((Object)supOrder.getPurUserId())).setSupCompany((Company)this.companyService.queryObjById((Object)supOrder.getSupCompanyId())).setTemplateConf(templateConf).setSupOrder(supOrder).setOther(other);
        Workbook workbook = OrderExcelUtils.exportToExcel(param);
        String fileName = String.format("\u62a5\u4ef7\u5355%s.xls", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        FileData fileData = this.createEmptyPDF(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), fileName);
        File file = fileData.toFile();
        FileOutputStream fos = new FileOutputStream(file);
        workbook.write((OutputStream)fos);
        fos.flush();
        fos.close();
        workbook.close();
        return ResponseResult.success((Object)fileData);
    }

    private FileData createEmptyPDF(String projectId, String companyId, String filename) throws UnsupportedEncodingException, IOException {
        FileData pdfFile = new FileData();
        pdfFile.setProjectId(projectId);
        pdfFile.setCompanyId(companyId);
        pdfFile.setFileName(filename);
        pdfFile.setFileSuffix("xls");
        pdfFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
        pdfFile.setExpiryDay(DateUtils.addMinutes((Date)new Date(), (int)30));
        FileManagerFactory.getFileManager().createEmptyFile(pdfFile);
        return pdfFile;
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u62a5\u4ef7\u5355")
    @RequestMapping(value={"service/selectSupplier"})
    @ResponseBody
    public ResponseResult<List<InquirySupOrder>> selectSupplier(@RequestParam(required=true) String purOrderId) {
        InquirySupOrderExample example = new InquirySupOrderExample();
        example.createCriteria().andPurOrderIdEqualTo(purOrderId);
        List supplierList = this.inquirySupOrderService.queryAllObjByExample((IExample)example);
        return ResponseResult.success((Object)supplierList);
    }

    private void setDownloadHeader(String fileName, HttpServletResponse response) throws UnsupportedEncodingException {
        StringBuffer header = new StringBuffer("attachment;");
        header.append("filename=\"" + URLEncoder.encode(fileName, "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/octet-stream;charset=UTF-8");
    }
}

