/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.sup.BatchPublishQuoteCommand;
import com.els.base.inquiry.command.sup.CreateCommand;
import com.els.base.inquiry.command.sup.ModifyQuoteCommand;
import com.els.base.inquiry.command.sup.PreviewCommand;
import com.els.base.inquiry.command.sup.PreviewOrderItemCommand;
import com.els.base.inquiry.command.sup.PublishQuoteCommand;
import com.els.base.inquiry.command.sup.PublishSupOrderCommand;
import com.els.base.inquiry.command.sup.SupViewDetailCommand;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.InquirySupOrderExample;
import com.els.base.inquiry.entity.InquirySupReadExample;
import com.els.base.inquiry.service.InquirySupOrderService;
import com.els.base.inquiry.service.InquirySupReadService;
import com.els.base.inquiry.web.vo.MaterialTransformVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u8be2\u62a5\u4ef7-\u4f9b\u5e94\u5546-\u8868\u5934"})
@Controller
@RequestMapping(value={"inquirySupOrder"})
public class InquirySupOrderController {
    @Resource
    protected InquiryCommandInvoker invoker;
    @Resource
    protected InquirySupOrderService inquirySupOrderService;
    @Resource
    protected InquirySupReadService inquirySupReadService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8be2\u62a5\u4ef7-\u4f9b\u5e94\u5546-\u8868\u5934")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody InquirySupOrder inquirySupOrder) {
        this.inquirySupOrderService.addObj(inquirySupOrder);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8be2\u62a5\u4ef7-\u4f9b\u5e94\u5546-\u8868\u5934")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody InquirySupOrder inquirySupOrder) {
        Assert.isNotBlank((String)inquirySupOrder.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.inquirySupOrderService.modifyObj(inquirySupOrder);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8be2\u62a5\u4ef7-\u4f9b\u5e94\u5546-\u8868\u5934")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.inquirySupOrderService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8be2\u62a5\u4ef7-\u4f9b\u5e94\u5546-\u8868\u5934")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 InquirySupOrder", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<InquirySupOrder>> findByPage(@RequestParam(defaultValue="1") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        Company company = CompanyUtils.currentCompany();
        String companyId = company.getId();
        InquirySupOrderExample OrderExample = new InquirySupOrderExample();
        OrderExample.setPageView((PageView<InquirySupOrder>)new PageView(pageNo, pageSize));
        OrderExample.setOrderByClause(" PUBLISH_DATE DESC");
        InquirySupOrderExample.Criteria criteria = OrderExample.createCriteria();
        criteria.andSupCompanyIdEqualTo(companyId);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)OrderExample, (QueryParamWapper)wapper);
        }
        PageView pageData = this.inquirySupOrderService.queryObjByPage((IExample)OrderExample);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u8be6\u60c5\u754c\u9762")
    @RequestMapping(value={"service/supViewDetail"})
    @ResponseBody
    public ResponseResult<InquirySupOrder> supViewDetail(@RequestParam(required=true) String supOrderId) {
        InquirySupReadExample example = new InquirySupReadExample();
        example.createCriteria().andSupOrderIdEqualTo(supOrderId);
        List inquirySupReads = this.inquirySupReadService.queryAllObjByExample((IExample)example);
        if (!CollectionUtils.isNotEmpty((Collection)inquirySupReads)) {
            ResponseResult result = new ResponseResult();
            result.setCode("201").setMsg("\u8bf7\u9605\u8bfb\u534f\u8bae");
            return result;
        }
        SupViewDetailCommand cmd = new SupViewDetailCommand(supOrderId);
        InquirySupOrder inquirySupOrder = this.invoker.invoke(cmd);
        return ResponseResult.success((Object)inquirySupOrder);
    }

    @ApiOperation(httpMethod="POST", value="\u4fdd\u5b58\u62a5\u4ef7")
    @RequestMapping(value={"service/saveQuote"})
    @ResponseBody
    public ResponseResult<String> saveQuote(@RequestBody InquirySupOrder inquirySupOrder) {
        AbstractInquiryCommand cmd = null;
        cmd = StringUtils.isNotBlank((String)inquirySupOrder.getPurOrderId()) ? new ModifyQuoteCommand(inquirySupOrder) : new CreateCommand(inquirySupOrder);
        cmd.setSupUser(SpringSecurityUtils.getLoginUser());
        cmd.setSupCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u53d1\u5e03\u62a5\u4ef7")
    @RequestMapping(value={"service/publishQuote"})
    @ResponseBody
    public ResponseResult<String> publishQuote(@RequestBody InquirySupOrder inquirySupOrder) {
        if (StringUtils.isNotBlank((String)inquirySupOrder.getPurOrderId())) {
            ModifyQuoteCommand cmd1 = new ModifyQuoteCommand(inquirySupOrder);
            cmd1.setSupUser(SpringSecurityUtils.getLoginUser());
            cmd1.setSupCompany(CompanyUtils.currentCompany());
            this.invoker.invoke(cmd1);
            PublishQuoteCommand cmd = new PublishQuoteCommand(inquirySupOrder);
            cmd.setSupUser(SpringSecurityUtils.getLoginUser());
            cmd.setSupCompany(CompanyUtils.currentCompany());
            this.invoker.invoke(cmd);
        } else {
            PublishSupOrderCommand cmd = new PublishSupOrderCommand(inquirySupOrder);
            cmd.setSupUser(SpringSecurityUtils.getLoginUser());
            cmd.setSupCompany(CompanyUtils.currentCompany());
            this.invoker.invoke(cmd);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u6279\u91cf\u53d1\u5e03\u62a5\u4ef7")
    @RequestMapping(value={"service/batchPublishQuote"})
    @ResponseBody
    public ResponseResult<String> batchPublishQuote(@RequestBody(required=true) List<String> ids) {
        BatchPublishQuoteCommand cmd = new BatchPublishQuoteCommand(ids);
        cmd.setSupUser(SpringSecurityUtils.getLoginUser());
        cmd.setSupCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u6a21\u677fId\u9884\u89c8\u4f9b\u5e94\u5546\u8be2\u4ef7\u5355\u6570\u636e")
    @RequestMapping(value={"service/previewSupOrderByTplId"})
    @ResponseBody
    public ResponseResult<InquirySupOrder> previewSupOrderByTplId(String templateId) {
        PreviewCommand cmd = new PreviewCommand(templateId);
        cmd.setSupCompany(CompanyUtils.currentCompany());
        cmd.setSupUser(SpringSecurityUtils.getLoginUser());
        return ResponseResult.success((Object)this.invoker.invoke(cmd));
    }

    @ApiOperation(httpMethod="POST", value="\u9884\u89c8\u8868\u884c")
    @RequestMapping(value={"service/previewItem"})
    @ResponseBody
    public ResponseResult<List<IOrderItem>> previewItem(@RequestBody(required=true) MaterialTransformVo vo) {
        PreviewOrderItemCommand cmd = new PreviewOrderItemCommand(vo.getTemplateId(), vo.getMaterials());
        cmd.setSupCompany(CompanyUtils.currentCompany());
        cmd.setSupUser(SpringSecurityUtils.getLoginUser());
        return ResponseResult.success(this.invoker.invoke(cmd));
    }

    @ApiOperation(httpMethod="POST", value="\u4fdd\u5b58\u8be2\u4ef7\u5355")
    @RequestMapping(value={"service/createSupOrder"})
    @ResponseBody
    public ResponseResult<String> createSupOrder(@RequestBody(required=true) InquirySupOrder supOrder) {
        String purCompanyId = ProjectUtils.getCompanyId();
        supOrder.setPurCompanyId(purCompanyId);
        CreateCommand createCommand = new CreateCommand(supOrder);
        createCommand.setSupCompany(CompanyUtils.currentCompany());
        createCommand.setSupUser(SpringSecurityUtils.getLoginUser());
        return ResponseResult.success((Object)this.invoker.invoke(createCommand));
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u5e03\u62a5\u4ef7\u8be2\u4ef7\u5355")
    @RequestMapping(value={"service/publishSupOrder"})
    @ResponseBody
    public ResponseResult<String> publishSupOrder(@RequestBody(required=true) InquirySupOrder supOrder) {
        String purCompanyId = ProjectUtils.getCompanyId();
        supOrder.setPurCompanyId(purCompanyId);
        PublishSupOrderCommand publishSupOrderCommand = new PublishSupOrderCommand(supOrder);
        publishSupOrderCommand.setSupCompany(CompanyUtils.currentCompany());
        publishSupOrderCommand.setSupUser(SpringSecurityUtils.getLoginUser());
        return ResponseResult.success((Object)this.invoker.invoke(publishSupOrderCommand));
    }
}

