/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.pur.BatchPricingCommand;
import com.els.base.inquiry.command.pur.BatchReQuoteCommand;
import com.els.base.inquiry.command.pur.SyncPriceToSapCmd;
import com.els.base.inquiry.entity.InquiryQuoteLadder;
import com.els.base.inquiry.entity.OrderItemM001;
import com.els.base.inquiry.entity.OrderItemM001Example;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.PurOrderExample;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.enumclass.OperationTypeEnum;
import com.els.base.inquiry.service.InquiryQuoteLadderService;
import com.els.base.inquiry.service.OrderItemM001Service;
import com.els.base.inquiry.service.PurOrderService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u8be2\u62a5\u4ef7-\u884c\u6570\u636e-M001"})
@Controller
@RequestMapping(value={"orderItemM001"})
public class OrderItemM001Controller {
    @Resource
    protected OrderItemM001Service orderItemM001Service;
    @Resource
    protected PurOrderService purOrderService;
    @Resource
    protected InquiryQuoteLadderService inquiryQuoteLadderService;
    @Resource
    protected InquiryCommandInvoker invoker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8be2\u62a5\u4ef7-\u884c\u6570\u636e-M001")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody OrderItemM001 orderItemM001) {
        this.orderItemM001Service.addObj(orderItemM001);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8be2\u62a5\u4ef7-\u884c\u6570\u636e-M001")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody OrderItemM001 orderItemM001) {
        Assert.isNotBlank((String)orderItemM001.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.orderItemM001Service.modifyObj(orderItemM001);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8be2\u62a5\u4ef7-\u884c\u6570\u636e-M001")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.orderItemM001Service.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8be2\u62a5\u4ef7-\u884c\u6570\u636e-M001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 OrderItemM001", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<OrderItemM001>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        OrderItemM001Example example = new OrderItemM001Example();
        example.setPageView((PageView<OrderItemM001>)new PageView(pageNo, pageSize));
        example.createCriteria().andPurUserIdEqualTo(SpringSecurityUtils.getLoginUserId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.orderItemM001Service.queryObjByPage((IExample)example);
        this.completeAuditStatus(pageData.getQueryResult());
        return ResponseResult.success((Object)pageData);
    }

    private void completeAuditStatus(List<OrderItemM001> queryResult) {
        if (CollectionUtils.isEmpty(queryResult)) {
            return;
        }
        Map<String, List<OrderItemM001>> purOrderIdMap = queryResult.stream().collect(Collectors.groupingBy(OrderItemM001::getPurOrderId));
        ArrayList purOrderIdList = Lists.newArrayList(purOrderIdMap.keySet().iterator());
        PurOrderExample purOrderExample = new PurOrderExample();
        purOrderExample.createCriteria().andIdIn((List)purOrderIdList);
        List purOrderList = this.purOrderService.queryAllObjByExample((IExample)purOrderExample);
        purOrderIdMap.forEach((purOrderId, itemList) -> {
            Integer auditStatus = purOrderList.stream().filter(purOrder -> purOrder.getId().equals(purOrderId)).map(PurOrder::getAuditStatus).findAny().orElse(null);
            itemList.forEach(item -> item.setAuditStatus(auditStatus));
        });
    }

    @ApiOperation(httpMethod="POST", value="\u5c06\u8be2\u4ef7\u5355\u884c\u5bfc\u5165sap\u7cfb\u7edf")
    @RequestMapping(value={"service/syncPriceToSap"})
    @ResponseBody
    public ResponseResult<String> syncPriceToSap(@RequestBody List<OrderItemM001> orderItemList) {
        Assert.isNotEmpty(orderItemList, (String)"\u8be2\u4ef7\u5355\u4e0d\u5b58\u5728");
        List<IOrderItem> iOrderItemList = orderItemList.stream().map(tmp -> {
            OrderItemM001 t = tmp;
            return t;
        }).collect(Collectors.toList());
        SyncPriceToSapCmd cmd = new SyncPriceToSapCmd(iOrderItemList);
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        List<IOrderItem> failItem = this.invoker.invoke(cmd);
        if (CollectionUtils.isNotEmpty(failItem)) {
            Map<String, List<IOrderItem>> materialGroup = failItem.stream().collect(Collectors.groupingBy(IOrderItem::getMaterialDesc));
            String allWarnStr = materialGroup.keySet().stream().map(materialDesc -> {
                List tmpList = (List)materialGroup.get(materialDesc);
                String supNameStr = tmpList.stream().map(IOrderItem::getSupCompanyName).distinct().collect(Collectors.joining(","));
                String warnStr = String.format("\u7269\u6599 %s \u62a5\u4ef7\u4e2d\uff0c\u4ee5\u4e0b\u4f9b\u5e94\u5546\u62a5\u4ef7\u56de\u5199\u5931\u8d25\uff0c\u8be6\u60c5\u770b\u5931\u8d25\u539f\u56e0 :%s", materialDesc, supNameStr);
                return warnStr;
            }).collect(Collectors.joining("/n"));
            return ResponseResult.fail((ResponseCode)ResponseCode.ERROR).setI18nCode(null).setMsg(allWarnStr);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u786e\u8ba4\u6216\u62d2\u7edd\u8be2\u4ef7\u5355\u884c")
    @RequestMapping(value={"service/confirmOrRefuse"})
    @ResponseBody
    public ResponseResult<String> confirmOrRefuse(@RequestBody List<OrderItemM001> orderItemList, @RequestParam(required=true) Integer operation) {
        if (!OperationTypeEnum.isPricingOperation(operation)) {
            throw new CommonException("\u65e0\u6cd5\u8bc6\u522b\u64cd\u4f5c\u7c7b\u578b");
        }
        Assert.isNotEmpty(orderItemList, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        for (OrderItemM001 orderItem : orderItemList) {
            if (InquiryQuoteStatus.QUOTED.getCode().equals(orderItem.getQuotationStatus()) || InquiryQuoteStatus.REQUOTED.getCode().equals(orderItem.getQuotationStatus())) continue;
            throw new CommonException(String.format("\u8be2\u4ef7\u5355\u672a\u62a5\u4ef7\uff0c\u65e0\u6cd5\u786e\u8ba4\u6216\u62d2\u7edd\u3002\u7269\u6599[%s] \u4f9b\u5e94\u5546[%s]", orderItem.getMaterialDesc(), orderItem.getSupCompanyName()));
        }
        List<IOrderItem> iOrderItemList = orderItemList.stream().map(temp -> {
            OrderItemM001 orderItem = temp;
            orderItem.setOperation(operation);
            return orderItem;
        }).collect(Collectors.toList());
        BatchPricingCommand batchPricingCommand = new BatchPricingCommand(iOrderItemList);
        batchPricingCommand.setPurUser(SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(batchPricingCommand);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u91cd\u62a5\u4ef7")
    @RequestMapping(value={"service/batchReQuote"})
    @ResponseBody
    public ResponseResult<String> batchReQuote(@RequestBody List<OrderItemM001> orderItemList) {
        Assert.isNotEmpty(orderItemList, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        List<IOrderItem> iOrderItemList = orderItemList.stream().map(temp -> {
            OrderItemM001 orderItem = temp;
            return orderItem;
        }).collect(Collectors.toList());
        BatchReQuoteCommand batchReQuoteCommand = new BatchReQuoteCommand(iOrderItemList);
        batchReQuoteCommand.setPurUser(SpringSecurityUtils.getLoginUser());
        batchReQuoteCommand.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(batchReQuoteCommand);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u9636\u68af\u62a5\u4ef7")
    @RequestMapping(value={"service/queryLadderPrice"})
    @ResponseBody
    public ResponseResult<List<InquiryQuoteLadder>> queryLadderPrice(String orderItemId) {
        Assert.isNotBlank((String)orderItemId, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        return ResponseResult.success(this.inquiryQuoteLadderService.queryByOrderItemId(orderItemId));
    }

    @ApiOperation(httpMethod="POST", value="\u8be2\u62a5\u4ef7M001\u6253\u5370")
    @RequestMapping(value={"service/print"})
    @ResponseBody
    public ResponseResult<FileData> print(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u6570\u636e\u4e3a\u7a7a");
        FileData fileData = this.orderItemM001Service.print(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), ids);
        return ResponseResult.success((Object)fileData);
    }
}

