/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.template.CreateTemplateConfCmd;
import com.els.base.inquiry.command.template.DeleteTemplateConfCmd;
import com.els.base.inquiry.command.template.ModifyTemplateConfCmd;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.entity.TemplateConfExample;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.inquiry.utils.InquiryConstant;
import com.els.base.inquiry.utils.PropertyDefUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u8be2\u62a5\u4ef7-\u6a21\u677f\u914d\u7f6e\u4fe1\u606f"})
@Controller
@RequestMapping(value={"templateConf"})
public class TemplateConfController {
    @Resource
    protected TemplateConfService templateConfService;
    @Resource
    private InquiryCommandInvoker invoker;
    @Resource
    private TplOrderItemDetailService tplOrderItemDetailService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8be2\u62a5\u4ef7-\u6a21\u677f\u914d\u7f6e\u4fe1\u606f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody TemplateConf templateConf) {
        CreateTemplateConfCmd cmd = new CreateTemplateConfCmd(templateConf);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        return ResponseResult.success((Object)this.invoker.invoke(cmd));
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8be2\u62a5\u4ef7-\u6a21\u677f\u914d\u7f6e\u4fe1\u606f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody TemplateConf templateConf) {
        Assert.isNotBlank((String)templateConf.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        ModifyTemplateConfCmd cmd = new ModifyTemplateConfCmd(templateConf);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        return ResponseResult.success((Object)this.invoker.invoke(cmd));
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8be2\u62a5\u4ef7-\u6a21\u677f\u914d\u7f6e\u4fe1\u606f")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestBody List<String> idList) {
        Assert.isNotEmpty(idList, (String)"\u5220\u9664\u5931\u8d25,\u6a21\u677f\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        DeleteTemplateConfCmd cmd = new DeleteTemplateConfCmd(idList);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8be2\u62a5\u4ef7-\u6a21\u677f\u914d\u7f6e\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 TemplateConf", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<TemplateConf>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        TemplateConfExample example = new TemplateConfExample();
        example.setPageView((PageView<TemplateConf>)new PageView(pageNo, pageSize));
        TemplateConfExample.Criteria criteria = example.createCriteria();
        criteria.andIsHisEqualTo(Constant.NO_INT);
        example.setOrderByClause("CREATE_TIME DESC");
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.templateConfService.queryObjByPage((IExample)example);
        pageData.getQueryResult().forEach(templateConf -> {
            templateConf.setOrderItemPropertyDefList(PropertyDefUtils.queryOrderItemProDef(templateConf));
            if (Constant.YES_INT.equals(templateConf.getIsBusiCondEnable())) {
                templateConf.setBusiConditionPropertyDefList(PropertyDefUtils.queryBusiConditionProDef(templateConf));
            }
            if (Constant.YES_INT.equals(templateConf.getIsOrderItemDetailEnable()) && StringUtils.isNotBlank((String)templateConf.getOrderItemDtlTplId())) {
                templateConf.setTplOrderItemDetail((TplOrderItemDetail)this.tplOrderItemDetailService.queryObjById(templateConf.getOrderItemDtlTplId()));
            }
        });
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636eId\u67e5\u8be2\u8be2\u62a5\u4ef7-\u6a21\u677f\u914d\u7f6e\u4fe1\u606f")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<TemplateConf> findById(@RequestParam(required=true) String id) {
        TemplateConf templateConf = (TemplateConf)this.templateConfService.queryObjById(id);
        Assert.isNotNull((Object)templateConf, (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        return ResponseResult.success((Object)templateConf);
    }

    @ApiOperation(httpMethod="GET", value="\u8be2\u62a5\u4ef7-\u6a21\u5177\u6210\u672c\u6e05\u5355\u6a21\u677f\u521b\u5efa\u9884\u89c8")
    @RequestMapping(value={"service/preview"})
    @ResponseBody
    public ResponseResult<TemplateConf> preview() {
        TemplateConf templateConf = new TemplateConf();
        String dateFormat = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
        templateConf.setCode(String.format("TPL_CONF_%s", dateFormat));
        templateConf.setName(String.format("\u8be2\u4ef7\u5355\u6a21\u677f_%s", dateFormat));
        templateConf.setIsAttachmentEnable(Constant.YES_INT);
        templateConf.setIsBusiCondEnable(Constant.YES_INT);
        templateConf.setIsLadderPriceEnable(Constant.NO_INT);
        templateConf.setIsMouldEnable(Constant.NO_INT);
        templateConf.setIsMouldDetailEnable(Constant.NO_INT);
        templateConf.setIsOrderItemDetailEnable(Constant.NO_INT);
        templateConf.setOrderItemPropertyDefList(PropertyDefUtils.getProperyDefByClass(templateConf.getOrderItemClass()));
        templateConf.setBusiConditionPropertyDefList(PropertyDefUtils.getProperyDefByClass(templateConf.getBusiConditionClass()));
        templateConf.setTargetClassName(InquiryConstant.DEFALUT_TARGET_CLS.getName());
        templateConf.setTargetServiceClassName(InquiryConstant.DEFALUT_TARGET_SERVICE_CLS.getName());
        templateConf.setItemClassName(InquiryConstant.DEFALUT_ORDER_TIEM_CLS.getName());
        templateConf.setItemServiceClassName(InquiryConstant.DEFALUT_ORDER_TIEM_SERVICE_CLS.getName());
        templateConf.setBusiCondClassName(InquiryConstant.DEFALUT_BUSI_CONDITION_CLS.getName());
        templateConf.setBusiCondServiceClassName(InquiryConstant.DEFALUT_BUSI_CONDITION_SERVICE_CLS.getName());
        return ResponseResult.success((Object)templateConf);
    }
}

