/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.service.CompanySapRelationService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.service.InformationRecordService;
import com.els.base.inquiry.service.InquiryBusiConditionService;
import com.els.base.inquiry.service.InquiryPurFileService;
import com.els.base.inquiry.service.InquiryQuoteLadderService;
import com.els.base.inquiry.service.InquirySupFileService;
import com.els.base.inquiry.service.InquirySupOrderService;
import com.els.base.inquiry.service.InquirySupplierService;
import com.els.base.inquiry.service.InquiryWaitMaterialService;
import com.els.base.inquiry.service.MaterielParityService;
import com.els.base.inquiry.service.PropertyDefService;
import com.els.base.inquiry.service.PropertyValueService;
import com.els.base.inquiry.service.PurOrderService;
import com.els.base.inquiry.service.SystemPriceService;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.material.service.MaterialService;
import com.els.base.materialprice.service.MaterialPriceService;
import com.els.base.mould.master.service.MouldService;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.workflow.common.service.WorkFlowService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class InquiryCommandInvoker {
    private static final Logger logger = LoggerFactory.getLogger(InquiryCommandInvoker.class);
    @Resource
    private CompanyService companyService;
    @Resource
    private PurOrderService purOrderService;
    @Resource
    protected TemplateConfService templateConfService;
    @Resource
    protected InquirySupplierService inquirySupplierService;
    @Resource
    protected InquiryPurFileService inquiryPurFileService;
    @Resource
    protected InquirySupOrderService inquirySupOrderService;
    @Resource
    private InquirySupFileService inquirySupFileService;
    @Resource
    private InquiryBusiConditionService inquiryBusiConditionService;
    @Resource
    private InquiryQuoteLadderService inquiryQuoteLadderService;
    @Resource
    private GenerateCodeService generateCodeService;
    @Resource
    private PropertyDefService propertyDefService;
    @Resource
    private PropertyValueService propertyValueService;
    @Resource
    private InquiryWaitMaterialService inquiryWaitMaterialService;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private TplOrderItemDetailService tplOrderItemDetailService;
    @Resource
    private WorkFlowService workFlowService;
    @Resource
    private SystemPriceService systemPriceService;
    @Resource
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Resource
    private MaterialService materialService;
    @Resource
    private InformationRecordService informationRecordService;
    @Resource
    private MaterielParityService materielParityService;
    @Resource
    private MouldService mouldService;
    @Resource
    private CompanySapRelationService companySapRelationService;
    @Resource
    private MaterialPriceService materialPriceService;

    @Transactional
    public <Result> Result invoke(AbstractInquiryCommand<Result> cmd) {
        String key = UUIDGenerator.generateUUID();
        long t1 = System.currentTimeMillis();
        logger.debug("\u5f00\u59cb\u6267\u884c\u547d\u4ee4[{}] key[{}]", cmd.getClass(), (Object)key);
        cmd.setInvoker(this);
        Result result = cmd.execute(this);
        logger.debug("\u7ed3\u675f\u6267\u884c\u547d\u4ee4[{}] key[{}],\u8017\u65f6[{}]", new Object[]{cmd.getClass(), key, System.currentTimeMillis() - t1});
        return result;
    }

    public TemplateConfService getTemplateConfService() {
        return this.templateConfService;
    }

    public PurOrderService getPurOrderService() {
        return this.purOrderService;
    }

    public InquirySupplierService getInquirySupplierService() {
        return this.inquirySupplierService;
    }

    public InquiryPurFileService getInquiryPurFileService() {
        return this.inquiryPurFileService;
    }

    public InquirySupOrderService getInquirySupOrderService() {
        return this.inquirySupOrderService;
    }

    public InquirySupFileService getInquirySupFileService() {
        return this.inquirySupFileService;
    }

    public InquiryBusiConditionService getInquiryBusiConditionService() {
        return this.inquiryBusiConditionService;
    }

    public InquiryQuoteLadderService getInquiryQuoteLadderService() {
        return this.inquiryQuoteLadderService;
    }

    public GenerateCodeService getGenerateCodeService() {
        return this.generateCodeService;
    }

    public PropertyDefService getPropertyDefService() {
        return this.propertyDefService;
    }

    public PropertyValueService getPropertyValueService() {
        return this.propertyValueService;
    }

    public InquiryWaitMaterialService getInquiryWaitMaterialService() {
        return this.inquiryWaitMaterialService;
    }

    public CompanyUserRefService getCompanyUserRefService() {
        return this.companyUserRefService;
    }

    public TplOrderItemDetailService getTplOrderItemDetailService() {
        return this.tplOrderItemDetailService;
    }

    public WorkFlowService getWorkFlowService() {
        return this.workFlowService;
    }

    public SystemPriceService getSystemPriceService() {
        return this.systemPriceService;
    }

    public ThreadPoolTaskExecutor getThreadPoolTaskExecutor() {
        return this.threadPoolTaskExecutor;
    }

    public MaterialService getMaterialService() {
        return this.materialService;
    }

    public InformationRecordService getInformationRecordService() {
        return this.informationRecordService;
    }

    public MaterielParityService getMaterielParityService() {
        return this.materielParityService;
    }

    public MouldService getMouldService() {
        return this.mouldService;
    }

    public CompanyService getCompanyService() {
        return this.companyService;
    }

    public CompanySapRelationService getCompanySapRelationService() {
        return this.companySapRelationService;
    }

    public MaterialPriceService getMaterialPriceService() {
        return this.materialPriceService;
    }
}

